/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestSuite;
import ucar.ma2.Array;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.TestMiscIosp;
import ucar.nc2.iosp.gempak.TestReadingGempak;
import ucar.nc2.iosp.grib.TestGridGribIosp;
import ucar.nc2.iosp.grib.TestHybridData;
import ucar.nc2.iosp.grib.TestIntervalsTimeCoords;
import ucar.nc2.iosp.grib.TestOfsData;
import ucar.nc2.iosp.hdf4.TestH4;
import ucar.nc2.iosp.hdf5.TestH5;
import ucar.nc2.util.CompareNetcdf;

public class TestIosp {
    private static Random r = new Random(System.currentTimeMillis());

    public static Test suite() {
        TestSuite suite = new TestSuite();
        suite.addTest((Test)new TestSuite(TestHybridData.class));
        suite.addTest((Test)new TestSuite(TestOfsData.class));
        suite.addTest((Test)new TestSuite(TestGridGribIosp.class));
        suite.addTest((Test)new TestSuite(TestIntervalsTimeCoords.class));
        suite.addTest((Test)new TestSuite(TestReadingGempak.class));
        suite.addTest((Test)new TestSuite(TestMiscIosp.class));
        suite.addTest(TestH5.suite());
        suite.addTest(TestH4.suite());
        return suite;
    }

    public static void testVariableSubset(String filename, String varName, int ntrials) throws InvalidRangeException, IOException {
        Array A;
        System.out.println("testVariableSubset=" + filename + "," + varName);
        NetcdfFile ncfile = NetcdfFile.open((String)filename);
        Variable v = ncfile.findVariable(varName);
        assert (null != v);
        int[] shape = v.getShape();
        try {
            A = v.read();
        }
        catch (IOException e) {
            System.err.println("ERROR reading file");
            assert (false);
            return;
        }
        int[] dataShape = A.getShape();
        assert (dataShape.length == shape.length);
        for (int i = 0; i < shape.length; ++i) {
            assert (dataShape[i] == shape[i]);
        }
        Section all = v.getShapeAsSection();
        System.out.println("  Entire dataset=" + all);
        for (int k = 0; k < ntrials; ++k) {
            TestIosp.testOne(v, TestIosp.randomSubset(all, 1), A);
            TestIosp.testOne(v, TestIosp.randomSubset(all, 2), A);
            TestIosp.testOne(v, TestIosp.randomSubset(all, 3), A);
        }
        ncfile.close();
    }

    public static void testVariableSubset(String filename, String varName, Section s) throws InvalidRangeException, IOException {
        System.out.println("testVariableSubset=" + filename + "," + varName);
        NetcdfFile ncfile = NetcdfFile.open((String)filename);
        Variable v = ncfile.findVariable(varName);
        assert (null != v);
        TestIosp.testOne(v, s, v.read());
    }

    public static void testOne(Variable v, Section s, Array fullData) throws IOException, InvalidRangeException {
        System.out.println("   section=" + s);
        Array sdata = v.read(s);
        assert (sdata.getRank() == s.getRank());
        int[] sshape = sdata.getShape();
        for (int i = 0; i < sshape.length; ++i) {
            assert (sshape[i] == s.getShape(i));
        }
        Array Asection = fullData.sectionNoReduce(s.getRanges());
        int[] ashape = Asection.getShape();
        assert (ashape.length == sdata.getRank());
        for (int i = 0; i < ashape.length; ++i) {
            assert (sshape[i] == ashape[i]);
        }
        CompareNetcdf.compareData((Array)sdata, (Array)Asection);
    }

    private static Section randomSubset(Section all, int stride) throws InvalidRangeException {
        Section s = new Section();
        for (Range r : all.getRanges()) {
            int first = TestIosp.random(r.first(), r.last() / 2);
            int last = TestIosp.random(r.last() / 2, r.last());
            s.appendRange(first, last, stride);
        }
        return s;
    }

    private static int random(int first, int last) {
        return first + r.nextInt(last - first + 1);
    }
}

