/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;

public class TestLargeGeneration {
    static String latVar = "lat";
    static String lonVar = "lon";
    static String timeVar = "time";
    static String unitsAttName = "units";
    static String axisAttName = "axis";
    static String standardNameAttName = "standard_name";
    static String longNameAttName = "long_name";
    static float fillValue = -9999.0f;
    static String missingValueAttName = "missing_value";
    static String fillValueAttName = "_FillValue";
    static String variableName = "testVar";
    static int LON_LEN = 300;
    static int LAT_LEN = 300;
    static int TIME_LEN = 40000;
    static String units = "mm";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException, InvalidRangeException {
        String filename = "C:/temp/test3.nc";
        long startAll = System.nanoTime();
        NetcdfFileWriteable writeableFile = null;
        try {
            writeableFile = TestLargeGeneration.createLatLonTimeDataCube(filename);
            ArrayFloat.D3 variableData = new ArrayFloat.D3(1, LON_LEN, TIME_LEN);
            Array latData = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{1});
            int[] origin = new int[]{0, 0, 0};
            int[] lat_origin = new int[]{0};
            for (int lat = 0; lat < LAT_LEN; ++lat) {
                long start = System.nanoTime();
                latData.setFloat(latData.getIndex(), (float)((double)lat / 10.0));
                for (int lon = 0; lon < LON_LEN; ++lon) {
                    for (int time = 0; time < TIME_LEN; ++time) {
                        variableData.set(0, lon, time, (float)time);
                    }
                }
                origin[0] = lat;
                lat_origin[0] = lat;
                writeableFile.write(variableName, origin, (Array)variableData);
                writeableFile.write(latVar, lat_origin, latData);
                writeableFile.flush();
                long end = System.nanoTime();
                System.out.printf("write lat= %d time=%f msecs %n", lat, (double)((end - start) / 1000L) / 1000.0);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        finally {
            if (writeableFile != null) {
                writeableFile.close();
            }
        }
        long endAll = System.nanoTime();
        System.out.printf("total time=%f secs %n", (double)((endAll - startAll) / 1000L) / 1000.0 / 1000.0);
    }

    private static NetcdfFileWriteable createLatLonTimeDataCube(String filename) throws IOException, InvalidRangeException {
        int i;
        NetcdfFileWriteable writeableFile = NetcdfFileWriteable.createNew((String)filename);
        writeableFile.setLargeFile(true);
        writeableFile.setFill(false);
        Dimension timeDim = writeableFile.addDimension(timeVar, TIME_LEN);
        Dimension latDim = writeableFile.addUnlimitedDimension(latVar);
        Dimension lonDim = writeableFile.addDimension(lonVar, LON_LEN);
        Dimension[] dim3 = new Dimension[]{latDim, lonDim, timeDim};
        TestLargeGeneration.defineHeader(writeableFile, timeDim, latDim, lonDim, dim3);
        writeableFile.create();
        System.out.printf("file=%s%n", writeableFile);
        float[] longitudes = new float[LON_LEN];
        int[] times = new int[TIME_LEN];
        for (i = 0; i < times.length; ++i) {
            times[i] = i;
        }
        for (i = 0; i < longitudes.length; ++i) {
            longitudes[i] = i;
        }
        writeableFile.write(lonVar, Array.factory((Object)longitudes));
        writeableFile.write(timeVar, Array.factory((Object)times));
        return writeableFile;
    }

    private static void defineHeader(NetcdfFileWriteable writeableFile, Dimension timeDim, Dimension latDim, Dimension lonDim, Dimension[] dim3) {
        Dimension[] spatialDim = new Dimension[]{latDim, lonDim};
        writeableFile.addVariable(latVar, DataType.FLOAT, new Dimension[]{latDim});
        writeableFile.addVariableAttribute(latVar, unitsAttName, "degrees_north");
        writeableFile.addVariableAttribute(latVar, axisAttName, "Y");
        writeableFile.addVariableAttribute(latVar, standardNameAttName, "latitude");
        writeableFile.addVariable(lonVar, DataType.FLOAT, new Dimension[]{lonDim});
        writeableFile.addVariableAttribute(lonVar, unitsAttName, "degrees_east");
        writeableFile.addVariableAttribute(lonVar, axisAttName, "X");
        writeableFile.addVariableAttribute(lonVar, standardNameAttName, "longitude");
        writeableFile.addVariable(variableName, DataType.FLOAT, dim3);
        writeableFile.addVariableAttribute(variableName, longNameAttName, variableName);
        writeableFile.addVariableAttribute(variableName, unitsAttName, units);
        writeableFile.addVariableAttribute(variableName, missingValueAttName, (Number)new Float(fillValue));
        writeableFile.addVariableAttribute(variableName, fillValueAttName, (Number)new Float(fillValue));
        writeableFile.addVariable("cellId", DataType.STRING, spatialDim);
        writeableFile.addVariableAttribute("cellId", longNameAttName, "Cell ID");
        writeableFile.addVariable(timeVar, DataType.INT, new Dimension[]{timeDim});
        writeableFile.addVariableAttribute(timeVar, unitsAttName, "days since 1889-01-01");
        writeableFile.addVariableAttribute(timeVar, axisAttName, "T");
        writeableFile.addVariableAttribute(timeVar, standardNameAttName, timeVar);
        writeableFile.addVariableAttribute(timeVar, longNameAttName, timeVar);
    }
}

