/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.File;
import junit.extensions.TestSetup;
import junit.framework.Test;
import junit.framework.TestSuite;
import ucar.ma2.TestMA2;
import ucar.nc2.TestLocalNC2;
import ucar.nc2.units.TestUnitsAll;
import ucar.nc2.util.TestDatasetURL;
import ucar.unidata.io.RandomAccessFile;

public class TestLocal {
    public static long startTime;
    public static String cdmTestDataDir;
    public static String temporaryDataDir;

    public static Test suite() {
        RandomAccessFile.setDebugLeaks((boolean)true);
        TestSuite suite = new TestSuite();
        suite.addTest(TestMA2.suite());
        suite.addTest(TestLocalNC2.suite());
        suite.addTest(TestUnitsAll.suite());
        suite.addTest((Test)new TestSuite(TestDatasetURL.class));
        TestSetup wrapper = new TestSetup((Test)suite){

            protected void setUp() {
                RandomAccessFile.setDebugLeaks((boolean)true);
                startTime = System.currentTimeMillis();
            }

            protected void tearDown() {
                TestLocal.checkLeaks();
                TestLocal.checkLeaks();
                double took = (double)(System.currentTimeMillis() - startTime) * 0.001;
                System.out.println(" that took= " + took + " secs");
            }
        };
        return wrapper;
    }

    private static void checkLeaks() {
        for (String filename : RandomAccessFile.getOpenFiles()) {
            System.out.println(" open= " + filename);
        }
    }

    public static boolean closeEnough(double d1, double d2) {
        if (d1 < 1.0E-5) {
            return Math.abs(d1 - d2) < 1.0E-5;
        }
        return Math.abs((d1 - d2) / d1) < 1.0E-5;
    }

    public static boolean closeEnough(double d1, double d2, double tol) {
        if (d1 < tol) {
            return Math.abs(d1 - d2) < tol;
        }
        return Math.abs((d1 - d2) / d1) < tol;
    }

    public static boolean closeEnough(float d1, float d2) {
        if ((double)d1 < 1.0E-5) {
            return (double)Math.abs(d1 - d2) < 1.0E-5;
        }
        return (double)Math.abs((d1 - d2) / d1) < 1.0E-5;
    }

    public static void showMem(String where) {
        Runtime runtime = Runtime.getRuntime();
        System.out.println(where + " memory free = " + (double)runtime.freeMemory() * 0.001 * 0.001 + " total= " + (double)runtime.totalMemory() * 0.001 * 0.001 + " max= " + (double)runtime.maxMemory() * 0.001 * 0.001 + " MB");
    }

    static {
        cdmTestDataDir = "src/test/data/";
        temporaryDataDir = "target/test/tmp/";
        File tmpDataDir = new File(temporaryDataDir);
        if (!tmpDataDir.exists() && !tmpDataDir.mkdirs()) {
            System.out.println("**ERROR: Could not create temporary data dir <" + tmpDataDir.getAbsolutePath() + ">.");
        }
    }
}

