/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import java.util.Set;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayStructure;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.TestLocal;
import ucar.nc2.TestLocalNC2;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.StructureDS;

public class TestReadRecord
extends TestCase {
    public TestReadRecord(String name) {
        super(name);
    }

    public void testNC3ReadRecordV3mode() {
        try {
            NetcdfFile nc = TestLocalNC2.openFile("testWriteRecord.nc");
            String title = nc.findAttValueIgnoreCase(null, "title", "N/A");
            Variable lat = nc.findVariable("lat");
            assert (lat.getRank() == 1);
            int nlats = lat.getShape()[0];
            double[] lats = new double[nlats];
            Array values = lat.read();
            Index ima = values.getIndex();
            for (int ilat = 0; ilat < nlats; ++ilat) {
                lats[ilat] = values.getDouble(ima.set0(ilat));
            }
            String latUnits = nc.findAttValueIgnoreCase(lat, "units", "N/A");
            assert (latUnits.equals("degrees_north"));
            Variable lon = nc.findVariable("lon");
            values = lon.read();
            assert (values instanceof ArrayFloat.D1);
            ArrayFloat.D1 fa = (ArrayFloat.D1)values;
            assert (TestLocal.closeEnough(fa.get(0), -109.0f)) : fa.get(0);
            assert (TestLocal.closeEnough(fa.get(1), -107.0f)) : fa.get(1);
            assert (TestLocal.closeEnough(fa.get(2), -105.0f)) : fa.get(2);
            assert (TestLocal.closeEnough(fa.get(3), -103.0f)) : fa.get(3);
            Variable time = nc.findVariable("time");
            assert (time != null);
            Array timeValues = time.read();
            assert (timeValues instanceof ArrayInt.D1);
            ArrayInt.D1 ta = (ArrayInt.D1)timeValues;
            assert (ta.get(0) == 6) : ta.get(0);
            assert (ta.get(1) == 18) : ta.get(1);
            Variable rh = nc.findVariable("rh");
            Array rhValues = rh.read();
            assert (rhValues instanceof ArrayInt.D3);
            ArrayInt.D3 rha = (ArrayInt.D3)rhValues;
            int[] shape = rha.getShape();
            for (int i = 0; i < shape[0]; ++i) {
                for (int j = 0; j < shape[1]; ++j) {
                    for (int k = 0; k < shape[2]; ++k) {
                        int want = 20 * i + 4 * j + k + 1;
                        int val = rha.get(i, j, k);
                        assert (want == val) : val;
                    }
                }
            }
            Variable t = nc.findVariable("T");
            Array tValues = t.read();
            assert (tValues instanceof ArrayDouble.D3);
            ArrayDouble.D3 Ta = (ArrayDouble.D3)tValues;
            assert (TestLocal.closeEnough(Ta.get(0, 0, 0), 1.0)) : Ta.get(0, 0, 0);
            assert (TestLocal.closeEnough(Ta.get(1, 1, 1), 10.0)) : Ta.get(1, 1, 1);
            tValues = t.read(new int[3], new int[]{2, 2, 2});
            assert (tValues instanceof ArrayDouble.D3);
            Ta = (ArrayDouble.D3)tValues;
            assert (TestLocal.closeEnough(Ta.get(0, 0, 0), 1.0)) : Ta.get(0, 0, 0);
            assert (TestLocal.closeEnough(Ta.get(1, 1, 1), 10.0)) : Ta.get(1, 1, 1);
            nc.close();
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("**** testNC3ReadRecordV3mode done");
    }

    public void testNC3ReadRecordN4mode() {
        try {
            NetcdfFile nc = TestLocalNC2.openFile("testWriteRecord.nc");
            nc.sendIospMessage((Object)"AddRecordStructure");
            String title = nc.findAttValueIgnoreCase(null, "title", "N/A");
            Variable lat = nc.findVariable("lat");
            assert (lat.getRank() == 1);
            int nlats = lat.getShape()[0];
            double[] lats = new double[nlats];
            Array values = lat.read();
            Index ima = values.getIndex();
            for (int ilat = 0; ilat < nlats; ++ilat) {
                lats[ilat] = values.getDouble(ima.set0(ilat));
            }
            String latUnits = nc.findAttValueIgnoreCase(lat, "units", "N/A");
            assert (latUnits.equals("degrees_north"));
            Variable lon = nc.findVariable("lon");
            values = lon.read();
            assert (values instanceof ArrayFloat.D1);
            ArrayFloat.D1 fa = (ArrayFloat.D1)values;
            assert (TestLocal.closeEnough(fa.get(0), -109.0f)) : fa.get(0);
            assert (TestLocal.closeEnough(fa.get(1), -107.0f)) : fa.get(1);
            assert (TestLocal.closeEnough(fa.get(2), -105.0f)) : fa.get(2);
            assert (TestLocal.closeEnough(fa.get(3), -103.0f)) : fa.get(3);
            Variable record = nc.findVariable("record");
            assert (record instanceof Structure);
            Structure rs = (Structure)record;
            assert (rs.getRank() == 1);
            assert (rs.getDimension(0).getLength() == 2);
            Array rsValues = rs.read();
            assert (rsValues instanceof ArrayStructure);
            assert (rsValues.getRank() == 1);
            assert (rsValues.getShape()[0] == 2);
            Variable time = rs.findVariable("time");
            Array timeValues = time.read();
            assert (timeValues instanceof ArrayInt.D0) : timeValues.getClass().getName();
            ArrayInt.D0 ta = (ArrayInt.D0)timeValues;
            assert (ta.get() == 6) : ta.get();
            Variable rh = rs.findVariable("rh");
            Array rhValues = rh.read();
            assert (rhValues instanceof ArrayInt.D2);
            ArrayInt.D2 rha = (ArrayInt.D2)rhValues;
            int[] shape = rha.getShape();
            for (int j = 0; j < shape[0]; ++j) {
                for (int k = 0; k < shape[1]; ++k) {
                    int want = 4 * j + k + 1;
                    int val = rha.get(j, k);
                    assert (want == val) : val;
                }
            }
            nc.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("*** testNC3ReadRecordN4mode done");
    }

    public void testDatasetAddRecord() throws InvalidRangeException, IOException {
        NetcdfDataset nc = NetcdfDataset.openDataset((String)(TestLocal.cdmTestDataDir + "testWriteRecord.nc"), (Set)NetcdfDataset.getDefaultEnhanceMode(), (int)-1, null, (Object)"AddRecordStructure");
        Variable record = nc.findVariable("record");
        assert (record instanceof StructureDS);
        StructureDS rs = (StructureDS)record;
        assert (rs.getRank() == 1);
        assert (rs.getDimension(0).getLength() == 2);
        Array rsValues = rs.read("1:1:2");
        assert (rsValues instanceof ArrayStructure);
        assert (rsValues.getRank() == 1);
        assert (rsValues.getShape()[0] == 1);
        StructureData sdata = (StructureData)rsValues.getObject(rsValues.getIndex());
        Array gdata = sdata.getArray("time");
        assert (gdata instanceof ArrayInt.D0) : gdata.getClass().getName();
        ArrayInt.D0 tdata = (ArrayInt.D0)gdata;
        int t = tdata.get();
        assert (t == 18);
        int t2 = sdata.getScalarInt("time");
        assert (t2 == 18);
        Variable time = rs.findVariable("time");
        assert (time != null);
        Array timeValues = time.read();
        assert (timeValues instanceof ArrayInt.D0);
        ArrayInt.D0 ta = (ArrayInt.D0)timeValues;
        assert (ta.get() == 6) : ta.get();
        nc.close();
    }

    public void testDatasetAddRecordAfter() throws InvalidRangeException, IOException {
        NetcdfDataset nc = NetcdfDataset.openDataset((String)(TestLocal.cdmTestDataDir + "testWriteRecord.nc"));
        assert (((Boolean)nc.sendIospMessage((Object)"AddRecordStructure")).booleanValue());
        Variable record = nc.findVariable("record");
        assert (record instanceof StructureDS);
        StructureDS rs = (StructureDS)record;
        assert (rs.getRank() == 1);
        assert (rs.getDimension(0).getLength() == 2);
        Array rsValues = rs.read("1:1:2");
        assert (rsValues instanceof ArrayStructure);
        assert (rsValues.getRank() == 1);
        assert (rsValues.getShape()[0] == 1);
        StructureData sdata = (StructureData)rsValues.getObject(rsValues.getIndex());
        Array gdata = sdata.getArray("time");
        assert (gdata instanceof ArrayInt.D0) : gdata.getClass().getName();
        ArrayInt.D0 tdata = (ArrayInt.D0)gdata;
        int t = tdata.get();
        assert (t == 18);
        int t2 = sdata.getScalarInt("time");
        assert (t2 == 18);
        Variable time = rs.findVariable("time");
        Array timeValues = time.read();
        assert (timeValues instanceof ArrayInt.D0);
        ArrayInt.D0 ta = (ArrayInt.D0)timeValues;
        assert (ta.get() == 6) : ta.get();
        nc.close();
    }

    public void testNC3ReadRecordStrided() throws InvalidRangeException, IOException {
        NetcdfFile nc = TestLocalNC2.openFile("testWriteRecord.nc");
        nc.sendIospMessage((Object)"AddRecordStructure");
        Variable record = nc.findVariable("record");
        assert (record instanceof Structure);
        Structure rs = (Structure)record;
        assert (rs.getRank() == 1);
        assert (rs.getDimension(0).getLength() == 2);
        Array rsValues = rs.read("1:1:2");
        assert (rsValues instanceof ArrayStructure);
        assert (rsValues.getRank() == 1);
        assert (rsValues.getShape()[0] == 1);
        StructureData sdata = (StructureData)rsValues.getObject(rsValues.getIndex());
        Array gdata = sdata.getArray("time");
        assert (gdata instanceof ArrayInt.D0) : gdata.getClass().getName();
        ArrayInt.D0 tdata = (ArrayInt.D0)gdata;
        int t = tdata.get();
        assert (t == 18);
        int t2 = sdata.getScalarInt("time");
        assert (t2 == 18);
        nc.close();
    }
}

