/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.TestLocal;
import ucar.nc2.Variable;
import ucar.nc2.util.CompareNetcdf;

public class TestSlice
extends TestCase {
    private static final String NETCDF_FILE = TestLocal.cdmTestDataDir + "testSlice.nc";
    private static final String DATA_VARIABLE = "data";
    private static final int DIM_T = 10;
    private static final int DIM_ALT = 5;
    private static final int DIM_LAT = 123;
    private static final int DIM_LON = 234;

    public TestSlice(String name) {
        super(name);
    }

    public void setUp() throws IOException {
        NetcdfFileWriteable file = NetcdfFileWriteable.createNew((String)NETCDF_FILE);
        Dimension t = new Dimension("t", 10, true);
        Dimension alt = new Dimension("alt", 5, true);
        Dimension lat = new Dimension("lat", 123, true);
        Dimension lon = new Dimension("lon", 234, true);
        file.addDimension(null, t);
        file.addDimension(null, alt);
        file.addDimension(null, lat);
        file.addDimension(null, lon);
        Dimension[] dims = new Dimension[]{t, alt, lat, lon};
        file.addVariable(DATA_VARIABLE, DataType.FLOAT, dims);
        file.create();
    }

    public void tearDown() {
    }

    private Array createData() {
        ArrayFloat.D4 values = new ArrayFloat.D4(10, 5, 123, 234);
        for (int i = 0; i < 10; ++i) {
            for (int j = 0; j < 5; ++j) {
                for (int k = 0; k < 123; ++k) {
                    for (int l = 0; l < 234; ++l) {
                        values.set(i, j, k, l, (float)(i + j));
                    }
                }
            }
        }
        return values;
    }

    public void testFill() throws IOException, InvalidRangeException {
        NetcdfFileWriteable file = NetcdfFileWriteable.openExisting((String)NETCDF_FILE);
        file.write(DATA_VARIABLE, this.createData());
    }

    public void testSlice1() throws IOException, InvalidRangeException {
        NetcdfFile file = NetcdfFile.open((String)NETCDF_FILE);
        Variable var = file.findVariable(DATA_VARIABLE);
        Variable sliced = var.slice(0, 3);
        sliced.read();
        int[] shape = sliced.getShape();
        TestSlice.assertEquals((int)3, (int)shape.length);
        TestSlice.assertEquals((int)5, (int)shape[0]);
        TestSlice.assertEquals((int)123, (int)shape[1]);
        TestSlice.assertEquals((int)234, (int)shape[2]);
        TestSlice.assertEquals((String)"alt lat lon", (String)sliced.getDimensionsString());
    }

    public void testSlice2() throws IOException, InvalidRangeException {
        NetcdfFile file = NetcdfFile.open((String)NETCDF_FILE);
        Variable var = file.findVariable(DATA_VARIABLE);
        Variable sliced = var.slice(1, 3);
        sliced.read();
        int[] shape = sliced.getShape();
        TestSlice.assertEquals((int)3, (int)shape.length);
        TestSlice.assertEquals((int)10, (int)shape[0]);
        TestSlice.assertEquals((int)123, (int)shape[1]);
        TestSlice.assertEquals((int)234, (int)shape[2]);
        TestSlice.assertEquals((String)"t lat lon", (String)sliced.getDimensionsString());
    }

    public void testSlice3() throws IOException, InvalidRangeException {
        NetcdfFile file = NetcdfFile.open((String)NETCDF_FILE);
        Variable var = file.findVariable(DATA_VARIABLE);
        Variable sliced1 = var.slice(0, 3);
        Variable sliced2 = sliced1.slice(0, 3);
        int[] shape = sliced2.getShape();
        TestSlice.assertEquals((int)2, (int)shape.length);
        TestSlice.assertEquals((int)123, (int)shape[0]);
        TestSlice.assertEquals((int)234, (int)shape[1]);
        TestSlice.assertEquals((String)"lat lon", (String)sliced2.getDimensionsString());
        Array org = var.read("3,3,:,:");
        Array data = sliced2.read();
        CompareNetcdf.compareData((Array)org, (Array)data);
    }
}

