/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.TestLocal;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.ncml.NcMLWriter;

public class TestSpecialChars
extends TestCase {
    private boolean show = false;
    String trouble = "here is a &, <, >, ', \", \n, \r, \t, to handle";

    public TestSpecialChars(String name) {
        super(name);
    }

    public void testWrite() throws IOException, InvalidRangeException {
        String filename = TestLocal.cdmTestDataDir + "testSpecialChars.nc";
        NetcdfFileWriteable ncfile = NetcdfFileWriteable.createNew((String)filename, (boolean)true);
        ncfile.addGlobalAttribute("omy", this.trouble);
        ncfile.addDimension("t", 1);
        ncfile.addStringVariable("t", new ArrayList(), this.trouble.length());
        ncfile.addVariableAttribute("t", "yow", this.trouble);
        ncfile.create();
        Array data = Array.factory((DataType)DataType.STRING, (int[])new int[0]);
        data.setObject(data.getIndex(), (Object)this.trouble);
        ncfile.writeStringData("t", data);
        ncfile.close();
    }

    public void testRead() throws IOException {
        String filename = TestLocal.cdmTestDataDir + "testSpecialChars.nc";
        NetcdfFile ncfile = NetcdfFile.open((String)filename, null);
        String val = ncfile.findAttValueIgnoreCase(null, "omy", null);
        assert (val != null);
        assert (val.equals(this.trouble));
        Variable v = ncfile.findVariable("t");
        v.setCachedData(v.read(), true);
        val = ncfile.findAttValueIgnoreCase(v, "yow", null);
        assert (val != null);
        assert (val.equals(this.trouble));
        ncfile.writeCDL((OutputStream)System.out, false);
        ncfile.writeNcML((OutputStream)System.out, null);
        NcMLWriter w = new NcMLWriter();
        w.writeXML(ncfile, (OutputStream)System.out, null);
        FileOutputStream out = new FileOutputStream(TestLocal.cdmTestDataDir + "testSpecialChars.ncml");
        w.writeXML(ncfile, (OutputStream)out, null);
        ((OutputStream)out).close();
        ncfile.close();
    }

    public void testReadNcML() throws IOException {
        String filename = TestLocal.cdmTestDataDir + "testSpecialChars.ncml";
        NetcdfFile ncfile = NetcdfDataset.openFile((String)filename, null);
        System.out.println("ncml= " + ncfile.getLocation());
        String val = ncfile.findAttValueIgnoreCase(null, "omy", null);
        assert (val != null);
        assert (val.equals(this.trouble));
        Variable v = ncfile.findVariable("t");
        v.setCachedData(v.read(), true);
        val = ncfile.findAttValueIgnoreCase(v, "yow", null);
        assert (val != null);
        assert (val.equals(this.trouble));
        NcMLWriter w = new NcMLWriter();
        w.writeXML(ncfile, (OutputStream)System.out, null);
        ncfile.close();
    }
}

