/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.grib.GribGridServiceProvider;
import ucar.nc2.util.CompareNetcdf;
import ucar.unidata.io.RandomAccessFile;

public class TestTextIndexes
extends TestCase {
    public TestTextIndexes(String name) {
        super(name);
    }

    public void testCompare(String[] newargs) throws IOException {
        File where = new File("C:/data/grib/idd");
        if (where.exists()) {
            String[] args = new String[]{"C:/data/grib/idd"};
            this.doAll(args);
        } else {
            this.doAll(newargs);
        }
    }

    void compareNC(String fileBinary, String fileText) throws IOException {
        long start = System.currentTimeMillis();
        Class<GribGridServiceProvider> c = GribGridServiceProvider.class;
        IOServiceProvider spiB = null;
        try {
            spiB = (IOServiceProvider)c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IOException("IOServiceProvider " + c.getName() + "must have no-arg constructor.");
        }
        catch (IllegalAccessException e) {
            throw new IOException("IOServiceProvider " + c.getName() + " IllegalAccessException: " + e.getMessage());
        }
        RandomAccessFile rafB = new RandomAccessFile(fileBinary, "r");
        rafB.order(0);
        NetcdfFile ncfileBinary = new NetcdfFile(spiB, rafB, fileBinary, null);
        System.out.println("Text3_17 Netcdf object created");
        start = System.currentTimeMillis();
        try {
            spiB = (IOServiceProvider)c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IOException("IOServiceProvider " + c.getName() + "must have no-arg constructor.");
        }
        catch (IllegalAccessException e) {
            throw new IOException("IOServiceProvider " + c.getName() + " IllegalAccessException: " + e.getMessage());
        }
        RandomAccessFile rafT = new RandomAccessFile(fileText, "r");
        rafT.order(0);
        NetcdfFile ncfileText = new NetcdfFile(spiB, rafT, fileText, null);
        System.out.println("Text Index Netcdf object created");
        CompareNetcdf.compareFiles((NetcdfFile)ncfileBinary, (NetcdfFile)ncfileText, (boolean)false, (boolean)true, (boolean)false);
        ncfileBinary.close();
        ncfileText.close();
    }

    void doAll(String[] args) throws IOException {
        String dirT;
        String dirB;
        if (args == null || args.length < 1) {
            dirB = TestAll.testdataDir + "test/motherlode/grid/grib/binary";
            dirT = TestAll.testdataDir + "test/motherlode/grid/grib/text";
        } else {
            dirB = args[0] + "/text3_17";
            dirT = args[0] + "/text";
        }
        File dir = new File(dirB);
        if (dir.isDirectory()) {
            String[] children;
            System.out.println("In directory " + dir.getParent() + "/" + dir.getName());
            for (String child : children = dir.list()) {
                File aChild = new File(dir, child);
                if (aChild.isDirectory() || child.contains("Ensemble") || child.contains("SREF") || child.contains("GFS_Spectral") || child.contains("SPECTRAL") || child.contains("OCEAN") || child.contains("ECMWF") || child.contains("SST") || child.contains("UKMET") || child.contains("GFS_Global_1p25deg") || child.endsWith("gbx") || child.endsWith("xml") || child.endsWith("tmp") || child.length() == 0) continue;
                System.out.println("\n\nComparing File " + child);
                this.compareNC(dirB + "/" + child, dirT + "/" + child);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        TestTextIndexes ti = new TestTextIndexes("");
        ti.testCompare(args);
    }
}

