/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.TestAll;
import ucar.nc2.TestLocal;
import ucar.nc2.Variable;

public class TestWriteRecord
extends TestCase {
    static String fileName = TestLocal.temporaryDataDir + "testWriteRecord.nc";
    static boolean dumpAfterCreate = false;

    public TestWriteRecord(String name) {
        super(name);
    }

    public void testNC3WriteWithRecordVariables() throws IOException, InvalidRangeException {
        block52: {
            Index ima;
            NetcdfFileWriteable ncfile;
            block51: {
                block50: {
                    block49: {
                        Dimension lonDim;
                        Dimension latDim;
                        block48: {
                            ncfile = new NetcdfFileWriteable(fileName, false);
                            latDim = ncfile.addDimension("lat", 3);
                            lonDim = ncfile.addDimension("lon", 4);
                            Dimension timeDim = ncfile.addDimension("time", 0, true, true, false);
                            Dimension[] dim3 = new Dimension[]{timeDim, latDim, lonDim};
                            ncfile.addVariable("rh", DataType.INT, dim3);
                            ncfile.addVariableAttribute("rh", "long_name", "relative humidity");
                            ncfile.addVariableAttribute("rh", "units", "percent");
                            ArrayInt.D1 valid_range = new ArrayInt.D1(2);
                            valid_range.set(0, 0);
                            valid_range.set(1, 100);
                            ncfile.addVariableAttribute("rh", "range", (Array)valid_range);
                            ncfile.addVariableAttribute("rh", "valid_range", Array.factory((Object)new double[]{0.0, 100.0}));
                            ncfile.addVariable("T", DataType.DOUBLE, dim3);
                            ncfile.addVariableAttribute("T", "long_name", "surface temperature");
                            ncfile.addVariableAttribute("T", "units", "degC");
                            ncfile.addVariable("lat", DataType.FLOAT, new Dimension[]{latDim});
                            ncfile.addVariableAttribute("lat", "units", "degrees_north");
                            ncfile.addVariable("lon", DataType.FLOAT, new Dimension[]{lonDim});
                            ncfile.addVariableAttribute("lon", "units", "degrees_east");
                            ncfile.addVariable("time", DataType.INT, new Dimension[]{timeDim});
                            ncfile.addVariableAttribute("time", "units", "hours");
                            ncfile.addVariable("recordvarTest", DataType.INT, new Dimension[]{timeDim});
                            ncfile.addGlobalAttribute("title", "Example Data");
                            try {
                                ncfile.create();
                            }
                            catch (IOException e) {
                                System.err.println("ERROR creating file");
                                if ($assertionsDisabled) break block48;
                                throw new AssertionError();
                            }
                        }
                        if (dumpAfterCreate) {
                            System.out.println("ncfile = " + ncfile);
                        }
                        Variable v = ncfile.findTopVariable("rh");
                        assert (v != null);
                        assert (v.isUnlimited());
                        int[][][] rhData = new int[][][]{new int[][]{{1, 2, 3, 4}, {5, 6, 7, 8}, {9, 10, 11, 12}}, new int[][]{{21, 22, 23, 24}, {25, 26, 27, 28}, {29, 30, 31, 32}}};
                        ArrayInt.D3 rhA = new ArrayInt.D3(2, latDim.getLength(), lonDim.getLength());
                        ima = rhA.getIndex();
                        for (int i = 0; i < 2; ++i) {
                            for (int j = 0; j < latDim.getLength(); ++j) {
                                for (int k = 0; k < lonDim.getLength(); ++k) {
                                    rhA.setInt(ima.set(i, j, k), rhData[i][j][k]);
                                }
                            }
                        }
                        try {
                            ncfile.write("rh", (Array)rhA);
                        }
                        catch (IOException e) {
                            System.err.println("ERROR writing file");
                            assert (false);
                        }
                        catch (InvalidRangeException e) {
                            e.printStackTrace();
                            if ($assertionsDisabled) break block49;
                            throw new AssertionError();
                        }
                    }
                    double[][][] tData = new double[][][]{new double[][]{{1.0, 2.0, 3.0, 4.0}, {2.0, 4.0, 6.0, 8.0}, {3.0, 6.0, 9.0, 12.0}}, new double[][]{{2.5, 5.0, 7.5, 10.0}, {5.0, 10.0, 15.0, 20.0}, {7.5, 15.0, 22.5, 30.0}}};
                    try {
                        ncfile.write("T", Array.factory((Object)tData));
                    }
                    catch (IOException e) {
                        System.err.println("ERROR writing file");
                        assert (false);
                    }
                    catch (InvalidRangeException e) {
                        e.printStackTrace();
                        if ($assertionsDisabled) break block50;
                        throw new AssertionError();
                    }
                }
                try {
                    ncfile.write("lat", Array.factory((Object)new float[]{41.0f, 40.0f, 39.0f}));
                    ncfile.write("lon", Array.factory((Object)new float[]{-109.0f, -107.0f, -105.0f, -103.0f}));
                    ncfile.write("time", Array.factory((Object)new int[]{6, 18}));
                }
                catch (IOException e) {
                    System.err.println("ERROR writing file");
                    assert (false);
                }
                catch (InvalidRangeException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block51;
                    throw new AssertionError();
                }
            }
            try {
                String title = ncfile.findAttValueIgnoreCase(null, "title", "N/A");
                Variable lat = ncfile.findVariable("lat");
                assert (lat.getRank() == 1);
                int nlats = lat.getShape()[0];
                double[] lats = new double[nlats];
                Array values = lat.read();
                ima = values.getIndex();
                for (int ilat = 0; ilat < nlats; ++ilat) {
                    lats[ilat] = values.getDouble(ima.set0(ilat));
                }
                String latUnits = ncfile.findAttValueIgnoreCase(lat, "units", "N/A");
                assert (latUnits.equals("degrees_north"));
                Variable lon = ncfile.findVariable("lon");
                values = lon.read();
                assert (values instanceof ArrayFloat.D1);
                ArrayFloat.D1 fa = (ArrayFloat.D1)values;
                assert (TestLocal.closeEnough(fa.get(0), -109.0f)) : fa.get(0);
                assert (TestLocal.closeEnough(fa.get(1), -107.0f)) : fa.get(1);
                assert (TestLocal.closeEnough(fa.get(2), -105.0f)) : fa.get(2);
                assert (TestLocal.closeEnough(fa.get(3), -103.0f)) : fa.get(3);
                Dimension td = ncfile.findDimension("time");
                assert (td.getLength() == 2);
                Variable time = ncfile.findVariable("time");
                Array timeValues = time.read();
                assert (timeValues instanceof ArrayInt.D1);
                ArrayInt.D1 ta = (ArrayInt.D1)timeValues;
                assert (ta.get(0) == 6) : ta.get(0);
                assert (ta.get(1) == 18) : ta.get(1);
                Variable rh = ncfile.findVariable("rh");
                Array rhValues = rh.read();
                assert (rhValues instanceof ArrayInt.D3);
                ArrayInt.D3 rha = (ArrayInt.D3)rhValues;
                int[] shape = rha.getShape();
                for (int i = 0; i < shape[0]; ++i) {
                    for (int j = 0; j < shape[1]; ++j) {
                        for (int k = 0; k < shape[2]; ++k) {
                            int want = 20 * i + 4 * j + k + 1;
                            int val = rha.get(i, j, k);
                            assert (want == val) : val;
                        }
                    }
                }
                Variable t = ncfile.findVariable("T");
                Array tValues = t.read();
                assert (tValues instanceof ArrayDouble.D3);
                ArrayDouble.D3 Ta = (ArrayDouble.D3)tValues;
                assert (TestLocal.closeEnough(Ta.get(0, 0, 0), 1.0)) : Ta.get(0, 0, 0);
                assert (TestLocal.closeEnough(Ta.get(1, 1, 1), 10.0)) : Ta.get(1, 1, 1);
                tValues = t.read(new int[3], new int[]{2, 2, 2});
                assert (tValues instanceof ArrayDouble.D3);
                Ta = (ArrayDouble.D3)tValues;
                assert (TestLocal.closeEnough(Ta.get(0, 0, 0), 1.0)) : Ta.get(0, 0, 0);
                assert (TestLocal.closeEnough(Ta.get(1, 1, 1), 10.0)) : Ta.get(1, 1, 1);
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                ncfile.flush();
                ncfile.close();
            }
            catch (IOException e) {
                System.err.println("ERROR writing file");
                if ($assertionsDisabled) break block52;
                throw new AssertionError();
            }
        }
        System.out.println("**** TestWriteRecord done");
    }

    public void testNC3WriteWithRecord() throws IOException {
        NetcdfFileWriteable ncfile = new NetcdfFileWriteable(TestAll.temporaryLocalDataDir + "writeRecordExample.nc", false);
        Dimension latDim = ncfile.addDimension("lat", 64);
        Dimension lonDim = ncfile.addDimension("lon", 128);
        Dimension timeDim = ncfile.addDimension("time", 0, true, true, false);
        Dimension[] dim3 = new Dimension[]{timeDim, latDim, lonDim};
        ncfile.addVariable("T", DataType.DOUBLE, dim3);
        ncfile.addVariableAttribute("T", "long_name", "surface temperature");
        ncfile.addVariableAttribute("T", "units", "degC");
        ncfile.addVariable("lat", DataType.FLOAT, new Dimension[]{latDim});
        ncfile.addVariableAttribute("lat", "units", "degrees_north");
        ncfile.addVariable("lon", DataType.FLOAT, new Dimension[]{lonDim});
        ncfile.addVariableAttribute("lon", "units", "degrees_east");
        ncfile.addVariable("time", DataType.INT, new Dimension[]{timeDim});
        ncfile.addVariableAttribute("time", "units", "hours");
        ncfile.addGlobalAttribute("title", "Example Data");
        try {
            ncfile.create();
        }
        catch (IOException e) {
            System.err.println("ERROR creating file");
            e.printStackTrace();
            return;
        }
        System.out.println("ncfile = " + ncfile);
        Variable v = ncfile.findTopVariable("T");
        ArrayDouble.D3 data = new ArrayDouble.D3(1, latDim.getLength(), lonDim.getLength());
        ArrayInt.D1 timeData = new ArrayInt.D1(1);
        int[] origin = new int[v.getRank()];
        int[] timeOrigin = new int[1];
        for (int time = 0; time < 100; ++time) {
            Index ima = data.getIndex();
            for (int j = 0; j < latDim.getLength(); ++j) {
                for (int k = 0; k < lonDim.getLength(); ++k) {
                    data.setDouble(ima.set(0, j, k), (double)time * (double)j * (double)k);
                }
            }
            timeData.setInt(timeData.getIndex(), time);
            origin[0] = time;
            timeOrigin[0] = time;
            try {
                ncfile.write("T", origin, (Array)data);
                ncfile.write("time", timeOrigin, (Array)timeData);
                continue;
            }
            catch (IOException e) {
                System.err.println("ERROR writing file");
                continue;
            }
            catch (InvalidRangeException e) {
                e.printStackTrace();
            }
        }
        try {
            ncfile.close();
        }
        catch (IOException e) {
            System.err.println("ERROR writing file");
        }
        System.out.println("**** TestWriteRecord done");
    }
}

