/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import ucar.ma2.DataType;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;

public class TestWriteString {
    String variableName = "dataVar";
    String units = "units";
    String latVar = "lat";
    String lonVar = "lon";
    String timeVar = "time";
    String unitsAttName = "units";
    String axisAttName = "axis";
    String standardNameAttName = "standard_name";
    String longNameAttName = "long_name";
    String missingValueAttName = "missing_value";
    String fillValueAttName = "_FillValue";

    private void defineHeader(NetcdfFileWriteable writeableFile, Dimension timeDim, Dimension latDim, Dimension lonDim, Dimension[] dim3) {
        Dimension[] spatialDim = new Dimension[]{latDim, lonDim};
        writeableFile.addVariable(this.latVar, DataType.FLOAT, new Dimension[]{latDim});
        writeableFile.addVariableAttribute(this.latVar, this.unitsAttName, "degrees_north");
        writeableFile.addVariableAttribute(this.latVar, this.axisAttName, "Y");
        writeableFile.addVariableAttribute(this.latVar, this.standardNameAttName, "latitude");
        writeableFile.addVariable(this.lonVar, DataType.FLOAT, new Dimension[]{lonDim});
        writeableFile.addVariableAttribute(this.lonVar, this.unitsAttName, "degrees_east");
        writeableFile.addVariableAttribute(this.lonVar, this.axisAttName, "X");
        writeableFile.addVariableAttribute(this.lonVar, this.standardNameAttName, "longitude");
        writeableFile.addVariable(this.variableName, DataType.FLOAT, dim3);
        writeableFile.addVariableAttribute(this.variableName, this.longNameAttName, this.variableName);
        writeableFile.addVariableAttribute(this.variableName, this.unitsAttName, this.units);
        writeableFile.addVariable("cellId", DataType.STRING, spatialDim);
        writeableFile.addVariableAttribute("cellId", this.longNameAttName, "Cell ID");
        writeableFile.addVariable(this.timeVar, DataType.INT, new Dimension[]{timeDim});
        writeableFile.addVariableAttribute(this.timeVar, this.axisAttName, "T");
        writeableFile.addVariableAttribute(this.timeVar, this.standardNameAttName, this.timeVar);
        writeableFile.addVariableAttribute(this.timeVar, this.longNameAttName, this.timeVar);
        writeableFile.setFill(true);
    }

    private NetcdfFileWriteable createTimeLatLonDataCube(String filename, double[] latitudes, double[] longitudes) throws IOException {
        NetcdfFileWriteable writeableFile = NetcdfFileWriteable.createNew((String)filename);
        Dimension latDim = writeableFile.addDimension(this.latVar, latitudes.length);
        Dimension lonDim = writeableFile.addDimension(this.lonVar, longitudes.length);
        Dimension timeDim = writeableFile.addUnlimitedDimension(this.timeVar);
        Dimension[] dim3 = new Dimension[]{timeDim, latDim, lonDim};
        this.defineHeader(writeableFile, timeDim, latDim, lonDim, dim3);
        writeableFile.create();
        writeableFile.close();
        return writeableFile;
    }

    public static void main(String[] args) throws IOException {
        TestWriteString test = new TestWriteString();
        test.createTimeLatLonDataCube("D:/work/csiro/testWrite.nc", new double[]{1.0, 2.0}, new double[]{10.0, 20.0, 30.0, 40.0});
    }
}

