/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.File;
import java.io.IOException;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.netcdf3.SPFactory;
import ucar.nc2.util.Stat;

public class TimeNIO {
    static void testSP(String spName, String fname, Stat stat) throws IOException {
        String name = spName;
        long size = 0L;
        long startTime = System.currentTimeMillis();
        try {
            SPFactory.setServiceProvider((String)spName);
            NetcdfFile ncFile = NetcdfFile.open((String)fname);
            for (Variable v : ncFile.getVariables()) {
                v.read();
                size += v.getSize();
            }
            ncFile.close();
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        long endTime = System.currentTimeMillis();
        long diff = endTime - startTime;
        if (stat != null) {
            stat.avg(name + fname, diff);
        }
        System.out.println("read " + size + " from " + fname + " took " + diff + " msecs");
    }

    public static void doit(Stat s) throws IOException {
        TimeNIO.testSP("ucar.nc2.SPVer1", "C:/data/conventions/mm5/n040.nc", s);
        TimeNIO.testSP("ucar.nc2.SPNioMMap", "C:/data/conventions/mm5/copy_n040.nc", s);
        TimeNIO.testSP("ucar.nc2.SPNio", "C:/data/conventions/mm5/copy_n040.nc", s);
        TimeNIO.testSP("ucar.nc2.SPVer1", "C:/data/conventions/cf/cf1.nc", s);
        TimeNIO.testSP("ucar.nc2.SPNio", "C:/data/conventions/cf/copy_cf1.nc", s);
        TimeNIO.testSP("ucar.nc2.SPNioMMap", "C:/data/conventions/cf/copy_cf1.nc", s);
    }

    public static void testSP(String filename, Stat s) throws IOException {
        TimeNIO.testSP("ucar.nc2.SPVer1", filename, s);
        TimeNIO.testSP("ucar.nc2.SPNioMMap", filename, s);
        TimeNIO.testSP("ucar.nc2.SPNio", filename, s);
    }

    public static void testReadAll(Stat s, int n) throws IOException {
        long totalRead = 0L;
        for (int i = 0; i < n; ++i) {
            try {
                File dir = new File("timing/data/");
                String[] flist = dir.list();
                for (int j = 0; j < flist.length; ++j) {
                    TimeNIO.testSP("ucar.nc2.SPNioCD", "timing/data/" + flist[j], s);
                }
            }
            catch (IOException ioe) {
                ioe.printStackTrace();
                System.out.println("CD total before error= " + totalRead);
                break;
            }
            if (s != null) {
                s.print();
            }
            System.out.println("CD total done = " + totalRead);
        }
    }

    static long readSpreadData(String fname, Stat stat, int n) throws IOException {
        String name = "readSpreadData";
        long nbytes = 0L;
        long startTime = System.currentTimeMillis();
        try {
            NetcdfFile ncFile = NetcdfFile.open((String)fname);
            Variable v = ncFile.findVariable("CH4");
            for (int i = 0; i < n; ++i) {
                v.read();
                nbytes += v.getSize() * (long)v.getDataType().getSize();
            }
            ncFile.close();
            long endTime = System.currentTimeMillis();
            long diff = endTime - startTime;
            if (stat != null) {
                stat.avg(name, diff);
            }
            System.out.println(" read " + nbytes + " bytes from " + fname + " took " + diff + " msecs");
            return nbytes;
        }
        catch (Exception ioe) {
            System.out.println(" read from " + fname + " failed ");
            ioe.printStackTrace();
            return 0L;
        }
    }

    static long readAllData(String fname, Stat stat) throws IOException {
        String name = "readAll";
        long nbytes = 0L;
        if (!fname.endsWith(".nc")) {
            return 0L;
        }
        long startTime = System.currentTimeMillis();
        try {
            NetcdfFile ncFile = NetcdfFile.open((String)fname);
            for (Variable v : ncFile.getVariables()) {
                v.read();
                nbytes += v.getSize() * (long)v.getDataType().getSize();
            }
            ncFile.close();
            long endTime = System.currentTimeMillis();
            long diff = endTime - startTime;
            if (stat != null) {
                stat.avg(name, diff);
            }
            System.out.println(" read " + nbytes + " bytes from " + fname + " took " + diff + " msecs");
            return nbytes;
        }
        catch (Exception ioe) {
            System.out.println(" read from " + fname + " failed ");
            ioe.printStackTrace();
            return 0L;
        }
    }

    static long readAllDataRecord(String fname, Stat stat) throws IOException {
        String name = "readAll";
        long nbytes = 0L;
        return 0L;
    }

    public static long doOneDirRecord(File dir, Stat s) throws IOException {
        long total = 0L;
        File[] flist = dir.listFiles();
        for (int j = 0; j < flist.length; ++j) {
            File file = flist[j];
            if (file.isDirectory()) {
                total += TimeNIO.doOneDir(file, s);
                continue;
            }
            total += TimeNIO.readAllDataRecord(file.getAbsolutePath(), s);
        }
        return total;
    }

    public static long doOneDir(File dir, Stat s) throws IOException {
        long total = 0L;
        File[] flist = dir.listFiles();
        for (int j = 0; j < flist.length; ++j) {
            File file = flist[j];
            if (file.isDirectory()) {
                total += TimeNIO.doOneDir(file, s);
                continue;
            }
            total += TimeNIO.readAllData(file.getAbsolutePath(), s);
        }
        return total;
    }

    public static void main(String[] args) {
        Stat v1 = new Stat();
        Stat raf = new Stat();
        File topDir = new File("C:/data/conventions/");
        try {
            int n = 10;
            SPFactory.setServiceProvider((String)"ucar.nc2.N3ver1");
            long total = TimeNIO.readSpreadData("C:/data/conventions/mm5/copy_n040.nc", v1, n);
            System.out.println("total bytes= " + total);
            SPFactory.setServiceProvider((String)"ucar.nc2.iosp.netcdf3.N3raf");
            total = TimeNIO.readSpreadData("C:/data/conventions/mm5/n040.nc", raf, n);
            System.out.println("total bytes= " + total);
            SPFactory.setServiceProvider((String)"ucar.nc2.N3ver1");
            total = TimeNIO.doOneDir(topDir, v1);
            System.out.println("total bytes= " + total);
            SPFactory.setServiceProvider((String)"ucar.nc2.iosp.netcdf3.N3raf");
            total = TimeNIO.doOneDir(topDir, raf);
            System.out.println("total bytes= " + total);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.print("Ver1=");
        v1.print();
        System.out.print("Raf=");
        raf.print();
    }
}

