/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class TimeRecords2 {
    static void doOne(String filename, String varName) throws IOException {
        System.out.println("\nTime " + filename);
        NetcdfFile ncfile = NetcdfFile.open((String)filename);
        TimeRecords2.readOneVariable(ncfile, varName);
        TimeRecords2.readColumns(ncfile);
        ncfile.close();
    }

    private static void readColumns(NetcdfFile ncfile) throws IOException {
        long start = System.currentTimeMillis();
        long total = 0L;
        for (Variable variable : ncfile.getVariables()) {
            Array data = variable.read();
            total += data.getSize();
        }
        double took = (double)(System.currentTimeMillis() - start) * 0.001;
        System.out.println("   nvars = " + ncfile.getVariables().size());
        System.out.println(" readCols took=" + took + " secs (" + total + ")");
    }

    private static void readOneVariable(NetcdfFile ncfile, String varName) throws IOException {
        long start = System.currentTimeMillis();
        long total = 0L;
        Variable variable = ncfile.findVariable(varName);
        Array data = variable.read();
        double took = (double)(System.currentTimeMillis() - start) * 0.001;
        System.out.println("   read var = " + varName + " from " + ncfile.getLocation());
        System.out.println(" readOneVariable took=" + took + " secs (" + (total += data.getSize()) + ")");
    }

    public static void main(String[] args) throws IOException {
        TimeRecords2.doOne("C:/data/metars/Surface_METAR_20070326_0000.col.nc", "parent_index");
        TimeRecords2.doOne("C:/data/metars/Surface_METAR_20070326_0000.nc", "parent_index");
    }
}

