/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.nc2.NCdumpW;
import ucar.nc2.TestAll;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;

public class TestCoordinates
extends TestCase {
    public TestCoordinates(String name) {
        super(name);
    }

    public void testAlias() throws IOException {
        String filename = TestAll.cdmUnitTestDir + "fmrc/ensemble/demeter/MM_cnrm_129_red.ncml";
        NetcdfDataset ncd = NetcdfDataset.openDataset((String)filename);
        CoordinateAxis v = ncd.findCoordinateAxis("number");
        assert (v != null);
        assert (v instanceof CoordinateAxis1D);
        assert (null != ncd.findDimension("ensemble"));
        assert (v.getDimension(0) == ncd.findDimension("ensemble"));
    }

    public void testWrapOnce() throws IOException {
        String filename = TestAll.cdmUnitTestDir + "ncml/coords/testCoordScaling.ncml";
        System.out.printf("%s%n", filename);
        NetcdfDataset ncd = NetcdfDataset.openDataset((String)filename);
        CoordinateAxis v = ncd.findCoordinateAxis("Longitude");
        assert (v != null);
        assert (v instanceof CoordinateAxis1D);
        Array data = v.read();
        NCdumpW.printArray((Array)data);
        IndexIterator ii = data.getIndexIterator();
        while (ii.hasNext()) {
            assert (Math.abs(ii.getDoubleNext()) < 180.0) : ii.getDoubleCurrent();
        }
    }
}

