/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.ArrayStructure;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.TestAll;
import ucar.nc2.dataset.NetcdfDataset;

public class TestNestedConvert
extends TestCase {
    public TestNestedConvert(String name) {
        super(name);
    }

    public void utestNestedTable() throws IOException, InvalidRangeException {
        String filename = TestAll.cdmLocalTestDataDir + "dataset/nestedTable.bufr";
        NetcdfFile ncfile = NetcdfDataset.openFile((String)filename, null);
        Structure outer = (Structure)ncfile.findVariable("obs");
        StructureData data = outer.readStructure(0);
        assert (data.getScalarShort("Latitude") == Short.MAX_VALUE);
        ArrayStructure as = data.getArrayStructure("struct1");
        assert (as != null);
        assert (as.getScalarShort(0, as.findMember("Wind_speed")) == 61);
        ncfile.close();
    }

    public void utestNestedTableEnhanced() throws IOException, InvalidRangeException {
        String filename = TestAll.cdmLocalTestDataDir + "dataset/nestedTable.bufr";
        NetcdfDataset ncd = NetcdfDataset.openDataset((String)filename);
        Structure outer = (Structure)ncd.findVariable("obs");
        StructureData data = outer.readStructure(0);
        assert (Double.isNaN(data.getScalarFloat("Latitude")));
        ArrayStructure as = data.getArrayStructure("struct1");
        assert (as != null);
        assert (TestAll.closeEnough((double)as.getScalarFloat(0, as.findMember("Wind_speed")), 6.1));
        ncd.close();
    }
}

