/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Section;
import ucar.nc2.Dimension;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.util.CompareNetcdf;

public class TestScaleOffset
extends TestCase {
    private String filename = TestAll.cdmLocalTestDataDir + "scaleOffset.nc";

    public TestScaleOffset(String name) {
        super(name);
    }

    public void testWrite() throws Exception {
        System.out.printf("Open %s%n", this.filename);
        NetcdfFileWriteable ncfile = NetcdfFileWriteable.createNew((String)this.filename);
        Dimension latDim = ncfile.addDimension("lat", 200);
        Dimension lonDim = ncfile.addDimension("lon", 300);
        int n = lonDim.getLength();
        ArrayDouble.D2 unpacked = new ArrayDouble.D2(latDim.getLength(), lonDim.getLength());
        Index ima = unpacked.getIndex();
        for (int i = 0; i < latDim.getLength(); ++i) {
            for (int j = 0; j < lonDim.getLength(); ++j) {
                unpacked.setDouble(ima.set(i, j), (double)(i * n + j) + 30.0);
            }
        }
        boolean isUnsigned = true;
        double missingValue = -9999.0;
        int nbits = 16;
        MAMath.ScaleOffset so = MAMath.calcScaleOffsetSkipMissingData((Array)unpacked, (double)missingValue, (int)nbits, (boolean)isUnsigned);
        System.out.println("scale/offset = " + so.scale + " " + so.offset + " isUnsigned=" + isUnsigned);
        ncfile.addVariable("unpacked", DataType.DOUBLE, "lat lon");
        ncfile.addVariable("packed", DataType.SHORT, "lat lon");
        if (isUnsigned) {
            ncfile.addVariableAttribute("packed", "_Unsigned", "true");
        }
        ncfile.addVariableAttribute("packed", "scale_factor", (Number)so.scale);
        ncfile.addVariableAttribute("packed", "add_offset", (Number)so.offset);
        ncfile.create();
        ncfile.write("unpacked", (Array)unpacked);
        Array packed = MAMath.convert2packed((Array)unpacked, (double)missingValue, (int)nbits, (boolean)isUnsigned, (DataType)DataType.SHORT);
        ncfile.write("packed", packed);
        ncfile.close();
        NetcdfFile ncfileRead = NetcdfFile.open((String)this.filename);
        Variable v = ncfileRead.findVariable("packed");
        assert (v != null);
        Array readPacked = v.read();
        CompareNetcdf.compareData((Array)readPacked, (Array)packed);
        ncfileRead.close();
        NetcdfDataset ncd = NetcdfDataset.openDataset((String)this.filename);
        Variable vs = ncd.findVariable("packed");
        assert (vs != null);
        Array readEnhanced = vs.read();
        this.testClose(packed, (Array)unpacked, readEnhanced, 1.0 / so.scale);
        ncd.close();
        Array cnvertPacked = MAMath.convert2Unpacked((Array)readPacked, (MAMath.ScaleOffset)so);
        this.testClose(packed, cnvertPacked, readEnhanced, 1.0 / so.scale);
    }

    void testClose(Array packed, Array data1, Array data2, double close) {
        IndexIterator iterp = packed.getIndexIterator();
        IndexIterator iter1 = data1.getIndexIterator();
        IndexIterator iter2 = data2.getIndexIterator();
        while (iter1.hasNext()) {
            double v1 = iter1.getDoubleNext();
            double v2 = iter2.getDoubleNext();
            double p = iterp.getDoubleNext();
            double diff = Math.abs(v1 - v2);
            assert (diff < close) : v1 + " != " + v2 + " index=" + iter1 + " packed=" + p;
        }
    }

    public void testSubset() throws IOException, InvalidRangeException {
        NetcdfDataset ncd = NetcdfDataset.openDataset((String)this.filename);
        Variable vs = ncd.findVariable("packed");
        assert (vs != null);
        Section s = new Section().appendRange(1, 1).appendRange(1, 1);
        Array readEnhanced = vs.read(s);
        NCdumpW.printArray((Array)readEnhanced);
        Variable sec = vs.section(s);
        Array readSection = sec.read();
        NCdumpW.printArray((Array)readSection);
        CompareNetcdf.compareData((Array)readEnhanced, (Array)readSection);
        ncd.close();
    }
}

