/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.util.ArrayList;
import junit.framework.TestCase;
import ucar.ma2.Range;
import ucar.nc2.TestAll;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;

public class TestSectionFillValue
extends TestCase {
    private String filename = TestAll.cdmLocalTestDataDir + "standardVar.nc";

    public TestSectionFillValue(String name) {
        super(name);
    }

    public void testNetcdfFile() throws Exception {
        NetcdfDataset ncfile = NetcdfDataset.openDataset((String)this.filename);
        VariableDS v = (VariableDS)ncfile.findVariable("t3");
        assert (v != null);
        assert (v.hasFillValue());
        assert (v.findAttribute("_FillValue") != null);
        int rank = v.getRank();
        ArrayList<Range> ranges = new ArrayList<Range>();
        ranges.add(null);
        for (int i = 1; i < rank; ++i) {
            ranges.add(new Range(0, 1));
        }
        VariableDS v_section = (VariableDS)v.section(ranges);
        assert (v_section.findAttribute("_FillValue") != null);
        System.out.println(v_section.findAttribute("_FillValue"));
        assert (v_section.hasFillValue());
        ncfile.close();
    }
}

