/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dataset;

import java.io.IOException;
import java.net.MalformedURLException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestUtils;
import ucar.nc2.Variable;
import ucar.nc2.ncml.NcMLReader;
import ucar.nc2.ncml.TestNcML;

public class TestSubset
extends TestCase {
    static NetcdfFile ncfile = null;
    String filename = "file:./" + TestNcML.topDir + "subsetAwips.xml";

    public TestSubset(String name) {
        super(name);
    }

    public void setUp() {
        if (ncfile != null) {
            return;
        }
        try {
            new NcMLReader();
            ncfile = NcMLReader.readNcML((String)this.filename, null);
        }
        catch (MalformedURLException e) {
            System.out.println("bad URL error = " + e);
        }
        catch (IOException e) {
            System.out.println("IO error = " + e);
            e.printStackTrace();
        }
    }

    public void testSubsetData() {
        block4: {
            Variable v = ncfile.findVariable("t");
            Variable vsub = ncfile.findVariable("T-MandatoryLevels");
            assert (v != null);
            assert (vsub != null);
            try {
                Array dataSub = vsub.read();
                int[] origin = new int[v.getRank()];
                int[] shape = v.getShape();
                origin[1] = 1;
                shape[1] = 19;
                Array data = v.read(origin, shape);
                this.compare(data, dataSub);
                Array data2 = v.read("*,1:19,*,*");
                this.compare(data2, dataSub);
            }
            catch (Exception e) {
                e.printStackTrace();
                if ($assertionsDisabled) break block4;
                throw new AssertionError();
            }
        }
    }

    void compare(Array data1, Array data2) {
        assert (data1.getSize() == data2.getSize());
        IndexIterator iter1 = data1.getIndexIterator();
        IndexIterator iter2 = data2.getIndexIterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            double d1 = iter1.getDoubleNext();
            double d2 = iter2.getDoubleNext();
            assert (TestUtils.close(d1, d2)) : d1 + " != " + d2;
        }
    }
}

