/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import opendap.dap.BaseType;
import opendap.dap.BaseTypePrimitiveVector;
import opendap.dap.DAP2Exception;
import opendap.dap.DAS;
import opendap.dap.DArray;
import opendap.dap.DArrayDimension;
import opendap.dap.DConnect;
import opendap.dap.DConstructor;
import opendap.dap.DDS;
import opendap.dap.DSequence;
import opendap.dap.DString;
import opendap.dap.DataDDS;
import opendap.dap.PrimitiveVector;
import opendap.dap.parser.ParseException;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureMembers;
import ucar.ma2.TestMA2;
import ucar.nc2.NCdump;
import ucar.nc2.Variable;
import ucar.nc2.dods.ConvertD2N;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dods.DodsV;
import ucar.nc2.dods.TestDODS;
import ucar.nc2.util.IO;

public class TestConvertD2N {
    static boolean showData = false;
    static boolean useNC = false;

    static DataDDS testDataDDSfromServer(String urlName, String CE) throws IOException, ParseException, DAP2Exception, InvalidRangeException {
        System.out.println("--DConnect =" + urlName);
        DConnect dodsConnection = new DConnect(urlName, true);
        DDS dds = dodsConnection.getDDS();
        dds.print((OutputStream)System.out);
        DAS das = dodsConnection.getDAS();
        das.print((OutputStream)System.out);
        System.out.println();
        System.out.println("--DConnect.getData CE= " + CE);
        DataDDS dataDDS = dodsConnection.getData("?" + CE, null);
        dataDDS.print((OutputStream)System.out);
        System.out.println();
        System.out.println("--show DataDDS");
        PrintWriter pw = new PrintWriter(System.out);
        TestConvertD2N.showDDS(dataDDS, pw);
        pw.flush();
        System.out.println();
        System.out.println("--parseDataDDS DodsV.show");
        DodsV dataRoot = DodsV.parseDataDDS((DataDDS)dataDDS);
        dataRoot.show(System.out, "");
        System.out.println();
        System.out.println("--testConvertDDS");
        TestConvertD2N.testConvertDDS(urlName, dataDDS, System.out);
        System.out.println();
        System.out.println("--" + urlName + ".asc?" + CE);
        System.out.println(IO.readURLcontents((String)(urlName + ".asc?" + CE)));
        System.out.println("============");
        return dataDDS;
    }

    static void testArray(String urlName) throws IOException, ParseException, DAP2Exception {
        System.out.println("checkArray =" + urlName);
        DConnect dodsConnection = new DConnect(urlName, true);
        DataDDS dataDDS = dodsConnection.getData("?", null);
        dataDDS.print((OutputStream)System.out);
        System.out.println();
        DodsV root = DodsV.parseDataDDS((DataDDS)dataDDS);
        ConvertD2N converter = new ConvertD2N();
        DODSNetcdfFile dodsfile = new DODSNetcdfFile(urlName);
        List vars = dodsfile.getVariables();
        for (int i = 0; i < vars.size(); ++i) {
            Variable v = (Variable)vars.get(i);
            String name = DODSNetcdfFile.getDODSshortName((Variable)v);
            DodsV dodsV = root.findByDodsShortName(name);
            if (dodsV == null) {
                System.out.println("Cant find " + name);
                continue;
            }
            Array data = converter.convertTopVariable(v, null, dodsV);
            TestConvertD2N.showArray(v.getName(), data, System.out, "");
        }
        System.out.println("============");
    }

    static void showDDS(DataDDS dds, PrintWriter out) {
        out.println("DDS=" + dds.getName());
        Enumeration e = dds.getVariables();
        while (e.hasMoreElements()) {
            BaseType bt = (BaseType)e.nextElement();
            TestConvertD2N.showBT(bt, out, " ");
        }
    }

    static void testConvertDDS(String urlName, DataDDS dataDDS, PrintStream out) throws IOException, DAP2Exception {
        DODSNetcdfFile dodsfile = new DODSNetcdfFile(urlName);
        System.out.println(dodsfile.toString());
        if (useNC) {
            List vars = dodsfile.getVariables();
            for (int i = 0; i < vars.size(); ++i) {
                Variable v = (Variable)vars.get(i);
                Array data = v.read();
                if (!showData) continue;
                NCdump.printArray((Array)data, (String)(v.getName() + data.shapeToString()), (PrintStream)System.out, null);
            }
        }
        ConvertD2N converter = new ConvertD2N();
        DodsV root = DodsV.parseDataDDS((DataDDS)dataDDS);
        for (int i = 0; i < root.children.size(); ++i) {
            DodsV dodsV = (DodsV)root.children.get(i);
            Variable v = dodsfile.findVariable(dodsV.getNetcdfShortName());
            Array data = converter.convertTopVariable(v, null, dodsV);
            TestConvertD2N.showArray(v.getName(), data, out, "");
            if (useNC) {
                Array data2 = v.read();
                TestMA2.testEquals(data, data2);
            }
            if (!showData) continue;
            NCdump.printArray((Array)data, (String)(v.getName() + data.shapeToString()), (PrintStream)System.out, null);
        }
    }

    static void showBT(BaseType bt, PrintWriter out, String space) {
        if (bt instanceof DSequence) {
            TestConvertD2N.showSequence((DSequence)bt, out, space);
            return;
        }
        if (bt instanceof DArray) {
            TestConvertD2N.showArray((DArray)bt, out, space);
            return;
        }
        out.println(space + bt.getName() + " (" + bt.getClass().getName() + ")");
        if (bt instanceof DConstructor) {
            Enumeration e = ((DConstructor)bt).getVariables();
            String nspace = space + " ";
            while (e.hasMoreElements()) {
                BaseType nbt = (BaseType)e.nextElement();
                TestConvertD2N.showBT(nbt, out, nspace);
            }
            out.println(space + "-----" + bt.getName());
        }
    }

    static void showSequence(DSequence seq, PrintWriter out, String space) {
        int nrows = seq.getRowCount();
        out.println(space + seq.getName() + " (" + seq.getClass().getName() + ")");
        String nspace = space + " ";
        if (nrows > 0) {
            out.println(nspace + "Vector[" + nrows + "] allvalues; show first:");
            Vector v = seq.getRow(0);
            for (int i = 0; i < v.size(); ++i) {
                BaseType bt = (BaseType)v.elementAt(i);
                TestConvertD2N.showBT(bt, out, nspace + " ");
            }
        }
    }

    static void showArray(DArray a, PrintWriter out, String space) {
        int nrows = a.getLength();
        out.print(space + a.getName() + " (" + a.getClass().getName() + ") ");
        out.print(" (");
        int count = 0;
        Enumeration dims = a.getDimensions();
        while (dims.hasMoreElements()) {
            String name;
            DArrayDimension dim = (DArrayDimension)dims.nextElement();
            String string = name = dim.getName() == null ? "" : dim.getName() + "=";
            if (count > 0) {
                out.print(",");
            }
            out.print(name + dim.getSize());
            ++count;
        }
        out.println(")");
        String nspace = space + " ";
        PrimitiveVector pv = a.getPrimitiveVector();
        BaseType template = pv.getTemplate();
        out.println(nspace + pv.getClass().getName() + "[" + nrows + "] template=" + template.getClass().getName());
        if (pv instanceof BaseTypePrimitiveVector && !(template instanceof DString) && nrows > 0) {
            BaseType vbt = ((BaseTypePrimitiveVector)pv).getValue(0);
            TestConvertD2N.showBT(vbt, out, nspace + " ");
        }
    }

    static void showArray(String name, Array a, PrintStream out, String space) {
        out.print(space + "Array " + name + " (" + a.getClass().getName() + ") ");
        TestConvertD2N.showShape(a.getShape(), out);
        out.println();
        if (a instanceof ArrayStructure) {
            ArrayStructure sa = (ArrayStructure)a;
            StructureMembers sm = sa.getStructureMembers();
            List memlist = sm.getMembers();
            for (int i = 0; i < memlist.size(); ++i) {
                StructureMembers.Member member = (StructureMembers.Member)memlist.get(i);
                out.print(space + " " + member.getDataType() + " " + member.getName());
                TestConvertD2N.showShape(member.getShape(), out);
                out.println();
                Array data = member.getDataArray();
                if (data == null || !(data instanceof Array)) continue;
                Array array = data;
                TestConvertD2N.showArray(member.getName(), array, out, space + "  ");
            }
            out.println();
        }
    }

    static void showShape(int[] shape, PrintStream out) {
        out.print(" (");
        for (int i = 0; i < shape.length; ++i) {
            if (i > 0) {
                out.print(",");
            }
            out.print(shape[i]);
        }
        out.print(")");
    }

    private static void test(String url) throws IOException, ParseException, DAP2Exception, InvalidRangeException {
        TestConvertD2N.testDataDDSfromServer(url, "");
        TestConvertD2N.testArray(url);
    }

    public static void main(String[] args) throws IOException, ParseException, DAP2Exception, InvalidRangeException {
        TestConvertD2N.testDataDDSfromServer(TestDODS.server + "NestedSeq2", "person1.age,person1.stuff&person1.age=3");
    }
}

