/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayShort;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Variable;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dods.DODSVariable;
import ucar.nc2.dods.TestDODSRead;

public class TestDODSArrayPrimitiveTypes
extends TestCase {
    public TestDODSArrayPrimitiveTypes(String name) {
        super(name);
    }

    public void testArrays() throws IOException {
        int val;
        int i;
        DODSNetcdfFile dodsfile = TestDODSRead.open("test.02");
        Variable v = null;
        Array a = null;
        assert (null != (v = dodsfile.findVariable("b")));
        assert (v.getName().equals("b"));
        assert (v.getRank() == 1);
        assert (v.getSize() == 25L);
        assert (v.getDataType() == DataType.BYTE);
        a = v.read();
        assert (a.getRank() == 1);
        assert (a.getSize() == 25L);
        assert (a.getElementType() == Byte.TYPE);
        assert (a instanceof ArrayByte.D1);
        ArrayByte.D1 ab = (ArrayByte.D1)a;
        for (byte i2 = 0; i2 < 25; ++i2) {
            byte valb = ab.get((int)i2);
            assert (valb == i2);
        }
        assert (null != (v = dodsfile.findVariable("i16")));
        assert (v.getName().equals("i16"));
        assert (v.getRank() == 1);
        assert (v.getSize() == 25L);
        assert (v.getDataType() == DataType.SHORT);
        a = v.read();
        assert (a.getRank() == 1);
        assert (a.getSize() == 25L);
        assert (a.getElementType() == Short.TYPE);
        assert (a instanceof ArrayShort.D1);
        ArrayShort.D1 as = (ArrayShort.D1)a;
        for (int i3 = 0; i3 < 25; ++i3) {
            short vals = as.get(i3);
            assert (vals == i3 * 256);
        }
        assert (null != (v = dodsfile.findVariable("i32")));
        assert (v.getName().equals("i32"));
        assert (v.getRank() == 1);
        assert (v.getSize() == 25L);
        assert (v.getDataType() == DataType.INT);
        a = v.read();
        assert (a.getRank() == 1);
        assert (a.getSize() == 25L);
        assert (a.getElementType() == Integer.TYPE);
        assert (a instanceof ArrayInt.D1);
        ArrayInt.D1 ai = (ArrayInt.D1)a;
        for (i = 0; i < 25; ++i) {
            val = ai.get(i);
            assert (val == i * 2048);
        }
        assert (null != (v = dodsfile.findVariable("ui16")));
        assert (v.getName().equals("ui16"));
        assert (v.getRank() == 1);
        assert (v.getSize() == 25L);
        assert (v.getDataType() == DataType.SHORT);
        assert (v.isUnsigned());
        a = v.read();
        assert (a.getRank() == 1);
        assert (a.getSize() == 25L);
        assert (a.getElementType() == Short.TYPE);
        assert (a instanceof ArrayShort.D1);
        as = (ArrayShort.D1)a;
        for (i = 0; i < 25; ++i) {
            val = as.get(i);
            assert (val == i * 1024) : val;
        }
        assert (null != (v = dodsfile.findVariable("ui32")));
        assert (v.getName().equals("ui32"));
        assert (v.getRank() == 1);
        assert (v.getSize() == 25L);
        assert (v.getDataType() == DataType.INT) : v.getDataType();
        assert (v.isUnsigned());
        a = v.read();
        assert (a.getRank() == 1);
        assert (a.getSize() == 25L);
        assert (a.getElementType() == Integer.TYPE);
        assert (a instanceof ArrayInt.D1);
        ai = (ArrayInt.D1)a;
        for (i = 0; i < 25; ++i) {
            val = ai.get(i);
            assert (val == i * 4096);
        }
        assert (null != (v = dodsfile.findVariable("f32")));
        assert (v.getName().equals("f32"));
        assert (v.getRank() == 1);
        assert (v.getSize() == 25L);
        assert (v.getDataType() == DataType.FLOAT) : v.getDataType();
        a = v.read();
        assert (a.getRank() == 1);
        assert (a.getSize() == 25L);
        assert (a.getElementType() == Float.TYPE);
        assert (a instanceof ArrayFloat.D1);
        ArrayFloat.D1 af = (ArrayFloat.D1)a;
        float[] tFloat32 = new float[]{0.0f, 0.009999833f, 0.019998666f, 0.029995501f, 0.039989334f, 0.04997917f, 0.059964005f, 0.06994285f, 0.0799147f, 0.08987855f, 0.099833414f, 0.1097783f, 0.119712204f, 0.12963414f, 0.13954312f, 0.14943813f, 0.15931821f, 0.16918235f, 0.17902957f, 0.1888589f, 0.19866933f, 0.2084599f, 0.21822962f, 0.22797753f, 0.23770262f};
        for (int i4 = 0; i4 < 25; ++i4) {
            float val2 = af.get(i4);
            TestDODSArrayPrimitiveTypes.assertEquals((double)val2, (double)tFloat32[i4], (double)1.0E-5);
        }
        assert (null != (v = dodsfile.findVariable("f64")));
        assert (v.getName().equals("f64"));
        assert (v.getRank() == 1);
        assert (v.getSize() == 25L);
        assert (v.getDataType() == DataType.DOUBLE) : v.getDataType();
        a = v.read();
        assert (a.getRank() == 1);
        assert (a.getSize() == 25L);
        assert (a.getElementType() == Double.TYPE);
        assert (a instanceof ArrayDouble.D1);
        ArrayDouble.D1 ad = (ArrayDouble.D1)a;
        double[] tFloat64 = new double[]{1.0, 0.9999500004166653, 0.9998000066665778, 0.9995500337489875, 0.9992001066609779, 0.9987502603949663, 0.9982005399352042, 0.9975510002532796, 0.9968017063026194, 0.9959527330119943, 0.9950041652780257, 0.9939560979566968, 0.9928086358538663, 0.9915618937147881, 0.9902159962126371, 0.9887710779360422, 0.9872272833756269, 0.9855847669095608, 0.9838436927881214, 0.9820042351172703, 0.9800665778412416, 0.9780309147241483, 0.9758974493306055, 0.9736663950053749, 0.9713379748520297};
        for (int i5 = 0; i5 < 25; ++i5) {
            double val3 = ad.get(i5);
            TestDODSArrayPrimitiveTypes.assertEquals((double)val3, (double)tFloat64[i5], (double)1.0E-9);
        }
        assert (null != (v = dodsfile.findVariable("s")));
        assert (v.getName().equals("s"));
        assert (v.getRank() == 1);
        assert (v.getDataType() == DataType.STRING) : v.getDataType();
        a = v.read();
        assert (a.getRank() == 1);
        assert (a.getSize() == 25L);
        assert (a.getShape()[0] == 25);
        assert (a.getElementType() == String.class);
        assert (a instanceof ArrayObject.D1);
        ArrayObject.D1 ao = (ArrayObject.D1)a;
        for (int i6 = 0; i6 < 25; ++i6) {
            String str = (String)ao.get(i6);
            assert (str.equals("This is a data test string (pass " + i6 + ").")) : str;
        }
        assert (null != (v = dodsfile.findVariable("u")));
        assert (v.getName().equals("u"));
        assert (v.getRank() == 1);
        assert (v.getDataType() == DataType.STRING) : v.getDataType();
        a = v.read();
        assert (a.getRank() == 1);
        assert (a.getElementType() == String.class);
        assert (a instanceof ArrayObject.D1);
        ArrayObject.D1 ao2 = (ArrayObject.D1)a;
        for (int i7 = 0; i7 < 25; ++i7) {
            String str = (String)ao2.get(i7);
            assert (str.equals("http://www.opendap.org") || str.equals("http://www.dods.org")) : str;
        }
    }

    public void testStrides() throws IOException {
        Array a;
        block13: {
            DODSNetcdfFile dodsfile = TestDODSRead.open("test.02");
            DODSVariable v = null;
            a = null;
            assert (null != (v = (DODSVariable)dodsfile.findVariable("b")));
            assert (v.getName().equals("b"));
            assert (v.getRank() == 1);
            assert (v.getSize() == 25L);
            assert (v.getDataType() == DataType.BYTE);
            try {
                a = v.read("0:24:3");
            }
            catch (InvalidRangeException e) {
                if ($assertionsDisabled) break block13;
                throw new AssertionError();
            }
        }
        assert (a.getRank() == 1);
        assert (a.getSize() == 9L) : a.getSize();
        assert (a.getElementType() == Byte.TYPE);
        assert (a instanceof ArrayByte.D1);
        ArrayByte.D1 ab = (ArrayByte.D1)a;
        for (int i = 0; i < 8; ++i) {
            byte valb = ab.get(i);
            assert (valb == 3 * i);
        }
    }
}

