/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayShort;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.ma2.TestStructureArray;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dods.DODSStructure;
import ucar.nc2.dods.TestDODS;
import ucar.nc2.dods.TestDODSRead;

public class TestDODSStructureArray
extends TestCase {
    public TestDODSStructureArray(String name) {
        super(name);
    }

    public void testArrays() throws IOException {
        DODSNetcdfFile dodsfile = TestDODSRead.open("test.21");
        Variable v = null;
        Array a = null;
        assert (null != (v = dodsfile.findVariable("exp.j")));
        assert (v.getShortName().equals("j"));
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.INT);
        a = v.read();
        assert (a.getElementType() == Integer.TYPE);
        assert (a instanceof ArrayInt.D0);
        int vali = ((ArrayInt.D0)a).get();
        assert (vali == 1);
        assert (null != (v = dodsfile.findVariable("exp.i")));
        assert (v.getShortName().equals("i"));
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.INT);
        a = v.read();
        assert (a.getElementType() == Integer.TYPE);
        assert (a instanceof ArrayInt.D0);
        vali = ((ArrayInt.D0)a).get();
        assert (vali == 2) : vali;
        assert (null != (v = dodsfile.findVariable("exp.g")));
        assert (v.getShortName().equals("g"));
        assert (v.getRank() == 3);
        assert (v.getSize() == 27L);
        assert (v.getDataType() == DataType.SHORT);
        a = v.read();
        assert (a.getElementType() == Short.TYPE);
        assert (a instanceof ArrayShort.D3);
        IndexIterator iter = a.getIndexIterator();
        int count = 0;
        while (iter.hasNext()) {
            assert (iter.getShortNext() == 256 * count);
            ++count;
        }
        assert (null != (v = dodsfile.findVariable("exp.f")));
        assert (v.getShortName().equals("f"));
        assert (v.getRank() == 2);
        assert (v.getSize() == 4L);
        assert (v.getDataType() == DataType.SHORT);
        a = v.read();
        assert (a.getElementType() == Short.TYPE);
        assert (a instanceof ArrayShort.D2);
        iter = a.getIndexIterator();
        count = 0;
        while (iter.hasNext()) {
            assert (iter.getShortNext() == 256 * count);
            ++count;
        }
    }

    public void testArray2() throws IOException {
        DODSNetcdfFile dodsfile = TestDODSRead.open("test.21");
        DODSStructure exp = (DODSStructure)dodsfile.findVariable("exp");
        StructureData sd = exp.readStructure();
        StructureMembers.Member m = null;
        Object v = null;
        Array a = null;
        assert (null != (m = sd.findMember("j")));
        assert (m.getName().equals("j"));
        assert (m.getDataType() == DataType.INT);
        a = sd.getArray(m);
        assert (a.getElementType() == Integer.TYPE);
        assert (a instanceof ArrayInt.D0);
        int vali = ((ArrayInt.D0)a).get();
        assert (vali == 1);
        assert (null != (m = sd.findMember("i")));
        assert (m.getName().equals("i"));
        assert (m.getDataType() == DataType.INT);
        a = sd.getArray(m);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Integer.TYPE);
        assert (a instanceof ArrayInt.D0);
        vali = ((ArrayInt.D0)a).get();
        assert (vali == 2) : vali;
        assert (null != (m = sd.findMember("g")));
        assert (m.getName().equals("g"));
        assert (m.getDataType() == DataType.SHORT);
        a = sd.getArray(m);
        assert (a.getSize() == 27L);
        assert (a.getElementType() == Short.TYPE);
        assert (a instanceof ArrayShort.D3);
        IndexIterator iter = a.getIndexIterator();
        int count = 0;
        while (iter.hasNext()) {
            assert (iter.getShortNext() == 256 * count);
            ++count;
        }
        assert (null != (m = sd.findMember("f")));
        assert (m.getName().equals("f"));
        assert (m.getDataType() == DataType.SHORT);
        a = sd.getArray(m);
        assert (a.getSize() == 4L);
        assert (a.getElementType() == Short.TYPE);
        assert (a instanceof ArrayShort.D2);
        iter = a.getIndexIterator();
        count = 0;
        while (iter.hasNext()) {
            assert (iter.getShortNext() == 256 * count);
            ++count;
        }
    }

    public void testSARead() throws IOException {
        DODSNetcdfFile dodsfile = TestDODSRead.open("test.21");
        DODSStructure exp = (DODSStructure)dodsfile.findVariable("exp");
        StructureData data = exp.readStructure();
        StructureMembers.Member m = data.findMember("f");
        assert (m != null);
        Array a = data.getArray(m);
        Index ima = a.getIndex();
        assert (a.getShort(ima.set(1, 1)) == 768);
    }

    public void testDODS() throws IOException, InvalidRangeException {
        this.testW(TestDODS.server + "test.53", "types", false);
    }

    public void testW(String url, String sname, boolean isScalar) throws IOException, InvalidRangeException {
        NetcdfFile ncfile = NetcdfDataset.openFile((String)url, null);
        Structure v = (Structure)ncfile.findVariable(sname);
        assert (v != null);
        assert (v.getDataType() == DataType.STRUCTURE);
        Array data = v.read();
        assert (data instanceof ArrayStructure);
        assert (data.getElementType() == StructureData.class);
        new TestStructureArray().testArrayStructure((ArrayStructure)data);
        ncfile.close();
    }
}

