/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayObject;
import ucar.ma2.ArrayShort;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dods.TestDODSRead;

public class TestDODSStructureScalars
extends TestCase {
    public TestDODSStructureScalars(String name) {
        super(name);
    }

    public void testStructureRead() throws IOException {
        DODSNetcdfFile dodsfile = TestDODSRead.open("test.04");
        Variable v = null;
        Object a = null;
        assert (null != (v = dodsfile.findVariable("types")));
        assert (v instanceof Structure);
        Structure s = (Structure)v;
        StructureData sdata = s.readStructure();
        this.checkSD(sdata);
    }

    public void testRead() throws IOException {
        DODSNetcdfFile dodsfile = TestDODSRead.open("test.04");
        Variable v = null;
        Object a = null;
        assert (null != (v = dodsfile.findVariable("types")));
        assert (v instanceof Structure);
        Structure s = (Structure)v;
        Array sdata = s.read();
        this.checkSD((StructureData)sdata.getObject(sdata.getIndex()));
    }

    private void checkSD(StructureData s) {
        Object v = null;
        Array a = null;
        assert (null != (a = s.getArray("b")));
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Byte.TYPE);
        assert (a instanceof ArrayByte.D0);
        byte valb = ((ArrayByte.D0)a).get();
        assert (valb == 0);
        assert (null != (a = s.getArray("i16")));
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Short.TYPE);
        assert (a instanceof ArrayShort.D0);
        short vals = ((ArrayShort.D0)a).get();
        assert (vals == 0);
        assert (null != (a = s.getArray("i32")));
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Integer.TYPE);
        assert (a instanceof ArrayInt.D0);
        int vali = ((ArrayInt.D0)a).get();
        assert (vali == 1) : vali;
        assert (null != (a = s.getArray("ui32")));
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Integer.TYPE);
        assert (a instanceof ArrayInt.D0);
        long vall = ((ArrayInt.D0)a).get();
        assert (vall == 0L);
        assert (null != (a = s.getArray("ui16")));
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Short.TYPE);
        assert (a instanceof ArrayShort.D0);
        vali = ((ArrayShort.D0)a).get();
        assert (vali == 0);
        assert (null != (a = s.getArray("f32")));
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Float.TYPE);
        assert (a instanceof ArrayFloat.D0);
        float valf = ((ArrayFloat.D0)a).get();
        assert ((double)valf == 0.0);
        assert (null != (a = s.getArray("f64")));
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Double.TYPE);
        assert (a instanceof ArrayDouble.D0);
        double vald = ((ArrayDouble.D0)a).get();
        assert (vald == 1000.0);
        assert (null != (a = s.getArray("s")));
        assert (a.getRank() == 0);
        assert (a.getElementType() == String.class);
        assert (a instanceof ArrayObject.D0);
        String str = (String)a.getObject(a.getIndex());
        assert (str.equals("This is a data test string (pass 0)."));
        assert (null != (a = s.getArray("u")));
        assert (a.getRank() == 0);
        assert (a.getElementType() == String.class);
        assert (a instanceof ArrayObject.D0);
        str = (String)a.getObject(a.getIndex());
        assert (str.equals("http://www.opendap.org") || str.equals("http://www.dods.org")) : str;
    }

    public void testScalarRead() throws IOException {
        DODSNetcdfFile dodsfile = TestDODSRead.open("test.04");
        Variable v = null;
        assert (null != (v = dodsfile.findVariable("types")));
        assert (v instanceof Structure);
        this.scalarRead((Structure)v);
    }

    public void testScalarReadUncached() throws IOException {
        DODSNetcdfFile.setPreload((boolean)false);
        DODSNetcdfFile dodsfile = TestDODSRead.open("test.04");
        DODSNetcdfFile.setPreload((boolean)true);
        Variable v = null;
        assert (null != (v = dodsfile.findVariable("types")));
        assert (v instanceof Structure);
        v.setCaching(false);
        this.scalarRead((Structure)v);
    }

    private void scalarRead(Structure s) throws IOException {
        Variable v = null;
        Array a = null;
        assert (null != (v = s.findVariable("b")));
        assert (v.getShortName().equals("b"));
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.BYTE);
        a = v.read();
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Byte.TYPE);
        assert (a instanceof ArrayByte.D0);
        byte valb = ((ArrayByte.D0)a).get();
        assert (valb == 0);
        assert (null != (v = s.findVariable("i16")));
        assert (v.getShortName().equals("i16"));
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.SHORT);
        a = v.read();
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Short.TYPE);
        assert (a instanceof ArrayShort.D0);
        short vals = ((ArrayShort.D0)a).get();
        assert (vals == 0);
        assert (null != (v = s.findVariable("i32")));
        assert (v.getShortName().equals("i32"));
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.INT);
        a = v.read();
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Integer.TYPE);
        assert (a instanceof ArrayInt.D0);
        int vali = ((ArrayInt.D0)a).get();
        assert (vali == 1) : vali;
        assert (null != (v = s.findVariable("ui32")));
        assert (v.getShortName().equals("ui32"));
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.INT) : v.getDataType();
        assert (v.isUnsigned());
        a = v.read();
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Integer.TYPE);
        assert (a instanceof ArrayInt.D0);
        int vall = ((ArrayInt.D0)a).get();
        assert (vall == 0);
        assert (null != (v = s.findVariable("ui16")));
        assert (v.getShortName().equals("ui16"));
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.SHORT) : v.getDataType();
        a = v.read();
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Short.TYPE);
        assert (a instanceof ArrayShort.D0);
        vali = ((ArrayShort.D0)a).get();
        assert (vali == 0);
        assert (null != (v = s.findVariable("ui32")));
        assert (v.getShortName().equals("ui32"));
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.INT) : v.getDataType();
        a = v.read();
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Integer.TYPE);
        assert (a instanceof ArrayInt.D0);
        vall = ((ArrayInt.D0)a).get();
        assert (vall == 0);
        assert (null != (v = s.findVariable("f32")));
        assert (v.getShortName().equals("f32"));
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.FLOAT) : v.getDataType();
        a = v.read();
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Float.TYPE);
        assert (a instanceof ArrayFloat.D0);
        float valf = ((ArrayFloat.D0)a).get();
        assert ((double)valf == 0.0);
        assert (null != (v = s.findVariable("f64")));
        assert (v.getShortName().equals("f64"));
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.DOUBLE) : v.getDataType();
        a = v.read();
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Double.TYPE);
        assert (a instanceof ArrayDouble.D0);
        double vald = ((ArrayDouble.D0)a).get();
        assert (vald == 1000.0);
        assert (null != (v = s.findVariable("s")));
        assert (v.getShortName().equals("s"));
        assert (v.getRank() == 0);
        assert (v.getDataType() == DataType.STRING) : v.getDataType();
        a = v.read();
        assert (a.getRank() == 0);
        assert (a.getElementType() == String.class);
        assert (a instanceof ArrayObject.D0);
        String str = (String)a.getObject(a.getIndex());
        assert (str.equals("This is a data test string (pass 0)."));
        assert (null != (v = s.findVariable("u")));
        assert (v.getShortName().equals("u"));
        assert (v.getRank() == 0);
        assert (v.getDataType() == DataType.STRING) : v.getDataType();
        str = v.readScalarString();
        assert (str.equals("http://www.opendap.org") || str.equals("http://www.dods.org")) : str;
    }

    public void testDODSwithDataset() throws IOException {
        DODSNetcdfFile dodsfile = TestDODSRead.open("test.04");
        NetcdfDataset ds = new NetcdfDataset((NetcdfFile)dodsfile, false);
        Variable v = null;
        assert (null != (v = ds.findVariable("types.b")));
        v.invalidateCache();
        v.read();
    }
}

