/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayLong;
import ucar.ma2.ArrayShort;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dods.DODSStructure;
import ucar.nc2.dods.TestDODSRead;

public class TestDODSStructureScalarsNested
extends TestCase {
    private DODSNetcdfFile dodsfile;

    public TestDODSStructureScalarsNested(String name) {
        super(name);
    }

    public void testScalarRead() throws IOException {
        this.dodsfile = TestDODSRead.open("test.05");
        Variable v = null;
        Structure s = null;
        Object a = null;
        assert (null != (v = this.dodsfile.findVariable("types")));
        assert (v instanceof Structure);
        Structure types = (Structure)v;
        assert (null != (v = types.findVariable("integers")));
        assert (v instanceof Structure);
        s = (Structure)v;
        assert (null != (v = s.findVariable("b")));
        this.CheckByte(v);
        assert (null != (v = s.findVariable("i16")));
        this.CheckInt16(v);
        assert (null != (v = s.findVariable("i32")));
        this.CheckInt32(v);
        assert (null != (v = s.findVariable("ui32")));
        this.CheckUInt32(v);
        assert (null != (v = s.findVariable("ui16")));
        this.CheckUint16(v);
        assert (null != (v = types.findVariable("floats")));
        assert (v instanceof Structure);
        s = (Structure)v;
        assert (null != (v = s.findVariable("f32")));
        this.CheckF(v);
        assert (null != (v = s.findVariable("f64")));
        this.CheckD(v);
        assert (null != (v = types.findVariable("strings")));
        assert (v instanceof Structure);
        s = (Structure)v;
        assert (null != (v = s.findVariable("s")));
        this.CheckS(v);
        assert (null != (v = s.findVariable("u")));
        this.CheckUrl(v);
    }

    public void testStructureRead() throws IOException {
        this.dodsfile = TestDODSRead.open("test.05");
        Variable v = null;
        Object a = null;
        DODSStructure types = null;
        Object integers = null;
        Object floats = null;
        Object strings = null;
        assert (null != (v = this.dodsfile.findVariable("types")));
        System.out.println("types=" + v);
        assert (v instanceof DODSStructure);
        types = (DODSStructure)v;
        assert (null != (v = types.findVariable("integers")));
        assert (v instanceof Structure);
        Structure s = (Structure)v;
        StructureData sdata = s.readStructure();
        StructureMembers.Member m = sdata.findMember("b");
        assert (null != m);
        this.CheckByteValue(sdata.getArray(m));
        m = sdata.findMember("i16");
        assert (null != m);
        this.CheckInt16Value(sdata.getArray(m));
        m = sdata.findMember("i32");
        assert (null != m);
        this.CheckInt32Value(sdata.getArray(m));
        m = sdata.findMember("ui16");
        assert (null != m);
        this.CheckUInt16Value(sdata.getArray(m));
        m = sdata.findMember("ui32");
        assert (null != m);
        this.CheckUInt32Value(sdata.getArray(m));
        assert (null != (v = types.findVariable("floats")));
        assert (v instanceof Structure);
        s = (Structure)v;
        sdata = s.readStructure();
        m = sdata.findMember("f32");
        assert (null != m);
        this.CheckFValue(sdata.getArray(m));
        m = sdata.findMember("f64");
        assert (null != m);
        this.CheckDValue(sdata.getArray(m));
        assert (null != (v = types.findVariable("strings")));
        assert (v instanceof Structure);
        s = (Structure)v;
        sdata = s.readStructure();
        m = sdata.findMember("s");
        assert (null != m);
        this.CheckSValue(sdata.getArray(m));
    }

    public void testStructureRead2() throws IOException {
        this.dodsfile = TestDODSRead.open("test.05");
        Variable v = null;
        Object a = null;
        DODSStructure types = null;
        StructureMembers.Member m = null;
        StructureData integers = null;
        StructureData floats = null;
        StructureData strings = null;
        assert (null != (v = this.dodsfile.findVariable("types")));
        System.out.println("types=" + v);
        assert (v instanceof DODSStructure);
        types = (DODSStructure)v;
        StructureData sdata = types.readStructure();
        assert (null != (m = sdata.findMember("integers")));
        Array arr = sdata.getArray(m);
        integers = (StructureData)arr.getObject(arr.getIndex());
        m = integers.findMember("b");
        assert (null != m);
        this.CheckByteValue(integers.getArray(m));
        m = integers.findMember("i16");
        assert (null != m);
        this.CheckInt16Value(integers.getArray(m));
        m = integers.findMember("i32");
        assert (null != m);
        this.CheckInt32Value(integers.getArray(m));
        m = integers.findMember("ui16");
        assert (null != m);
        this.CheckUInt16Value(integers.getArray(m));
        m = integers.findMember("ui32");
        assert (null != m);
        this.CheckUInt32Value(integers.getArray(m));
        assert (null != (m = sdata.findMember("floats")));
        arr = sdata.getArray(m);
        floats = (StructureData)arr.getObject(arr.getIndex());
        m = floats.findMember("f32");
        assert (null != m);
        this.CheckFValue(floats.getArray(m));
        m = floats.findMember("f64");
        assert (null != m);
        this.CheckDValue(floats.getArray(m));
        assert (null != (m = sdata.findMember("strings")));
        arr = sdata.getArray(m);
        strings = (StructureData)arr.getObject(arr.getIndex());
        m = strings.findMember("s");
        assert (null != m);
        this.CheckSValue(strings.getArray(m));
    }

    void CheckByte(Variable v) throws IOException {
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.BYTE);
        this.CheckByteValue(v.read());
    }

    void CheckByteValue(Array a) {
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Byte.TYPE);
        assert (a instanceof ArrayByte.D0);
        byte valb = ((ArrayByte.D0)a).get();
        assert (valb == 0);
    }

    void CheckInt16(Variable v) throws IOException {
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.SHORT);
        this.CheckInt16Value(v.read());
    }

    void CheckInt16Value(Array a) {
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Short.TYPE);
        assert (a instanceof ArrayShort.D0);
        short vals = ((ArrayShort.D0)a).get();
        assert (vals == 0);
    }

    void CheckInt32(Variable v) throws IOException {
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.INT);
        this.CheckInt32Value(v.read());
    }

    void CheckInt32Value(Array a) {
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Integer.TYPE);
        assert (a instanceof ArrayInt.D0);
        int vali = ((ArrayInt.D0)a).get();
        assert (vali == 1) : vali;
    }

    void CheckUInt32(Variable v) throws IOException {
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.INT) : v.getDataType();
        this.CheckUInt32Value(v.read());
    }

    void CheckUInt32Value(Array a) {
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Integer.TYPE);
        assert (a instanceof ArrayInt.D0);
        int vall = ((ArrayInt.D0)a).get();
        assert (vall == 0);
    }

    void CheckUint16(Variable v) throws IOException {
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.SHORT) : v.getDataType();
        this.CheckUInt16Value(v.read());
    }

    void CheckUInt16Value(Array a) {
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Short.TYPE);
        assert (a instanceof ArrayShort.D0);
        short vali = ((ArrayShort.D0)a).get();
        assert (vali == 0);
    }

    void CheckLong32(Variable v) throws IOException {
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.LONG) : v.getDataType();
        this.CheckLongValue(v.read());
    }

    void CheckLongValue(Array a) {
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Long.TYPE);
        assert (a instanceof ArrayLong.D0);
        long vall = ((ArrayLong.D0)a).get();
        assert (vall == 0L);
    }

    void CheckF(Variable v) throws IOException {
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.FLOAT) : v.getDataType();
        this.CheckFValue(v.read());
    }

    void CheckFValue(Array a) {
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Float.TYPE);
        assert (a instanceof ArrayFloat.D0);
        float valf = ((ArrayFloat.D0)a).get();
        assert ((double)valf == 0.0);
    }

    void CheckD(Variable v) throws IOException {
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.DOUBLE) : v.getDataType();
        this.CheckDValue(v.read());
    }

    void CheckDValue(Array a) {
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Double.TYPE);
        assert (a instanceof ArrayDouble.D0);
        double vald = ((ArrayDouble.D0)a).get();
        assert (vald == 1000.0);
    }

    void CheckS(Variable v) throws IOException {
        assert (v.getRank() == 0);
        assert (v.getDataType() == DataType.STRING) : v.getDataType();
        this.CheckSValue(v.read());
    }

    void CheckSValue(Array a) {
        assert (a.getRank() == 0);
        assert (a.getElementType() == String.class);
        String str = (String)a.getObject(a.getIndex());
        assert (str.equals("This is a data test string (pass 0)."));
    }

    void CheckUrl(Variable v) throws IOException {
        assert (v.getRank() == 0);
        assert (v.getDataType() == DataType.STRING) : v.getDataType();
        String str = v.readScalarString();
        assert (str.equals("http://www.opendap.org") || str.equals("http://www.dods.org")) : str;
    }
}

