/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayByte;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayLong;
import ucar.ma2.ArrayShort;
import ucar.ma2.DataType;
import ucar.nc2.Variable;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dods.TestDODSRead;

public class TestDODSSubset
extends TestCase {
    private DODSNetcdfFile dodsfile;

    public TestDODSSubset(String name) {
        super(name);
    }

    public void testArraySubset() throws IOException {
        DODSNetcdfFile dodsfile = TestDODSRead.open("test.02?i32[1:10],f64[2:2:10]");
        Variable v = null;
        Array a = null;
        assert (null != (v = dodsfile.findVariable("i32")));
        assert (v.getName().equals("i32"));
        assert (v.getRank() == 1);
        assert (v.getSize() == 10L);
        assert (v.getDataType() == DataType.INT);
        a = v.read();
        assert (a.getRank() == 1);
        assert (a.getSize() == 10L);
        assert (a.getElementType() == Integer.TYPE);
        assert (a instanceof ArrayInt.D1);
        ArrayInt.D1 ai = (ArrayInt.D1)a;
        for (int i = 0; i < 10; ++i) {
            int val = ai.get(i);
            assert (val == (i + 1) * 2048) : val + " != " + (i + 1) * 2048;
        }
        assert (null == (v = dodsfile.findVariable("ui16")));
        assert (null == (v = dodsfile.findVariable("ui32")));
        assert (null != (v = dodsfile.findVariable("f64")));
        assert (v.getName().equals("f64"));
        assert (v.getRank() == 1);
        assert (v.getSize() == 5L);
        assert (v.getDataType() == DataType.DOUBLE) : v.getDataType();
        a = v.read();
        assert (a.getRank() == 1);
        assert (a.getSize() == 5L);
        assert (a.getElementType() == Double.TYPE);
        assert (a instanceof ArrayDouble.D1);
        ArrayDouble.D1 ad = (ArrayDouble.D1)a;
        double[] tFloat64 = new double[]{1.0, 0.9999500004166653, 0.9998000066665778, 0.9995500337489875, 0.9992001066609779, 0.9987502603949663, 0.9982005399352042, 0.9975510002532796, 0.9968017063026194, 0.9959527330119943, 0.9950041652780257, 0.9939560979566968, 0.9928086358538663, 0.9915618937147881, 0.9902159962126371, 0.9887710779360422, 0.9872272833756269, 0.9855847669095608, 0.9838436927881214, 0.9820042351172703, 0.9800665778412416, 0.9780309147241483, 0.9758974493306055, 0.9736663950053749, 0.9713379748520297};
        for (int i = 0; i < 5; ++i) {
            double val = ad.get(i);
            TestDODSSubset.assertEquals((double)val, (double)tFloat64[2 + 2 * i], (double)1.0E-9);
        }
    }

    public void testSubset() throws IOException {
        this.dodsfile = TestDODSRead.open("test.05?types.integers");
        Variable v = null;
        Object a = null;
        assert (null != (v = this.dodsfile.findVariable("types.integers.b")));
        this.CheckByte(v);
        assert (null != (v = this.dodsfile.findVariable("types.integers.i16")));
        this.CheckInt16(v);
        assert (null != (v = this.dodsfile.findVariable("types.integers.i32")));
        this.CheckInt32(v);
        assert (null != (v = this.dodsfile.findVariable("types.integers.ui32")));
        this.CheckUint32(v);
        assert (null != (v = this.dodsfile.findVariable("types.integers.ui16")));
        this.CheckUint16(v);
        assert (null != (v = this.dodsfile.findVariable("types.integers.ui32")));
        this.CheckUint32(v);
    }

    void CheckByte(Variable v) throws IOException {
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.BYTE);
        this.CheckByteValue(v.read());
    }

    void CheckByteValue(Array a) {
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Byte.TYPE);
        assert (a instanceof ArrayByte.D0);
        byte valb = ((ArrayByte.D0)a).get();
        assert (valb == 0);
    }

    void CheckInt16(Variable v) throws IOException {
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.SHORT);
        this.CheckInt16Value(v.read());
    }

    void CheckInt16Value(Array a) {
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Short.TYPE);
        assert (a instanceof ArrayShort.D0);
        short vals = ((ArrayShort.D0)a).get();
        assert (vals == 0);
    }

    void CheckInt32(Variable v) throws IOException {
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.INT);
        this.CheckInt32Value(v.read());
    }

    void CheckInt32Value(Array a) {
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Integer.TYPE);
        assert (a instanceof ArrayInt.D0);
        int vali = ((ArrayInt.D0)a).get();
        assert (vali == 1) : vali;
    }

    void CheckUint32(Variable v) throws IOException {
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.LONG) : v.getDataType();
        this.CheckUint32Value(v.read());
    }

    void CheckUint32Value(Array a) {
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Long.TYPE);
        assert (a instanceof ArrayLong.D0);
        long vall = ((ArrayLong.D0)a).get();
        assert (vall == 0L);
    }

    void CheckUint16(Variable v) throws IOException {
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.INT) : v.getDataType();
        this.CheckUInt16Value(v.read());
    }

    void CheckUInt16Value(Array a) {
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Integer.TYPE);
        assert (a instanceof ArrayInt.D0);
        int vali = ((ArrayInt.D0)a).get();
        assert (vali == 0);
    }

    void CheckLong32(Variable v) throws IOException {
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.LONG) : v.getDataType();
        this.CheckLongValue(v.read());
    }

    void CheckLongValue(Array a) {
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Long.TYPE);
        assert (a instanceof ArrayLong.D0);
        long vall = ((ArrayLong.D0)a).get();
        assert (vall == 0L);
    }

    void CheckF(Variable v) throws IOException {
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.FLOAT) : v.getDataType();
        this.CheckFValue(v.read());
    }

    void CheckFValue(Array a) {
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Float.TYPE);
        assert (a instanceof ArrayFloat.D0);
        float valf = ((ArrayFloat.D0)a).get();
        assert ((double)valf == 0.0);
    }

    void CheckD(Variable v) throws IOException {
        assert (v.getRank() == 0);
        assert (v.getSize() == 1L);
        assert (v.getDataType() == DataType.DOUBLE) : v.getDataType();
        this.CheckDValue(v.read());
    }

    void CheckDValue(Array a) {
        assert (a.getRank() == 0);
        assert (a.getSize() == 1L);
        assert (a.getElementType() == Double.TYPE);
        assert (a instanceof ArrayDouble.D0);
        double vald = ((ArrayDouble.D0)a).get();
        assert (vald == 1000.0);
    }

    void CheckS(Variable v) throws IOException {
        assert (v.getRank() == 0);
        assert (v.getDataType() == DataType.STRING) : v.getDataType();
        this.CheckSValue(v.read());
    }

    void CheckSValue(Array a) {
        assert (a.getRank() == 0);
        assert (a.getElementType() == String.class);
        String str = (String)a.getObject(a.getIndex());
        assert (str.equals("This is a data test string (pass 0)."));
    }

    void CheckUrl(Variable v) throws IOException {
        assert (v.getRank() == 0);
        assert (v.getDataType() == DataType.STRING) : v.getDataType();
        String str = v.readScalarString();
        assert (str.equals("http://www.opendap.org") || str.equals("http://www.dods.org")) : str;
    }
}

