/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dods;

import java.io.IOException;
import java.io.PrintStream;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.NCdump;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.dods.DODSNetcdfFile;
import ucar.nc2.dods.DODSStructure;
import ucar.nc2.dods.TestDODSRead;

public class TestDODSnestedSequence
extends TestCase {
    private boolean debug = false;

    public TestDODSnestedSequence(String name) {
        super(name);
    }

    public void testNestedSequenceParent() throws IOException {
        DODSNetcdfFile dodsfile = TestDODSRead.open("NestedSeq");
        Variable v = dodsfile.findVariable("person1");
        assert (null != v);
        assert (v instanceof Structure);
        assert (v instanceof DODSStructure);
        assert (v.getRank() == 1);
        assert (v.isVariableLength());
        Array a = v.read();
        assert (a.getRank() == 1);
        assert (a.getSize() == 5L) : a.getSize();
        int count = 0;
        int fib = 1;
        int prev = 1;
        IndexIterator iter = a.getIndexIterator();
        while (iter.hasNext()) {
            StructureData data = (StructureData)iter.next();
            StructureMembers.Member stuff = data.findMember("stuff");
            assert (stuff != null);
            assert (data.findMember("age") != null);
            int agev = data.getScalarInt("age");
            assert (agev == fib) : fib + "!=" + agev;
            ++count;
            int hold = fib;
            fib += prev;
            prev = hold;
        }
    }

    public void utestNestedSequence() throws IOException, InvalidRangeException {
        DODSNetcdfFile dodsfile = TestDODSRead.open("NestedSeq");
        Variable v = dodsfile.findVariable("person1");
        Structure s = (Structure)v;
        v = s.findVariable("stuff");
        assert (null != v);
        assert (v instanceof Structure);
        assert (v instanceof DODSStructure);
        assert (v.getRank() == 1);
        assert (v.isVariableLength());
        Array a = v.read();
        assert (a.getRank() == 1);
        assert (a.getSize() == 25L) : a.getSize();
        NCdump.printArray((Array)a, (String)"stuff", (PrintStream)System.out, null);
        int count = 0;
        IndexIterator iter = a.getIndexIterator();
        while (iter.hasNext()) {
            StructureData data = (StructureData)iter.next();
            assert (data.findMember("foo") != null);
            int foo = data.getScalarInt("foo");
            assert (foo == count * 16) : foo;
            ++count;
        }
    }

    public void utestCE() throws IOException, InvalidRangeException {
        DODSNetcdfFile dodsFile = TestDODSRead.open("NestedSeq2");
        Variable outerSequence = dodsFile.findVariable("person1");
        String CE = "person1.age,person1.stuff&person1.age=3";
        ArrayStructure as = (ArrayStructure)dodsFile.readWithCE(outerSequence, CE);
        assert (as.getSize() == 1L);
        StructureData outerStructure = as.getStructureData(0);
        StructureMembers outerMembers = outerStructure.getStructureMembers();
        assert (outerMembers.findMember("age") != null);
        assert (outerMembers.findMember("stuff") != null);
        ArrayStructure asInner = (ArrayStructure)outerStructure.getArray("stuff");
        StructureMembers innerMembers = asInner.getStructureMembers();
        assert (innerMembers.findMember("foo") != null);
        assert (innerMembers.findMember("bar") != null);
        assert (asInner.getSize() == 3L) : asInner.getSize();
        StructureData firstInner = asInner.getStructureData(0);
        StructureMembers firstMembers = firstInner.getStructureMembers();
        assert (firstMembers.findMember("foo") != null);
        assert (firstMembers.findMember("bar") != null);
    }
}

