/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt;

import java.io.IOException;
import ucar.ma2.Array;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridDataset;

public class TimeGrid {
    public static void main(String[] arg) throws IOException {
        String defaultFilename = "R:/testdata/grid/grib/grib2/test/NAM_CONUS_12km_20060305_1200.grib2";
        String filename = arg.length > 0 ? arg[0] : defaultFilename;
        try {
            long start = System.currentTimeMillis();
            GridDataset gridDs = GridDataset.open((String)filename);
            GeoGrid gg = gridDs.findGridByName("Temperature");
            long took = System.currentTimeMillis() - start;
            System.out.println("open took = " + took + " msecs");
            start = System.currentTimeMillis();
            Array data = gg.readVolumeData(0);
            took = System.currentTimeMillis() - start;
            float size = (float)data.getSize() * (float)gg.getDataType().getSize() / 1000000.0f;
            System.out.println(size + " Mbytes, took = " + took + " msecs");
        }
        catch (Exception ioe) {
            ioe.printStackTrace();
        }
        System.in.read();
    }
}

