/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt;

import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import ucar.ma2.Array;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.PointObsDataset;
import ucar.nc2.dt.PointObsDatatype;
import ucar.nc2.dt.StationObsDataset;
import ucar.nc2.dt.StationObsDatatype;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.unidata.geoloc.Station;

public class TimeStationObs {
    private static boolean debug = false;
    private static long timeToScan = 0L;
    private static DataOutputStream xout;
    private BufferedOutputStream fout;
    private static ArrayList fileList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scanStation(String url, String station, Predicate p, Action a, Limit limit) throws IOException {
        StationObsDataset sod = null;
        try {
            Station s;
            if (debug) {
                System.out.println("scanStation open " + url);
            }
            if ((s = (sod = (StationObsDataset)TypedDatasetFactory.open((FeatureType)FeatureType.STATION, (String)url, null, (StringBuilder)new StringBuilder())).getStation(station)) == null) {
                return;
            }
            DataIterator iter = sod.getDataIterator(s);
            while (iter.hasNext()) {
                StationObsDatatype dtype = (StationObsDatatype)iter.nextData();
                StructureData sdata = dtype.getData();
                if (p.match(sdata)) {
                    a.act(sdata);
                    ++limit.matches;
                }
                ++limit.count;
                if (limit.count <= limit.limit) continue;
                break;
            }
        }
        finally {
            if (null != sod) {
                sod.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void scanAll(String url, Predicate p, Action a, Limit limit) throws IOException {
        PointObsDataset dataset = null;
        try {
            if (debug) {
                System.out.println("scanAll open " + url);
            }
            dataset = (PointObsDataset)TypedDatasetFactory.open((FeatureType)FeatureType.POINT, (String)url, null, (StringBuilder)new StringBuilder());
            DataIterator iter = dataset.getDataIterator(0);
            while (iter.hasNext()) {
                PointObsDatatype pobs = (PointObsDatatype)iter.nextData();
                StructureData sdata = pobs.getData();
                if (p.match(sdata)) {
                    a.act(sdata);
                    ++limit.matches;
                }
                ++limit.count;
                if (limit.count <= limit.limit) continue;
                break;
            }
        }
        finally {
            if (null != dataset) {
                dataset.close();
            }
        }
    }

    public void timeNetcdf() throws IOException {
        Limit limit = new Limit();
        Predicate p = new Predicate(){

            @Override
            public boolean match(StructureData sdata) {
                return sdata.getScalarFloat("wind_peak_speed") > 10.0f;
            }
        };
        Action act = new Action(){

            @Override
            public void act(StructureData sdata) {
            }
        };
        long start = System.currentTimeMillis();
        for (int i = 0; i < fileList.size(); ++i) {
            String s = (String)fileList.get(i);
            TimeStationObs.scanAll(s, p, act, limit);
        }
        long took = System.currentTimeMillis() - start;
        double mps = (long)(1000 * limit.count) / took;
        System.out.println("\nscanAllNetcdf successfully read " + limit.count + " records; found " + limit.matches + " matches");
        System.out.println("that took = " + took + " msecs; messages/sec = " + mps);
        timeToScan = took;
    }

    public void timeNetcdfStation() throws IOException {
        Limit limit = new Limit();
        Predicate p = new Predicate(){

            @Override
            public boolean match(StructureData sdata) {
                return true;
            }
        };
        Action act = new Action(){

            @Override
            public void act(StructureData sdata) {
            }
        };
        long start = System.currentTimeMillis();
        for (int i = 0; i < fileList.size(); ++i) {
            String s = (String)fileList.get(i);
            TimeStationObs.scanStation(s, "ACK", p, act, limit);
        }
        long took = System.currentTimeMillis() - start;
        double mps = (long)(1000 * limit.count) / took;
        System.out.println("\ntimeNetcdfStation successfully read " + limit.count + " records; found " + limit.matches + " matches");
        System.out.println("that took = " + took + " msecs; obs/sec= " + mps);
    }

    public void writeXML() throws IOException {
        xout = new DataOutputStream(new BufferedOutputStream(new FileOutputStream("C:/temp/temp2.xml"), 10000));
        xout.writeBytes("<?xml version='1.0' encoding='UTF-8'?>\n");
        xout.writeBytes("<metarCollection dataset='name'>\n");
        Limit limit = new Limit();
        Predicate p = new Predicate(){

            @Override
            public boolean match(StructureData sdata) {
                return sdata.getScalarFloat("wind_peak_speed") > 10.0f;
            }
        };
        Action act = new Action(){

            @Override
            public void act(StructureData sdata) throws IOException {
                xout.writeBytes("  <metar>\n");
                for (StructureMembers.Member m : sdata.getMembers()) {
                    xout.writeBytes("    <data name='" + m.getName() + "'>");
                    Array sdataArray = sdata.getArray(m);
                    xout.writeBytes(sdataArray.toString() + "</data>\n");
                }
                xout.writeBytes("  </metar>\n");
            }
        };
        long start = System.currentTimeMillis();
        for (int i = 0; i < fileList.size(); ++i) {
            String s = (String)fileList.get(i);
            TimeStationObs.scanAll(s, p, act, limit);
        }
        xout.writeBytes("</metarCollection>\n");
        xout.close();
        long took = System.currentTimeMillis() - start;
        System.out.println("\nscanAllNetcdf  read " + limit.count + " records; match and write " + limit.matches + " XML records");
        System.out.println("that took = " + took + " msecs");
        long writeTime = took - timeToScan;
        double mps = (long)(1000 * limit.matches) / writeTime;
        System.out.println("  writeTime = " + writeTime + " msecs; write messages/sec = " + mps);
    }

    public void writeRaw() throws IOException {
        this.fout = new BufferedOutputStream(new FileOutputStream("C:/temp/raw.txt"), 10000);
        Limit limit = new Limit();
        Predicate p = new Predicate(){

            @Override
            public boolean match(StructureData sdata) {
                return sdata.getScalarFloat("wind_peak_speed") > 10.0f;
            }
        };
        Action act = new Action(){

            @Override
            public void act(StructureData sdata) throws IOException {
                String report = sdata.getScalarString("report");
                TimeStationObs.this.fout.write(report.getBytes());
                TimeStationObs.this.fout.write(10);
            }
        };
        long start = System.currentTimeMillis();
        for (int i = 0; i < fileList.size(); ++i) {
            String s = (String)fileList.get(i);
            TimeStationObs.scanAll(s, p, act, limit);
        }
        this.fout.close();
        long took = System.currentTimeMillis() - start;
        System.out.println("\nscanAllNetcdf  read " + limit.count + " records; match and write " + limit.matches + " raw records");
        System.out.println("that took = " + took + " msecs");
        long writeTime = took - timeToScan;
        double mps = (long)(1000 * limit.matches) / writeTime;
        System.out.println("  writeTime = " + writeTime + " msecs; write messages/sec = " + mps);
    }

    private static void getFiles(String dirName) {
        double size = 0.0;
        int count = 0;
        File dir = new File(dirName);
        File[] files = dir.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String fileS = file.getAbsolutePath();
            if (!fileS.contains("Surface") || !fileS.endsWith(".nc")) continue;
            fileList.add(fileS);
            size += (double)file.length();
            ++count;
        }
        System.out.println("Reading directory " + dirName + " # files = " + count + " total file sizes = " + size / 1000.0 / 1000.0 + " Mb");
    }

    public static void main(String[] args) throws IOException {
        TimeStationObs.getFiles("C:/data/metars/");
        TimeStationObs t = new TimeStationObs();
        t.timeNetcdf();
        t.writeXML();
        t.writeRaw();
        t.timeNetcdfStation();
    }

    static {
        fileList = new ArrayList();
    }

    private class Limit {
        int count;
        int limit = Integer.MAX_VALUE;
        int matches;

        private Limit() {
        }
    }

    private static interface Action {
        public void act(StructureData var1) throws IOException;
    }

    private static interface Predicate {
        public boolean match(StructureData var1);
    }
}

