/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.util.ArrayList;
import junit.framework.TestCase;
import ucar.nc2.TestAll;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.dt.grid.NetcdfCFWriter;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class TestCFWriter
extends TestCase {
    public TestCFWriter(String name) {
        super(name);
    }

    public void testSubset() throws Exception {
        String fileIn = TestAll.cdmUnitTestDir + "grid/testCFwriter.nc";
        String fileOut = TestAll.temporaryLocalDataDir + "testCFwriter.nc";
        String varName = "Temperature";
        GridDataset gds = GridDataset.open((String)fileIn);
        ArrayList<String> gridList = new ArrayList<String>();
        gridList.add(varName);
        NetcdfCFWriter writer = new NetcdfCFWriter();
        writer.makeFile(fileOut, (ucar.nc2.dt.GridDataset)gds, gridList, new LatLonRect((LatLonPoint)new LatLonPointImpl(30.0, -109.0), 10.0, 50.0), null, true, 1, 1, 1);
        gds.close();
        GridDataset result = GridDataset.open((String)fileOut);
        GeoGrid grid = result.findGridByName(varName);
        assert (grid != null);
        result.close();
    }
}

