/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.IOException;
import java.io.PrintStream;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.Index;
import ucar.ma2.Range;
import ucar.nc2.Dimension;
import ucar.nc2.NCdump;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.dt.grid.TestGrid;

public class TestGeoGrid
extends TestCase {
    private boolean show = false;

    public TestGeoGrid(String name) {
        super(name);
    }

    public void testSubset() throws Exception {
        GridDataset dataset = GridDataset.open((String)(TestGrid.topDir + "rankTest.nc"));
        GeoGrid grid = dataset.findGridByName("full4");
        assert (null != grid);
        GridCoordSystem gcs = grid.getCoordinateSystem();
        assert (null != gcs);
        assert (grid.getRank() == 4);
        this.doRead4(grid);
        GeoGrid grid_section = grid.subset(null, new Range(0, 3, 2), null, null);
        GridCoordSystem gcs_section = grid_section.getCoordinateSystem();
        CoordinateAxis1D zaxis = gcs_section.getVerticalAxis();
        assert (zaxis.getSize() == 2L);
        assert (gcs_section.getXHorizAxis().equals((Object)gcs.getXHorizAxis()));
        assert (gcs_section.getYHorizAxis().equals((Object)gcs.getYHorizAxis()));
        assert (gcs_section.getTimeAxis().equals((Object)gcs.getTimeAxis()));
        Array data = grid_section.readDataSlice(-1, -1, -1, -1);
        NCdump.printArray((Array)data, (String)"grid_section", (PrintStream)System.out, null);
        dataset.close();
    }

    private void doRead4(GeoGrid gg) throws IOException {
        Array aa = gg.readDataSlice(-1, -1, -1, -1);
        int[] shape = aa.getShape();
        Index ima = aa.getIndex();
        int[] w = this.getWeights(gg);
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                for (int k = 0; k < shape[2]; ++k) {
                    for (int m = 0; m < shape[3]; ++m) {
                        double got = aa.getDouble(ima.set(i, j, k, m));
                        double want = i * w[0] + j * w[1] + k * w[2] + m * w[3];
                        assert (got == want) : "got " + got + " want " + want;
                    }
                }
            }
        }
        System.out.println("ok reading " + gg.getName());
    }

    private int[] getWeights(GeoGrid gg) {
        int rank = gg.getRank();
        int[] w = new int[rank];
        for (int n = 0; n < rank; ++n) {
            Dimension dim = gg.getDimension(n);
            String dimName = dim.getName();
            if (dimName.equals("time")) {
                w[n] = 1000;
            }
            if (dimName.equals("z")) {
                w[n] = 100;
            }
            if (dimName.equals("y")) {
                w[n] = 10;
            }
            if (!dimName.equals("x")) continue;
            w[n] = 1;
        }
        return w;
    }

    public void utestAxisId() throws IOException {
        GridDataset dataset = GridDataset.open((String)"C:/data/20100314_v_000000_l_0118800.nc");
        GeoGrid grid = dataset.findGridByName("wind_speed");
        assert (null != grid);
        GridCoordSystem gcs = grid.getCoordinateSystem();
        assert (null != gcs);
        assert (grid.getRank() == 3);
        CoordinateAxis axis = gcs.getXHorizAxis();
        assert (axis != null);
        assert (axis.getName().equals("x")) : axis.getName();
        axis = gcs.getYHorizAxis();
        assert (axis != null);
        assert (axis.getName().equals("y")) : axis.getName();
        dataset.close();
    }
}

