/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.DataType;
import ucar.nc2.NetcdfFile;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.TestAll;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.util.IO;
import ucar.unidata.io.RandomAccessFile;

public class TestGridClose
extends TestCase {
    private String newVarName = "some_data";

    public TestGridClose(String name) {
        super(name);
    }

    public void testClose() throws IOException {
        File org = new File(TestAll.cdmLocalTestDataDir + "rankTest.nc");
        File copy = new File(TestAll.temporaryLocalDataDir + "rankTest.nc");
        IO.copyFile((File)org, (File)copy);
        String url = copy.getPath();
        RandomAccessFile.setDebugLeaks((boolean)true);
        this.openDatasetAndView(url);
        this.alterExistingFile(url);
        this.checkFile(url);
        TestAll.checkLeaks();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openDatasetAndView(String url) throws IOException {
        GridDataset dataset = null;
        try {
            dataset = GridDataset.open((String)url);
            for (GridDatatype grid : dataset.getGrids()) {
                Array temp_data = grid.readDataSlice(0, 0, -1, -1);
                System.err.println("Min is: " + grid.getMinMaxSkipMissingData((Array)temp_data).min);
                System.err.println("Max is: " + grid.getMinMaxSkipMissingData((Array)temp_data).max);
            }
        }
        finally {
            if (dataset != null) {
                dataset.getNetcdfFile().close();
                dataset.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void alterExistingFile(String url) throws IOException {
        NetcdfFileWriteable file = null;
        try {
            file = NetcdfFileWriteable.openExisting((String)url, (boolean)false);
            file.setRedefineMode(true);
            file.addVariable(null, this.newVarName, DataType.FLOAT, "z y x");
        }
        finally {
            if (file != null) {
                file.setRedefineMode(false);
                file.flush();
                file.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkFile(String url) throws IOException {
        NetcdfFile file = null;
        try {
            file = NetcdfFile.open((String)url, null);
            System.out.printf("%s%n", file);
            assert (file.findVariable(this.newVarName) != null);
        }
        finally {
            if (file != null) {
                file.close();
            }
        }
    }
}

