/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.List;
import junit.framework.TestCase;
import ucar.nc2.TestAll;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dt.grid.GridCoordSys;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.iosp.grib.GribGridServiceProvider;
import ucar.nc2.ncml.NcMLReader;

public class TestReadandCount
extends TestCase {
    private static boolean show = false;
    private static boolean showCount = true;
    private String griddir = TestAll.testdataDir + "grid/netcdf/";

    public TestReadandCount(String name) {
        super(name);
    }

    public void testRead1() throws Exception {
        TestReadandCount.doOne(this.griddir + "avhrr/", "amsr-avhrr-v2.20040729.nc", 0, 1, 4, 0);
    }

    public void testRead() throws Exception {
        TestReadandCount.doOne(this.griddir + "coards/", "inittest24.QRIDV07200.ncml", 1, 1, 3, 1);
        TestReadandCount.doOne(this.griddir + "csm/", "o3monthly.nc", 4, 1, 7, 2);
        TestReadandCount.doOne(this.griddir + "csm/", "ha0001.nc", 35, 3, 5, 2);
        TestReadandCount.doOne(this.griddir + "cf/", "cf1.nc", 1, 1, 5, 2);
        TestReadandCount.doOne(this.griddir + "cf/", "ccsm2.nc", 107, 3, 5, 2);
        TestReadandCount.doOne(this.griddir + "cf/", "tomw.nc", 19, 3, 4, 1);
        TestReadandCount.doOne(this.griddir + "cf/", "cf1_rap.nc", 11, 2, 4, 0);
        TestReadandCount.doOne(this.griddir + "cf/", "feb2003_short2.nc", 22, 9, 8, 1);
        TestReadandCount.doOne(this.griddir + "cf/", "temperature.nc", 4, 3, 5, 1);
        TestReadandCount.doOne(this.griddir + "gdv/", "testGDV.nc", 30, 1, 4, 1);
        TestReadandCount.doOne(this.griddir + "gdv/", "OceanDJF.nc", 15, 1, 4, 1);
        TestReadandCount.doOne(this.griddir + "mars/", "temp_air_01082000.nc", 1, 1, 4, 1);
        TestReadandCount.doOne(this.griddir + "m3io/", "agg.cctmJ3fx.b312.nh3c1.dep_wa.annual.2001base.nc", 13, 1, 5, 1);
        TestReadandCount.doOne(this.griddir + "m3io/", "19L.nc", 23, 1, 4, 1);
        TestReadandCount.doOne(this.griddir + "nuwg/", "avn-x.nc", 31, 4, 8, 4);
        TestReadandCount.doOne(this.griddir + "nuwg/", "2003021212_avn-x.nc", 30, 5, 7, 4);
        TestReadandCount.doOne(this.griddir + "nuwg/", "avn-q.nc", 22, 7, 9, 6);
        TestReadandCount.doOne(this.griddir + "nuwg/", "eta.nc", 28, 9, 11, 8);
        TestReadandCount.doOne(this.griddir + "nuwg/", "ocean.nc", 5, 1, 3, 0);
        TestReadandCount.doOne(this.griddir + "nuwg/", "ruc.nc", 31, 5, 6, 3);
        TestReadandCount.doOne(this.griddir + "nuwg/", "CMC-HGT.nc", 1, 1, 3, 0);
        TestReadandCount.doOne(this.griddir + "wrf/", "wrfout_v2_Lambert.nc", 57, 11, 8, 3);
        TestReadandCount.doOne(this.griddir + "wrf/", "wrf2-2005-02-01_12.nc", 60, 11, 8, 3);
        TestReadandCount.doOne(this.griddir + "wrf/", "wrfout_d01_2006-03-08_21-00-00", 70, 11, 8, 3);
        TestReadandCount.doOne(this.griddir + "wrf/", "wrfrst_d01_2002-07-02_12_00_00.nc", 162, 11, 8, 3);
        TestReadandCount.doOne(this.griddir + "awips/", "19981109_1200.nc", 36, 13, 14, 11);
        TestReadandCount.doOne(this.griddir + "awips/", "awips.nc", 38, 12, 13, 10);
        TestReadandCount.doOne(this.griddir + "ifps/", "HUNGrids.netcdf", 26, 26, 29, 0);
        TestReadandCount.doOne(TestAll.testdataDir + "grid/grib/grib1/data/", "AVN.wmo", 22, -1, -1, -1);
        TestReadandCount.doOne(TestAll.testdataDir + "grid/grib/grib1/data/", "RUC_W.wmo", 44, -1, -1, -1);
        TestReadandCount.doOne(TestAll.testdataDir + "grid/grib/grib1/data/", "NOGAPS-Temp-Regional.grib", 1, -1, -1, -1);
        TestReadandCount.doOne(TestAll.testdataDir + "grid/grib/grib2/data/", "eta2.wmo", 35, -1, -1, -1);
        TestReadandCount.doOne(TestAll.testdataDir + "grid/grib/grib2/data/", "ndfd.wmo", 1, -1, -1, -1);
        TestReadandCount.doOne(TestAll.testdataDir + "grid/grib/grib1/data/", "radar_national.grib", 1, 1, 3, 0);
        TestReadandCount.doOne(TestAll.testdataDir + "grid/grib/grib1/data/", "radar_regional.grib", 1, 1, 3, 0);
        GribGridServiceProvider.forceNewIndex((boolean)true);
        TestReadandCount.doOne(TestAll.testdataDir + "grid/grib/grib1/data/", "AVN.wmo", 22, -1, -1, -1);
        TestReadandCount.doOne(TestAll.testdataDir + "grid/grib/grib1/data/", "RUC_W.wmo", 44, -1, -1, -1);
        TestReadandCount.doOne(TestAll.testdataDir + "grid/grib/grib2/data/", "eta2.wmo", 35, -1, -1, -1);
        TestReadandCount.doOne(TestAll.testdataDir + "grid/grib/grib2/data/", "ndfd.wmo", 1, -1, -1, -1);
        GribGridServiceProvider.forceNewIndex((boolean)false);
    }

    static void doOne(String dir, String filename, int ngrids, int ncoordSys, int ncoordAxes, int nVertCooordAxes) throws Exception {
        System.out.println("test read GridDataset = " + dir + filename);
        GridDataset gridDs = GridDataset.open((String)(dir + filename));
        int countGrids = gridDs.getGrids().size();
        int countCoordAxes = gridDs.getNetcdfDataset().getCoordinateAxes().size();
        int countCoordSys = gridDs.getNetcdfDataset().getCoordinateSystems().size();
        int countVertCooordAxes = 0;
        List axes = gridDs.getNetcdfDataset().getCoordinateAxes();
        for (int i = 0; i < axes.size(); ++i) {
            CoordinateAxis axis = (CoordinateAxis)axes.get(i);
            AxisType t = axis.getAxisType();
            if (t != AxisType.GeoZ && t != AxisType.Height && t != AxisType.Pressure) continue;
            ++countVertCooordAxes;
        }
        for (GridDataset.Gridset gridset : gridDs.getGridsets()) {
            GridCoordSys gcs = gridset.getGeoCoordSys();
        }
        if (showCount) {
            System.out.println(" grids=" + countGrids + (ngrids < 0 ? " *" : ""));
            System.out.println(" coordSys=" + countCoordSys + (ncoordSys < 0 ? " *" : ""));
            System.out.println(" coordAxes=" + countCoordAxes + (ncoordAxes < 0 ? " *" : ""));
            System.out.println(" vertAxes=" + countVertCooordAxes + (nVertCooordAxes < 0 ? " *" : ""));
        }
        if (ngrids >= 0) assert (ngrids == countGrids) : "Grids " + ngrids + " != " + countGrids;
        if (ncoordSys >= 0) assert (ncoordSys == countCoordSys) : "CoordSys " + ncoordSys + " != " + countCoordSys;
        if (ncoordAxes >= 0) assert (ncoordAxes == countCoordAxes) : "CoordAxes " + ncoordAxes + " != " + countCoordAxes;
        if (nVertCooordAxes >= 0) assert (nVertCooordAxes == countVertCooordAxes) : "VertAxes" + nVertCooordAxes + " != " + countVertCooordAxes;
        gridDs.close();
    }

    public void utestReadNcMLInputStream() throws Exception {
        String ncmlLoc = "file:C:\\data\\work\\margolis\\test.ncml";
        GridDataset fullDataset = GridDataset.open((String)ncmlLoc);
        System.out.printf("full size= %d%n", fullDataset.getGrids().size());
        String ncml = "<?xml version='1.0' encoding='UTF-8'?>\n<netcdf xmlns='http://www.unidata.ucar.edu/namespaces/netcdf/ncml-2.2'>\n  <variable name='time'>\n    <attribute name='ncmlAdded' value='timeAtt'/>\n  </variable>\n  <aggregation dimName='time' type='joinExisting'>\n    <netcdf location='file:C:\\data\\work\\margolis\\f_0000000.nc'/>\n    <netcdf location='file:C:\\data\\work\\margolis\\f_0032400.nc'/>\n  </aggregation>\n</netcdf>";
        NetcdfDataset aggregatedDataset = NcMLReader.readNcML((InputStream)new ByteArrayInputStream(ncml.getBytes()), null);
        GridDataset emptyDataset = new GridDataset(aggregatedDataset);
        System.out.printf("empty= %s%n", emptyDataset.getGrids().size());
        assert (emptyDataset.getGrids().size() == fullDataset.getGrids().size());
    }

    public static void main(String[] arg) throws Exception {
        TestReadandCount.doOne(TestAll.testdataDir + "grid/grib/grib1/data/", "radar_regional.grib", 1, -1, -1, -1);
    }
}

