/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import junit.framework.TestCase;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.dt.grid.TestReadandCount;
import ucar.nc2.util.CompareNetcdf;

public class TestReadandCountGrib
extends TestCase {
    public TestReadandCountGrib(String name) {
        super(name);
    }

    public void testRead() throws Exception {
        this.doOne("grib1/data/", "cfs.wmo", 51, 4, 6, 3);
        this.doOne("grib1/data/", "eta218.grb", 14, 6, 8, 4);
        this.doOne("grib1/data/", "extended.wmo", 8, 6, 10, 4);
        this.doOne("grib1/data/", "ensemble.wmo", 24, 16, 20, 10);
        this.doOne("grib1/data/", "don_ETA.wmo", 28, 11, 13, 8);
        this.doOne("grib1/data/", "pgbanl.fnl", 76, 15, 17, 14);
        this.doOne("grib1/data/", "radar_national_rcm.grib", 1, 1, 3, 0);
        this.doOne("grib1/data/", "radar_national.grib", 1, 1, 3, 0);
        this.doOne("grib1/data/", "AVN.wmo", 22, 10, 12, 7);
        this.doOne("grib1/data/", "AVN-I.wmo", 20, 8, 10, 7);
        this.doOne("grib1/data/", "MRF.wmo", 15, 8, 10, 6);
        this.doOne("grib1/data/", "OCEAN.wmo", 4, 4, 12, 0);
        this.doOne("grib1/data/", "RUC.wmo", 27, 7, 10, 5);
        this.doOne("grib1/data/", "RUC2.wmo", 44, 10, 13, 5);
        this.doOne("grib1/data/", "WAVE.wmo", 28, 12, 24, 4);
        this.doOne("grib2/data/", "eta2.wmo", 35, 9, 11, 7);
        this.doOne("grib2/data/", "ndfd.wmo", 1, 1, 3, 0);
        this.doOne("grib2/data/", "PMSL_000", 1, 1, 3, 0);
        this.doOne("grib2/data/", "CLDGRIB2.2005040905", 5, 1, 3, 0);
        this.doOne("grib2/data/", "LMPEF_CLM_050518_1200.grb", 1, 1, 3, 0);
        this.doOne("grib2/data/", "AVOR_000.grb", 1, 2, 4, 1);
        this.doOne("grib2/data/", "AVN.5deg.wmo", 117, 15, 16, 12);
    }

    private void doOne(String dir, String filename, int ngrids, int ncoordSys, int ncoordAxes, int nVertCooordAxes) throws Exception {
        dir = TestAll.testdataDir + "grid/grib/" + dir;
        TestReadandCount.doOne(dir, filename, ngrids, ncoordSys, ncoordAxes, nVertCooordAxes);
    }

    public void testProblem() throws Exception {
        this.doOne("grib2/data/", "CLDGRIB2.2005040905", 5, 1, 3, 0);
    }

    public static void main(String[] arg) throws Exception {
        NetcdfFile ncfile = NetcdfFile.open((String)"//shemp/testdata/grid/grib/grib1/data/ukm.wmo", null);
        NetcdfFile ncfile1 = NetcdfFile.open((String)"//shemp/testdata/grid/grib/grib1/data/ukm1.wmo", null);
        CompareNetcdf.compareFiles((NetcdfFile)ncfile, (NetcdfFile)ncfile1, (boolean)false, (boolean)false, (boolean)false);
    }
}

