/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.util.Formatter;
import junit.framework.TestCase;
import ucar.ma2.ArrayDouble;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.grid.GeoGrid;
import ucar.nc2.dt.grid.GridDataset;
import ucar.unidata.geoloc.vertical.VerticalTransform;

public class TestStag3D
extends TestCase {
    public TestStag3D(String name) {
        super(name);
    }

    public void testSubset() throws Exception {
        GridDataset dataset = GridDataset.open((String)"D:/work/signell/stag/bora_feb.nc");
        GeoGrid grid = dataset.findGridByName("u");
        assert (null != grid);
        System.out.printf("u shape= %s%n", this.showShape(grid.getShape()));
        GridCoordSystem gcs = grid.getCoordinateSystem();
        assert (null != gcs);
        assert (grid.getRank() == 4);
        VerticalTransform vt = gcs.getVerticalTransform();
        ArrayDouble.D3 a = vt.getCoordinateArray(0);
        System.out.printf("vt shape= %s%n", this.showShape(a.getShape()));
        dataset.close();
    }

    private String showShape(int[] shape) {
        Formatter f = new Formatter();
        for (int s : shape) {
            f.format(" %d", s);
        }
        return f.toString();
    }
}

