/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.grid;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;
import ucar.nc2.Variable;
import ucar.nc2.dt.grid.TestGrid;

public class TestWritePermute
extends TestCase {
    private boolean show = false;

    public TestWritePermute(String name) {
        super(name);
    }

    public void testWritePermute() throws Exception {
        block22: {
            NetcdfFileWriteable ncfile;
            block21: {
                int[] origin;
                Index ima;
                ArrayDouble.D1 A;
                int len;
                Dimension xDim;
                block20: {
                    Dimension yDim;
                    block19: {
                        Dimension zDim;
                        block18: {
                            Dimension tDim;
                            block17: {
                                ncfile = new NetcdfFileWriteable();
                                ncfile.setName(TestGrid.topDir + "permuteTest.nc");
                                xDim = ncfile.addDimension("x", 3);
                                yDim = ncfile.addDimension("y", 5);
                                zDim = ncfile.addDimension("z", 4);
                                tDim = ncfile.addDimension("time", 2);
                                ncfile.addVariable("time", Double.TYPE, new Dimension[]{tDim});
                                ncfile.addVariableAttribute("time", "units", "secs since 1-1-1 00:00");
                                ncfile.addVariable("z", Double.TYPE, new Dimension[]{zDim});
                                ncfile.addVariableAttribute("z", "units", "meters");
                                ncfile.addVariableAttribute("z", "positive", "up");
                                ncfile.addVariable("y", Double.TYPE, new Dimension[]{yDim});
                                ncfile.addVariableAttribute("y", "units", "degrees_north");
                                ncfile.addVariable("x", Double.TYPE, new Dimension[]{xDim});
                                ncfile.addVariableAttribute("x", "units", "degrees_east");
                                ncfile.addVariable("tzyx", Double.TYPE, new Dimension[]{tDim, zDim, yDim, xDim});
                                ncfile.addVariableAttribute("tzyx", "units", "K");
                                ncfile.addVariable("tzxy", Double.TYPE, new Dimension[]{tDim, zDim, xDim, yDim});
                                ncfile.addVariableAttribute("tzxy", "units", "K");
                                ncfile.addVariable("tyxz", Double.TYPE, new Dimension[]{tDim, yDim, xDim, zDim});
                                ncfile.addVariableAttribute("tyxz", "units", "K");
                                ncfile.addVariable("txyz", Double.TYPE, new Dimension[]{tDim, xDim, yDim, zDim});
                                ncfile.addVariableAttribute("txyz", "units", "K");
                                ncfile.addVariable("zyxt", Double.TYPE, new Dimension[]{zDim, yDim, xDim, tDim});
                                ncfile.addVariableAttribute("zyxt", "units", "K");
                                ncfile.addVariable("zxyt", Double.TYPE, new Dimension[]{zDim, xDim, yDim, tDim});
                                ncfile.addVariableAttribute("zxyt", "units", "K");
                                ncfile.addVariable("yxzt", Double.TYPE, new Dimension[]{yDim, xDim, zDim, tDim});
                                ncfile.addVariableAttribute("yxzt", "units", "K");
                                ncfile.addVariable("xyzt", Double.TYPE, new Dimension[]{xDim, yDim, zDim, tDim});
                                ncfile.addVariableAttribute("xyzt", "units", "K");
                                ncfile.addVariable("zyx", Double.TYPE, new Dimension[]{zDim, yDim, xDim});
                                ncfile.addVariable("txy", Double.TYPE, new Dimension[]{tDim, xDim, yDim});
                                ncfile.addVariable("yxz", Double.TYPE, new Dimension[]{yDim, xDim, zDim});
                                ncfile.addVariable("xzy", Double.TYPE, new Dimension[]{xDim, zDim, yDim});
                                ncfile.addVariable("yxt", Double.TYPE, new Dimension[]{yDim, xDim, tDim});
                                ncfile.addVariable("xyt", Double.TYPE, new Dimension[]{xDim, yDim, tDim});
                                ncfile.addVariable("xyz", Double.TYPE, new Dimension[]{xDim, yDim, zDim});
                                ncfile.addVariable("yx", Double.TYPE, new Dimension[]{yDim, xDim});
                                ncfile.addVariable("xy", Double.TYPE, new Dimension[]{xDim, yDim});
                                ncfile.addVariable("yz", Double.TYPE, new Dimension[]{yDim, zDim});
                                ncfile.addVariable("xz", Double.TYPE, new Dimension[]{xDim, zDim});
                                ncfile.addVariable("yt", Double.TYPE, new Dimension[]{yDim, tDim});
                                ncfile.addVariable("xt", Double.TYPE, new Dimension[]{xDim, tDim});
                                ncfile.addVariable("ty", Double.TYPE, new Dimension[]{tDim, yDim});
                                ncfile.addVariable("tx", Double.TYPE, new Dimension[]{tDim, xDim});
                                ncfile.addGlobalAttribute("Convention", "COARDS");
                                try {
                                    ncfile.create();
                                }
                                catch (IOException e) {
                                    System.err.println("ERROR creating file");
                                    if ($assertionsDisabled) break block17;
                                    throw new AssertionError();
                                }
                            }
                            len = tDim.getLength();
                            A = new ArrayDouble.D1(len);
                            ima = A.getIndex();
                            for (int i = 0; i < len; ++i) {
                                A.setDouble(ima.set(i), (double)(i * 3600));
                            }
                            origin = new int[1];
                            try {
                                ncfile.write("time", origin, (Array)A);
                            }
                            catch (IOException e) {
                                System.err.println("ERROR writing time");
                                if ($assertionsDisabled) break block18;
                                throw new AssertionError();
                            }
                        }
                        len = zDim.getLength();
                        A = new ArrayDouble.D1(len);
                        ima = A.getIndex();
                        for (int i = 0; i < len; ++i) {
                            A.setDouble(ima.set(i), (double)(i * 10));
                        }
                        try {
                            ncfile.write("z", origin, (Array)A);
                        }
                        catch (IOException e) {
                            System.err.println("ERROR writing z");
                            if ($assertionsDisabled) break block19;
                            throw new AssertionError();
                        }
                    }
                    len = yDim.getLength();
                    A = new ArrayDouble.D1(len);
                    ima = A.getIndex();
                    for (int i = 0; i < len; ++i) {
                        A.setDouble(ima.set(i), (double)(i * 3));
                    }
                    try {
                        ncfile.write("y", origin, (Array)A);
                    }
                    catch (IOException e) {
                        System.err.println("ERROR writing y");
                        if ($assertionsDisabled) break block20;
                        throw new AssertionError();
                    }
                }
                len = xDim.getLength();
                A = new ArrayDouble.D1(len);
                ima = A.getIndex();
                for (int i = 0; i < len; ++i) {
                    A.setDouble(ima.set(i), (double)(i * 5));
                }
                try {
                    ncfile.write("x", origin, (Array)A);
                }
                catch (IOException e) {
                    System.err.println("ERROR writing x");
                    if ($assertionsDisabled) break block21;
                    throw new AssertionError();
                }
            }
            this.doWrite4(ncfile, "tzyx");
            this.doWrite4(ncfile, "tzxy");
            this.doWrite4(ncfile, "txyz");
            this.doWrite4(ncfile, "tyxz");
            this.doWrite4(ncfile, "zyxt");
            this.doWrite4(ncfile, "zxyt");
            this.doWrite4(ncfile, "xyzt");
            this.doWrite4(ncfile, "yxzt");
            this.doWrite3(ncfile, "zyx");
            this.doWrite3(ncfile, "txy");
            this.doWrite3(ncfile, "yxz");
            this.doWrite3(ncfile, "xzy");
            this.doWrite3(ncfile, "yxt");
            this.doWrite3(ncfile, "xyt");
            this.doWrite3(ncfile, "yxt");
            this.doWrite3(ncfile, "xyz");
            this.doWrite2(ncfile, "yx");
            this.doWrite2(ncfile, "xy");
            this.doWrite2(ncfile, "yz");
            this.doWrite2(ncfile, "xz");
            this.doWrite2(ncfile, "yt");
            this.doWrite2(ncfile, "xt");
            this.doWrite2(ncfile, "ty");
            this.doWrite2(ncfile, "tx");
            if (this.show) {
                System.out.println("ncfile = " + ncfile);
            }
            try {
                ncfile.close();
            }
            catch (IOException e) {
                System.err.println("ERROR writing file");
                if ($assertionsDisabled) break block22;
                throw new AssertionError();
            }
        }
        System.out.println("*****************Test Write done");
    }

    private void doWrite4(NetcdfFileWriteable ncfile, String varName) throws Exception {
        Variable v = ncfile.findVariable(varName);
        int[] w = this.getWeights(v);
        int[] shape = v.getShape();
        Array aa = Array.factory((Class)v.getDataType().getPrimitiveClassType(), (int[])shape);
        Index ima = aa.getIndex();
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                for (int k = 0; k < shape[2]; ++k) {
                    for (int m = 0; m < shape[3]; ++m) {
                        aa.setDouble(ima.set(i, j, k, m), (double)(i * w[0] + j * w[1] + k * w[2] + m * w[3]));
                    }
                }
            }
        }
        ncfile.write(varName, aa);
    }

    private void doWrite3(NetcdfFileWriteable ncfile, String varName) throws Exception {
        Variable v = ncfile.findVariable(varName);
        int[] w = this.getWeights(v);
        int[] shape = v.getShape();
        Array aa = Array.factory((Class)v.getDataType().getPrimitiveClassType(), (int[])shape);
        Index ima = aa.getIndex();
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                for (int k = 0; k < shape[2]; ++k) {
                    aa.setDouble(ima.set(i, j, k), (double)(i * w[0] + j * w[1] + k * w[2]));
                }
            }
        }
        ncfile.write(varName, aa);
    }

    private void doWrite2(NetcdfFileWriteable ncfile, String varName) throws Exception {
        Variable v = ncfile.findVariable(varName);
        int[] w = this.getWeights(v);
        int[] shape = v.getShape();
        Array aa = Array.factory((Class)v.getDataType().getPrimitiveClassType(), (int[])shape);
        Index ima = aa.getIndex();
        for (int i = 0; i < shape[0]; ++i) {
            for (int j = 0; j < shape[1]; ++j) {
                aa.setDouble(ima.set(i, j), (double)(i * w[0] + j * w[1]));
            }
        }
        ncfile.write(varName, aa);
    }

    private int[] getWeights(Variable v) {
        int rank = v.getRank();
        int[] w = new int[rank];
        for (int n = 0; n < rank; ++n) {
            Dimension dim = v.getDimension(n);
            String dimName = dim.getName();
            if (dimName.equals("time")) {
                w[n] = 1000;
            }
            if (dimName.equals("z")) {
                w[n] = 100;
            }
            if (dimName.equals("y")) {
                w[n] = 10;
            }
            if (!dimName.equals("x")) continue;
            w[n] = 1;
        }
        return w;
    }
}

