/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.radial;

import java.io.File;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import ucar.nc2.TestAll;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class TestRadialDataset
extends TestCase {
    private String topDir = TestAll.testdataDir + "radar/";
    private boolean show = false;
    private boolean showTime = false;
    private boolean doQuick = true;

    public TestRadialDataset(String name) {
        super(name);
    }

    public void testNexrad2Dataset() throws IOException {
        this.testAllMethods(this.topDir + "nexrad/level2/Level2_KYUX_20060527_2335.ar2v");
    }

    public void testReadDirectory() throws IOException {
        long start = System.currentTimeMillis();
        this.doDirectory(TestAll.testdataDir + "radar/nexrad/level2/", false, 10, ".raw");
        long took = System.currentTimeMillis() - start;
        System.out.println("that took = " + took + " msec");
    }

    private int doDirectory(String dirName, boolean alwaysUncompress, int max, String suffix) throws IOException {
        File dir = new File(dirName);
        if (!dir.exists()) {
            System.out.println("TestRadialDataset.doDirectory(): non-existent directory <" + dirName + ">.");
            throw new IllegalArgumentException("Non-existent directory <" + dirName + ">.");
        }
        File[] files = dir.listFiles();
        if (alwaysUncompress) {
            for (int i = 0; i < files.length; ++i) {
                File file = files[i];
                String path = file.getPath();
                if (!path.endsWith(".uncompress")) continue;
                file.delete();
            }
        }
        int count = 0;
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            String path = file.getPath();
            if (path.endsWith(".uncompress")) continue;
            if (file.isDirectory()) {
                count += this.doDirectory(path, alwaysUncompress, max, suffix);
            } else if (path.endsWith(suffix)) {
                this.testAllMethods(path);
                ++count;
            }
            if (count > max) break;
        }
        return count;
    }

    private void testAllMethods(String location) throws IOException {
        RadialDatasetSweep rds = (RadialDatasetSweep)TypedDatasetFactory.open((FeatureType)FeatureType.RADIAL, (String)location, null, (StringBuilder)new StringBuilder());
        System.out.println(location + "-----------");
        if (this.show) {
            System.out.println(rds.getDetailInfo());
        }
        Date d1 = rds.getStartDate();
        Date d2 = rds.getEndDate();
        if (d1 != null && d2 != null) assert (d1.before(d2) || d1.equals(d2));
        EarthLocation eloc = rds.getCommonOrigin();
        assert (eloc != null);
        LatLonPointImpl llp = new LatLonPointImpl(eloc.getLatitude(), eloc.getLongitude());
        LatLonRect bb = rds.getBoundingBox();
        assert (bb.contains((LatLonPoint)llp));
        List rvars = rds.getDataVariables();
        assert (null != rvars);
        assert (0 < rvars.size());
        for (int i = 0; i < rvars.size(); ++i) {
            RadialDatasetSweep.RadialVariable rv = (RadialDatasetSweep.RadialVariable)rvars.get(i);
            this.testRadialVariable(rv);
        }
    }

    private void testRadialVariable(RadialDatasetSweep.RadialVariable rv) throws IOException {
        System.out.println(" radial variable = " + rv.getName());
        int nsweeps = rv.getNumSweeps();
        for (int i = 0; i < nsweeps; ++i) {
            RadialDatasetSweep.Sweep sweep = rv.getSweep(i);
            this.testSweep(sweep);
        }
    }

    private void testSweep(RadialDatasetSweep.Sweep s) throws IOException {
        if (this.show) {
            System.out.println("  sweep type= " + s.getType() + " nRadials= " + s.getRadialNumber() + " nGates= " + s.getGateNumber() + " width= " + s.getBeamWidth() + " nyqFreq= " + s.getNyquistFrequency() + " firstGate= " + s.getRangeToFirstGate() + " sizeGate= " + s.getGateSize() + " meanElev= " + s.getMeanElevation() + " meanAzi= " + s.getMeanAzimuth() + " startingTime= " + s.getStartingTime() + " endingTime= " + s.getEndingTime());
        }
        long start = System.currentTimeMillis();
        int nrays = s.getRadialNumber();
        int ngates = s.getGateNumber();
        float[] data = s.readData();
        assert (data != null);
        assert (data.length == nrays * ngates);
        nrays = s.getRadialNumber();
        ngates = s.getGateNumber();
        assert (data.length == nrays * ngates);
        data = s.readData();
        assert (data != null);
        assert (data.length == nrays * ngates);
        if (this.doQuick) {
            return;
        }
        long took = System.currentTimeMillis();
        if (this.showTime) {
            System.out.println(" read()=" + (took - start));
        }
        for (int ray = 0; ray < nrays; ++ray) {
            float[] ray_data = s.readData(ray);
            assert (ray_data != null);
            assert (ray_data.length == ngates);
        }
        long took2 = System.currentTimeMillis();
        if (this.showTime) {
            System.out.println(" read(ray)=" + (took2 - took));
        }
        double result = 0.0;
        for (int ray = 0; ray < nrays; ++ray) {
            double elev = s.getElevation(ray);
            double azi = s.getAzimuth(ray);
            double t = s.getTime(ray);
            result += elev * azi * t;
        }
        long took3 = System.currentTimeMillis();
        if (this.showTime) {
            System.out.println(" getCoord(ray)=" + (took3 - took2) + " msecs (" + result + ")");
        }
    }
}

