/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.trajectory;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.DataType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dt.TrajectoryObsDataset;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.dt.trajectory.Float10TrajectoryObsDataset;
import ucar.nc2.dt.trajectory.TestTrajectoryObsDataset;
import ucar.unidata.geoloc.LatLonRect;

public class TestFloat10TrajectoryObsDataset
extends TestCase {
    private TrajectoryObsDataset me;
    private String testFilePath = TestTrajectoryObsDataset.getRemoteTestDataDir() + "/trajectory/buoy";
    private String testDataFileName = "testfloat10.nc";

    public TestFloat10TrajectoryObsDataset(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testStuff() throws IOException {
        String location = this.testFilePath + "/" + this.testDataFileName;
        TestFloat10TrajectoryObsDataset.assertTrue((String)("Test file <" + location + "> does not exist."), (boolean)new File(location).exists());
        try {
            StringBuilder errlog = new StringBuilder();
            this.me = (TrajectoryObsDataset)TypedDatasetFactory.open((FeatureType)FeatureType.TRAJECTORY, (String)location, null, (StringBuilder)errlog);
        }
        catch (IOException e) {
            String tmpMsg = "Couldn't create TrajectoryObsDataset from UW KingAir aircraft file <" + location + ">: " + e.getMessage();
            TestFloat10TrajectoryObsDataset.assertTrue((String)tmpMsg, (boolean)false);
        }
        TestFloat10TrajectoryObsDataset.assertTrue((String)("Null TrajectoryObsDataset after open <" + location + "> "), (this.me != null ? 1 : 0) != 0);
        TestFloat10TrajectoryObsDataset.assertTrue((String)("Dataset <" + location + "> not a Float10TrajectoryObsDataset."), (boolean)(this.me instanceof Float10TrajectoryObsDataset));
        String dsTitle = null;
        String dsDescrip = null;
        long dsStartDateLong = 994773600000L;
        long dsEndDateLong = 999086400000L;
        LatLonRect dsBoundBox = null;
        int dsNumGlobalAtts = 1;
        String exampleGlobalAttName = "history";
        String exampleGlobalAttVal = "FERRET V5.51    3-Jan-05";
        int dsNumVars = 2;
        String exampleVarName = "SALT";
        String exampleVarDescription = "salinity";
        String exampleVarUnitsString = "PSU";
        int exampleVarRank = 0;
        int[] exampleVarShape = new int[]{};
        String exampleVarDataType = DataType.FLOAT.toString();
        int exampleVarNumAtts = 5;
        int numTrajs = 11;
        String exampleTrajId = "100.0";
        String exampleTrajDesc = null;
        int exampleTrajNumPoints = 1199;
        float exampleTrajStartLat = 56.340836f;
        float exampleTrajEndLat = 56.201443f;
        float exampleTrajStartLon = -153.74309f;
        float exampleTrajEndLon = -154.45656f;
        float exampleTrajStartElev = -0.5914971f;
        float exampleTrajEndElev = -0.8297999f;
        TestTrajectoryObsDataset.TrajDatasetInfo trajDsInfo = new TestTrajectoryObsDataset.TrajDatasetInfo(dsTitle, dsDescrip, location, dsStartDateLong, dsEndDateLong, dsBoundBox, dsNumGlobalAtts, exampleGlobalAttName, exampleGlobalAttVal, dsNumVars, exampleVarName, exampleVarDescription, exampleVarUnitsString, exampleVarRank, exampleVarShape, exampleVarDataType, exampleVarNumAtts, new Float(32.614796f), new Float(32.00046f), numTrajs, exampleTrajId, exampleTrajDesc, exampleTrajNumPoints, exampleTrajStartLat, exampleTrajEndLat, exampleTrajStartLon, exampleTrajEndLon, exampleTrajStartElev, exampleTrajEndElev);
        TestTrajectoryObsDataset.testTrajInfo(this.me, trajDsInfo);
    }
}

