/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.trajectory;

import java.io.IOException;
import java.util.Date;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dt.TrajectoryObsDataset;
import ucar.nc2.dt.TrajectoryObsDatatype;
import ucar.nc2.dt.TypedDatasetFactory;

public class TestRealTimeUpdate
extends TestCase {
    private String testDataFileOut = "test.TrajectoryRealTimeUpdate.tmp.nc";

    public TestRealTimeUpdate(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testMuckWithNcfSynchExtend() {
        Dimension timeDim2;
        boolean extended;
        NetcdfFile ncf = null;
        try {
            ncf = NetcdfFile.open((String)this.testDataFileOut);
        }
        catch (IOException e) {
            TestRealTimeUpdate.assertTrue((String)("Couldn't open file <" + this.testDataFileOut + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        Dimension timeDim = ncf.getRootGroup().findDimension("time");
        int timeDimSize = timeDim.getLength();
        Variable timeVar = ncf.getRootGroup().findVariable("time");
        Variable latVar = ncf.getRootGroup().findVariable("latitude");
        Variable lonVar = ncf.getRootGroup().findVariable("longitude");
        Variable altVar = ncf.getRootGroup().findVariable("altitude");
        Attribute timeUnits = timeVar.findAttribute("units");
        String newUnits = "test unit string";
        System.out.println("Switching time units from \"" + timeUnits.toString() + " \" to \"" + newUnits + "\"");
        timeVar.addAttribute(new Attribute("units", newUnits));
        try {
            Array latArray = latVar.read();
        }
        catch (IOException e) {
            TestRealTimeUpdate.assertTrue((String)("Couldn't read latitude data: " + e.getMessage()), (boolean)false);
            return;
        }
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        try {
            extended = ncf.syncExtend();
        }
        catch (IOException e) {
            TestRealTimeUpdate.assertTrue((String)("Couldn't syncExtend() file <" + this.testDataFileOut + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        if (!extended) {
            System.out.println("Did not extend file <" + this.testDataFileOut + ">.");
        }
        if (timeDim == (timeDim2 = ncf.getRootGroup().findDimension("time"))) {
            System.out.println("Time dimension the same.");
        } else {
            System.out.println("Time dimension not the same.");
        }
        System.out.println("Initial time dim size = " + timeDimSize);
        System.out.println("New time dim size = " + timeDim2.getLength());
        System.out.println("New time dim size (1) = " + timeDim.getLength());
        System.out.println("Time var units string: " + timeVar.findAttribute("units").toString());
        if (latVar == ncf.getRootGroup().findVariable("latitude")) {
            System.out.println("Lat var the same.");
        } else {
            System.out.println("Lat var not the same.");
        }
    }

    public void testTwo() {
        Array presArray;
        Date trajEndDate;
        TrajectoryObsDataset trajDs;
        try {
            StringBuilder errlog = new StringBuilder();
            trajDs = (TrajectoryObsDataset)TypedDatasetFactory.open((FeatureType)FeatureType.TRAJECTORY, (String)this.testDataFileOut, null, (StringBuilder)errlog);
        }
        catch (IOException e) {
            TestRealTimeUpdate.assertTrue((String)("Couldn't open TrajectoryObsDataset <" + this.testDataFileOut + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        Date startDate = trajDs.getStartDate();
        Date endDate = trajDs.getEndDate();
        System.out.println("Dataset start date=" + startDate);
        System.out.println("Dataset end date  =" + endDate);
        TrajectoryObsDatatype traj = trajDs.getTrajectory("trajectory data");
        try {
            trajEndDate = traj.getTime(traj.getNumberPoints() - 1);
            presArray = traj.getData(traj.getNumberPoints() - 1, "HADS_A");
        }
        catch (IOException e) {
            TestRealTimeUpdate.assertTrue((String)("Failed to read last time or pressure from <" + this.testDataFileOut + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        System.out.println("Traj end date  =" + trajEndDate);
        System.out.println("Pressure end value=" + presArray.getFloat(presArray.getIndex()));
        try {
            Thread.sleep(10000L);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!trajDs.syncExtend()) {
            System.out.println("File not extended.");
        } else {
            System.out.println("File extended");
        }
        startDate = trajDs.getStartDate();
        endDate = trajDs.getEndDate();
        System.out.println("Start date=" + startDate);
        System.out.println("End date  =" + endDate);
        try {
            trajEndDate = traj.getTime(traj.getNumberPoints() - 1);
            presArray = traj.getData(traj.getNumberPoints() - 1, "HADS_A");
        }
        catch (IOException e) {
            TestRealTimeUpdate.assertTrue((String)("Failed to read last time or pressure from <" + this.testDataFileOut + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        System.out.println("Traj end date  =" + trajEndDate);
        System.out.println("Pressure end value=" + presArray.getFloat(presArray.getIndex()));
    }
}

