/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.trajectory;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.DataType;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dt.TrajectoryObsDataset;
import ucar.nc2.dt.TypedDatasetFactory;
import ucar.nc2.dt.trajectory.SimpleTrajectoryObsDataset;
import ucar.nc2.dt.trajectory.TestTrajectoryObsDataset;

public class TestSimpleTrajectoryObsDataset
extends TestCase {
    private TrajectoryObsDataset me;
    private String testFilePath = TestTrajectoryObsDataset.getTestDataDir() + "/trajectory/aircraft";
    private String testDataFileName = "uw_kingair-2005-01-19-113957.nc";
    private String test_WMI_Lear_FileName = "WMI_Lear-2003-05-28-212817.nc";

    public TestSimpleTrajectoryObsDataset(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testSimple_UW_KingAir() throws IOException {
        String location = this.testFilePath + "/" + this.testDataFileName;
        TestSimpleTrajectoryObsDataset.assertTrue((String)("Test file <" + location + "> does not exist."), (boolean)new File(location).exists());
        try {
            StringBuilder errlog = new StringBuilder();
            this.me = (TrajectoryObsDataset)TypedDatasetFactory.open((FeatureType)FeatureType.TRAJECTORY, (String)location, null, (StringBuilder)errlog);
        }
        catch (IOException e) {
            String tmpMsg = "Couldn't create TrajectoryObsDataset from UW KingAir aircraft file <" + location + ">: " + e.getMessage();
            TestSimpleTrajectoryObsDataset.assertTrue((String)tmpMsg, (boolean)false);
        }
        TestSimpleTrajectoryObsDataset.assertTrue((String)("Null TrajectoryObsDataset after open <" + location + "> "), (this.me != null ? 1 : 0) != 0);
        TestSimpleTrajectoryObsDataset.assertTrue((String)("Dataset <" + location + "> not a SimpleTrajectoryObsDataset."), (boolean)(this.me instanceof SimpleTrajectoryObsDataset));
        long startDateLong = 1106134797000L;
        long endDateLong = 1106149487000L;
        float expStartLat = 17.1405f;
        float expEndLat = 17.1403f;
        float expStartLon = -61.7774f;
        float expEndLon = -61.7791f;
        float expStartElev = 17.0f;
        float expEndElev = 13.0f;
        Float exampleVarStartVal = new Float(13.1f);
        Float exampleVarEndVal = new Float(11.4f);
        TestTrajectoryObsDataset.TrajDatasetInfo trajDsInfo = new TestTrajectoryObsDataset.TrajDatasetInfo(null, null, location, startDateLong, endDateLong, null, 1, "history", "TrackFile.java,v 1.19 2002/05/24 16:30:34 martin Exp", 15, "HWSPD", "wind speed", "m/s", 0, new int[0], DataType.FLOAT.toString(), 4, exampleVarStartVal, exampleVarEndVal, 1, "trajectory data", null, 545, expStartLat, expEndLat, expStartLon, expEndLon, expStartElev, expEndElev);
        TestTrajectoryObsDataset.testTrajInfo(this.me, trajDsInfo);
    }

    public void testSimple_WMI_Lear() throws IOException {
        String location = this.testFilePath + "/" + this.test_WMI_Lear_FileName;
        TestSimpleTrajectoryObsDataset.assertTrue((String)("Test file <" + location + "> does not exist."), (boolean)new File(location).exists());
        try {
            StringBuilder errlog = new StringBuilder();
            this.me = (TrajectoryObsDataset)TypedDatasetFactory.open((FeatureType)FeatureType.TRAJECTORY, (String)location, null, (StringBuilder)errlog);
        }
        catch (IOException e) {
            String tmpMsg = "Couldn't create TrajectoryObsDataset from UW KingAir aircraft file <" + location + ">: " + e.getMessage();
            TestSimpleTrajectoryObsDataset.assertTrue((String)tmpMsg, (boolean)false);
        }
        TestSimpleTrajectoryObsDataset.assertTrue((String)("Null TrajectoryObsDataset after open <" + location + "> "), (this.me != null ? 1 : 0) != 0);
        TestSimpleTrajectoryObsDataset.assertTrue((String)("Dataset <" + location + "> not a SimpleTrajectoryObsDataset."), (boolean)(this.me instanceof SimpleTrajectoryObsDataset));
        long startDateLong = 1054157297000L;
        long endDateLong = 1054159198000L;
        float expStartLat = 38.5473f;
        float expEndLat = 38.398f;
        float expStartLon = -89.8163f;
        float expEndLon = -88.6898f;
        float expStartElev = 89.9f;
        float expEndElev = 7998.0f;
        Float exampleVarStartVal = new Float(29.0f);
        Float exampleVarEndVal = new Float(-28.2f);
        TestTrajectoryObsDataset.TrajDatasetInfo trajDsInfo = new TestTrajectoryObsDataset.TrajDatasetInfo(null, null, location, startDateLong, endDateLong, null, 1, "history", "TrackFile.java,v 1.20 2003/05/07 04:53:23 maclean", 7, "tdry", "temperature", "deg_C", 0, new int[0], DataType.FLOAT.toString(), 5, exampleVarStartVal, exampleVarEndVal, 1, "trajectory data", null, 588, expStartLat, expEndLat, expStartLon, expEndLon, expStartElev, expEndElev);
        TestTrajectoryObsDataset.testTrajInfo(this.me, trajDsInfo);
    }
}

