/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft;

import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.NestedPointFeatureCollection;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.LatLonRect;
import visad.DateTime;

public class TestPointCDM {
    public static void main(String[] args) throws Exception {
        String file = "C:/data/ft/station/09052812.sf";
        Formatter buf = new Formatter();
        FeatureDatasetPoint pods = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open((FeatureType)FeatureType.POINT, (String)file, null, (Formatter)buf);
        if (pods == null) {
            pods = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open((FeatureType)FeatureType.ANY_POINT, (String)file, null, (Formatter)buf);
        }
        if (pods == null) {
            throw new Exception("can't open file");
        }
        List collectionList = pods.getPointFeatureCollectionList();
        if (collectionList.size() > 1) {
            throw new IllegalArgumentException("Can't handle point data with multiple collections");
        }
        boolean sample = true;
        for (int time = 0; time < 2; ++time) {
            sample = time < 1;
            FeatureCollection fc = (FeatureCollection)collectionList.get(0);
            PointFeatureCollection collection = null;
            LatLonRect llr = null;
            System.out.println("llr = " + llr);
            if (fc instanceof PointFeatureCollection) {
                collection = (PointFeatureCollection)fc;
                if (llr != null) {
                    collection = collection.subset(llr, null);
                }
            } else if (fc instanceof NestedPointFeatureCollection) {
                NestedPointFeatureCollection npfc = (NestedPointFeatureCollection)fc;
                if (llr != null) {
                    npfc = npfc.subset(llr);
                }
                collection = npfc.flatten(llr, null);
            } else {
                throw new IllegalArgumentException("Can't handle collection of type " + fc.getClass().getName());
            }
            ArrayList<PointFeature> pos = new ArrayList<PointFeature>(100000);
            ArrayList<DateTime> times = new ArrayList<DateTime>(100000);
            PointFeatureIterator dataIterator = collection.getPointFeatureIterator(16384);
            while (dataIterator.hasNext()) {
                PointFeature po = dataIterator.next();
                pos.add(po);
                times.add(new DateTime(po.getNominalTimeAsDate()));
                System.out.println("po = " + po);
                if (!sample) continue;
                break;
            }
            int size = pos.size();
            for (int i = 0; i < size; ++i) {
                PointFeature po = (PointFeature)pos.get(i);
                EarthLocation el = po.getLocation();
                System.out.println("el = " + el);
            }
        }
    }
}

