/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Formatter;
import junit.framework.TestCase;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.dt.GridDataset;
import ucar.nc2.dt.RadialDatasetSweep;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.NestedPointFeatureCollection;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.ProfileFeatureCollection;
import ucar.nc2.ft.SectionFeatureCollection;
import ucar.nc2.ft.StationProfileFeatureCollection;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.TrajectoryFeatureCollection;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.TimeDuration;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonRect;

public class TestPointFeatureSubset
extends TestCase {
    public TestPointFeatureSubset(String name) {
        super(name);
    }

    public void utestProblem() throws IOException {
        this.testFeatureDataset("D:/work/arnaud/sampleDataset.nc", FeatureType.ANY_POINT, true);
    }

    public void utestCdmRemote() throws IOException {
        this.testFeatureDataset("cdmremote:http://motherlode.ucar.edu:9080/thredds/cdmremote/idd/metar/gempak", FeatureType.STATION, true);
    }

    int readAllDir(String dirName, FileFilter ff, FeatureType type) throws IOException {
        int count = 0;
        System.out.println("---------------Reading directory " + dirName);
        File allDir = new File(dirName);
        File[] allFiles = allDir.listFiles();
        if (null == allFiles) {
            System.out.println("---------------INVALID " + dirName);
            return count;
        }
        for (File f : allFiles) {
            String name = f.getAbsolutePath();
            if (f.isDirectory() || ff != null && !ff.accept(f) || name.endsWith(".exclude")) continue;
            try {
                this.testFeatureDataset(name, type, false);
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
            ++count;
        }
        for (File f : allFiles) {
            if (!f.isDirectory() || f.getName().equals("exclude")) continue;
            count += this.readAllDir(f.getAbsolutePath(), ff, type);
        }
        return count;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testFeatureDataset(String location, FeatureType wantType, boolean show) throws IOException {
        System.out.printf("----------- Read %s %n", location);
        long start = System.currentTimeMillis();
        FeatureDataset fdataset = null;
        try {
            Formatter out = new Formatter();
            fdataset = FeatureDatasetFactoryManager.open((FeatureType)wantType, (String)location, null, (Formatter)out);
            if (fdataset == null) {
                System.out.printf("**failed on %s %n --> %s %n", location, out);
                return;
            }
            FeatureType ftype = fdataset.getFeatureType();
            assert (FeatureDatasetFactoryManager.featureTypeOk((FeatureType)wantType, (FeatureType)ftype));
            if (ftype == FeatureType.GRID) {
                assert (fdataset instanceof GridDataset);
                GridDataset griddedDataset = (GridDataset)fdataset;
            } else if (ftype == FeatureType.RADIAL) {
                assert (fdataset instanceof RadialDatasetSweep);
                RadialDatasetSweep radialDataset = (RadialDatasetSweep)fdataset;
            } else if (ftype.isPointFeatureType()) {
                assert (fdataset instanceof FeatureDatasetPoint);
                FeatureDatasetPoint pointDataset = (FeatureDatasetPoint)fdataset;
                this.testPointFeatureDataset(pointDataset);
            }
        }
        finally {
            if (fdataset != null) {
                fdataset.close();
            }
        }
        long took = System.currentTimeMillis() - start;
        System.out.println(" took= " + took + " msec");
    }

    void testPointFeatureDataset(FeatureDatasetPoint fdpoint) throws IOException {
        FeatureType ftype = fdpoint.getFeatureType();
        for (FeatureCollection fc : fdpoint.getPointFeatureCollectionList()) {
            assert (ftype == fc.getCollectionFeatureType());
            this.donsTest(fc);
            if (ftype == FeatureType.POINT) {
                assert (fc instanceof PointFeatureCollection);
                this.testPointSubset((FeatureDataset)fdpoint, (PointFeatureCollection)fc);
                continue;
            }
            if (ftype == FeatureType.STATION) {
                assert (fc instanceof StationTimeSeriesFeatureCollection);
                StationTimeSeriesFeatureCollection sc = (StationTimeSeriesFeatureCollection)fc;
                System.out.printf("StationTimeSeriesFeatureCollection size=%d%n", this.count(sc));
                LatLonRect bbsubset = this.getHalfBB((NestedPointFeatureCollection)sc);
                StationTimeSeriesFeatureCollection subset = sc.subset(bbsubset);
                System.out.printf(" subset size=%d%n", this.count(subset));
                continue;
            }
            if (ftype == FeatureType.PROFILE ? !$assertionsDisabled && !(fc instanceof ProfileFeatureCollection) : (ftype == FeatureType.STATION_PROFILE ? !$assertionsDisabled && !(fc instanceof StationProfileFeatureCollection) : (ftype == FeatureType.TRAJECTORY ? !$assertionsDisabled && !(fc instanceof TrajectoryFeatureCollection) : ftype == FeatureType.SECTION && !$assertionsDisabled && !(fc instanceof SectionFeatureCollection)))) {
                throw new AssertionError();
            }
        }
    }

    int count(StationTimeSeriesFeatureCollection pfc) throws IOException {
        if (pfc.size() > 0) {
            return pfc.size();
        }
        int count = 0;
        while (pfc.hasNext()) {
            pfc.next();
            ++count;
        }
        return count;
    }

    private void testPointSubset(FeatureDataset fd, PointFeatureCollection fc) {
        DateRange dr = this.makeTimeSubset(fd);
    }

    DateRange makeTimeSubset(FeatureDataset fd) {
        DateRange dr = fd.getDateRange();
        System.out.printf(" original date range=%s %n", dr);
        if (dr == null) {
            return null;
        }
        TimeDuration td = dr.getDuration();
        double secs = td.getValueInSeconds();
        td.setValueInSeconds(secs / 4.0);
        DateType start = dr.getStart();
        start.add(td);
        td.setValueInSeconds(secs / 2.0);
        DateRange result = new DateRange(start, null, td, null);
        System.out.printf(" subset date range=%s %n", result);
        return result;
    }

    private void donsTest(FeatureCollection fc) throws IOException {
        PointFeatureCollection subsetPfc = null;
        if (fc instanceof PointFeatureCollection) {
            System.out.print("Don test on PointFeatureCollection: ");
            subsetPfc = (PointFeatureCollection)fc;
            subsetPfc = subsetPfc.subset(this.getHalfBB(subsetPfc), null);
        } else if (fc instanceof NestedPointFeatureCollection) {
            System.out.print("Don test on NestedPointFeatureCollection: ");
            NestedPointFeatureCollection npfc = (NestedPointFeatureCollection)fc;
            NestedPointFeatureCollection subset = npfc.subset(this.getHalfBB(npfc));
            subsetPfc = subset.flatten(null, null);
        }
        int total = subsetPfc.size();
        int count = 0;
        PointFeatureIterator dataIterator = subsetPfc.getPointFeatureIterator(16384);
        while (dataIterator.hasNext()) {
            PointFeature po = dataIterator.next();
            ++count;
        }
        System.out.printf("count= %d%n", count);
    }

    private LatLonRect getHalfBB(PointFeatureCollection fc) {
        LatLonRect bb = fc.getBoundingBox();
        return new LatLonRect((LatLonPoint)bb.getLowerLeftPoint(), bb.getHeight() / 2.0, bb.getWidth() / 2.0);
    }

    private LatLonRect getHalfBB(NestedPointFeatureCollection fc) {
        LatLonRect bb = new LatLonRect();
        if (fc instanceof StationTimeSeriesFeatureCollection) {
            bb = ((StationTimeSeriesFeatureCollection)fc).getBoundingBox();
        }
        return new LatLonRect((LatLonPoint)bb.getLowerLeftPoint(), bb.getHeight() / 2.0, bb.getWidth() / 2.0);
    }
}

