/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.ft;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import ucar.ma2.DataType;
import ucar.ma2.StructureData;
import ucar.ma2.StructureMembers;
import ucar.nc2.NCdumpW;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.constants.FeatureType;
import ucar.nc2.ft.FeatureCollection;
import ucar.nc2.ft.FeatureDataset;
import ucar.nc2.ft.FeatureDatasetFactoryManager;
import ucar.nc2.ft.FeatureDatasetPoint;
import ucar.nc2.ft.NestedPointFeatureCollection;
import ucar.nc2.ft.PointFeature;
import ucar.nc2.ft.PointFeatureCollection;
import ucar.nc2.ft.PointFeatureCollectionIterator;
import ucar.nc2.ft.PointFeatureIterator;
import ucar.nc2.ft.ProfileFeature;
import ucar.nc2.ft.ProfileFeatureCollection;
import ucar.nc2.ft.SectionFeature;
import ucar.nc2.ft.SectionFeatureCollection;
import ucar.nc2.ft.StationProfileFeature;
import ucar.nc2.ft.StationProfileFeatureCollection;
import ucar.nc2.ft.StationTimeSeriesFeature;
import ucar.nc2.ft.StationTimeSeriesFeatureCollection;
import ucar.nc2.ft.TrajectoryFeature;
import ucar.nc2.ft.TrajectoryFeatureCollection;
import ucar.nc2.units.DateFormatter;
import ucar.nc2.units.DateRange;
import ucar.nc2.units.DateType;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.TimeDuration;
import ucar.nc2.util.DebugFlags;
import ucar.nc2.util.DebugFlagsImpl;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;
import ucar.unidata.geoloc.Station;
import ucar.unidata.io.RandomAccessFile;

public class TestPointFeatureTypes
extends TestCase {
    private static String topdir = TestAll.testdataDir + "cdmUnitTest/";
    private static boolean showStructureData = false;
    String CFpointObs_topdir = TestAll.cdmLocalTestDataDir + "point/";

    public TestPointFeatureTypes(String name) {
        super(name);
    }

    public void testAll() throws IOException {
        this.scanDir(topdir + "cfPoint/", new MyFileFilter());
    }

    private void scanDir(String dir, FileFilter ff) throws IOException {
        TestAll.actOnAll(dir, ff, new TestAll.Act(){

            @Override
            public int doAct(String filename) throws IOException {
                TestPointFeatureTypes.this.checkPointDataset(filename, FeatureType.ANY_POINT, true);
                return 1;
            }
        });
    }

    public void testCFcanonical() throws IOException {
        assert (3 == this.checkPointDataset(this.CFpointObs_topdir + "point.ncml", FeatureType.POINT, false));
        assert (3 == this.checkPointDataset(this.CFpointObs_topdir + "pointUnlimited.nc", FeatureType.POINT, false));
        assert (4 == this.checkPointDataset(this.CFpointObs_topdir + "pointMissing.ncml", FeatureType.POINT, false));
        assert (3 == this.checkPointDataset(this.CFpointObs_topdir + "stationSingle.ncml", FeatureType.STATION, false));
        assert (3 == this.checkPointDataset(this.CFpointObs_topdir + "stationSingleWithZlevel.ncml", FeatureType.STATION, false));
        assert (15 == this.checkPointDataset(this.CFpointObs_topdir + "stationMultidim.ncml", FeatureType.STATION, false));
        assert (15 == this.checkPointDataset(this.CFpointObs_topdir + "stationMultidimTimeJoin.ncml", FeatureType.STATION, false));
        assert (15 == this.checkPointDataset(this.CFpointObs_topdir + "stationMultidimUnlimited.nc", FeatureType.STATION, false));
        assert (12 == this.checkPointDataset(this.CFpointObs_topdir + "stationMultidimMissingTime.ncml", FeatureType.STATION, false));
        assert (9 == this.checkPointDataset(this.CFpointObs_topdir + "stationMultidimMissingId.ncml", FeatureType.STATION, true));
        assert (12 == this.checkPointDataset(this.CFpointObs_topdir + "stationMultidimMissingIdString.ncml", FeatureType.STATION, true));
        assert (6 == this.checkPointDataset(this.CFpointObs_topdir + "stationRaggedContig.ncml", FeatureType.STATION, false));
        assert (6 == this.checkPointDataset(this.CFpointObs_topdir + "stationRaggedIndex.ncml", FeatureType.STATION, false));
        assert (5 == this.checkPointDataset(this.CFpointObs_topdir + "stationRaggedMissing.ncml", FeatureType.STATION, false));
        assert (13 == this.checkPointDataset(this.CFpointObs_topdir + "stationFlat.ncml", FeatureType.STATION, false));
        assert (13 == this.checkPointDataset(this.CFpointObs_topdir + "stationFlat.nc", FeatureType.STATION, false));
        assert (10 == this.checkPointDataset(this.CFpointObs_topdir + "trajSingle.ncml", FeatureType.TRAJECTORY, false));
        assert (20 == this.checkPointDataset(this.CFpointObs_topdir + "trajMultidim.ncml", FeatureType.TRAJECTORY, false));
        assert (30 == this.checkPointDataset(this.CFpointObs_topdir + "trajMultidimMissingId.ncml", FeatureType.TRAJECTORY, false));
        assert (18 == this.checkPointDataset(this.CFpointObs_topdir + "trajMultidimMissingTime.ncml", FeatureType.TRAJECTORY, false));
        assert (6 == this.checkPointDataset(this.CFpointObs_topdir + "trajRaggedContig.ncml", FeatureType.TRAJECTORY, false));
        assert (6 == this.checkPointDataset(this.CFpointObs_topdir + "trajRaggedIndex.ncml", FeatureType.TRAJECTORY, false));
        assert (5 == this.checkPointDataset(this.CFpointObs_topdir + "trajRaggedMissing.ncml", FeatureType.TRAJECTORY, false));
        assert (13 == this.checkPointDataset(this.CFpointObs_topdir + "profileSingle.ncml", FeatureType.PROFILE, false));
        assert (12 == this.checkPointDataset(this.CFpointObs_topdir + "profileSingleTimeJoin.ncml", FeatureType.PROFILE, false));
        assert (50 == this.checkPointDataset(this.CFpointObs_topdir + "profileMultidim.ncml", FeatureType.PROFILE, false));
        assert (50 == this.checkPointDataset(this.CFpointObs_topdir + "profileMultidimTimeJoin.ncml", FeatureType.PROFILE, false));
        assert (50 == this.checkPointDataset(this.CFpointObs_topdir + "profileMultidimZJoin.ncml", FeatureType.PROFILE, false));
        assert (50 == this.checkPointDataset(this.CFpointObs_topdir + "profileMultidimTimeZJoin.ncml", FeatureType.PROFILE, false));
        assert (40 == this.checkPointDataset(this.CFpointObs_topdir + "profileMultidimMissingId.ncml", FeatureType.PROFILE, false));
        assert (14 == this.checkPointDataset(this.CFpointObs_topdir + "profileMultidimMissingAlt.ncml", FeatureType.PROFILE, false));
        assert (6 == this.checkPointDataset(this.CFpointObs_topdir + "profileRaggedContig.ncml", FeatureType.PROFILE, false));
        assert (6 == this.checkPointDataset(this.CFpointObs_topdir + "profileRaggedContigTimeJoin.ncml", FeatureType.PROFILE, false));
        assert (22 == this.checkPointDataset(this.CFpointObs_topdir + "profileRaggedIndex.ncml", FeatureType.PROFILE, false));
        assert (22 == this.checkPointDataset(this.CFpointObs_topdir + "profileRaggedIndexTimeJoin.ncml", FeatureType.PROFILE, false));
        assert (9 == this.checkPointDataset(this.CFpointObs_topdir + "stationProfileSingle.ncml", FeatureType.STATION_PROFILE, false));
        assert (9 == this.checkPointDataset(this.CFpointObs_topdir + "stationProfileSingleTimeJoin.ncml", FeatureType.STATION_PROFILE, false));
        assert (18 == this.checkPointDataset(this.CFpointObs_topdir + "stationProfileMultidim.ncml", FeatureType.STATION_PROFILE, false));
        assert (18 == this.checkPointDataset(this.CFpointObs_topdir + "stationProfileMultidimUnlimited.nc", FeatureType.STATION_PROFILE, false));
        assert (24 == this.checkPointDataset(this.CFpointObs_topdir + "stationProfileMultidimJoinZ.ncml", FeatureType.STATION_PROFILE, false));
        assert (18 == this.checkPointDataset(this.CFpointObs_topdir + "stationProfileMultidimJoinTime.ncml", FeatureType.STATION_PROFILE, false));
        assert (36 == this.checkPointDataset(this.CFpointObs_topdir + "stationProfileMultidimJoinTimeAndZ.ncml", FeatureType.STATION_PROFILE, false));
        assert (27 == this.checkPointDataset(this.CFpointObs_topdir + "stationProfileMultidimMissingId.ncml", FeatureType.STATION_PROFILE, false));
        assert (27 == this.checkPointDataset(this.CFpointObs_topdir + "stationProfileMultidimMissingIdString.ncml", FeatureType.STATION_PROFILE, true));
        assert (16 == this.checkPointDataset(this.CFpointObs_topdir + "stationProfileMultidimMissingTime.ncml", FeatureType.STATION_PROFILE, true));
        assert (15 == this.checkPointDataset(this.CFpointObs_topdir + "stationProfileMultidimMissingAlt.ncml", FeatureType.STATION_PROFILE, true));
        assert (14 == this.checkPointDataset(this.CFpointObs_topdir + "stationProfileRagged.ncml", FeatureType.STATION_PROFILE, false));
        assert (14 == this.checkPointDataset(this.CFpointObs_topdir + "stationProfileRaggedJoinTime.ncml", FeatureType.STATION_PROFILE, false));
        assert (100 == this.checkPointDataset(this.CFpointObs_topdir + "sectionMultidim.ncml", FeatureType.SECTION, false));
        assert (100 == this.checkPointDataset(this.CFpointObs_topdir + "sectionMultidimJoinZ.ncml", FeatureType.SECTION, false));
        assert (100 == this.checkPointDataset(this.CFpointObs_topdir + "sectionMultidimMissingId.ncml", FeatureType.SECTION, false));
        assert (100 == this.checkPointDataset(this.CFpointObs_topdir + "sectionMultidimMissingIdString.ncml", FeatureType.SECTION, false));
        assert (28 == this.checkPointDataset(this.CFpointObs_topdir + "sectionMultidimMissingTime.ncml", FeatureType.SECTION, false));
        assert (18 == this.checkPointDataset(this.CFpointObs_topdir + "sectionMultidimMissingAlt.ncml", FeatureType.SECTION, false));
        assert (50 == this.checkPointDataset(this.CFpointObs_topdir + "sectionSingle.ncml", FeatureType.SECTION, false));
        assert (12 == this.checkPointDataset(this.CFpointObs_topdir + "sectionRagged.ncml", FeatureType.SECTION, false));
    }

    public void testProblem() throws IOException {
        assert (1516 == this.checkPointDataset(topdir + "ft/point/Surface_Synoptic_20090921_0000.nc", FeatureType.POINT, false));
    }

    public void testCF() throws IOException {
        assert (1001 == this.checkPointDataset(topdir + "cfPoint/point/filtered_apriori_super_calibrated_binned1.nc", FeatureType.POINT, true));
        assert (1196 == this.checkPointDataset(topdir + "cfPoint/point/nmcbob.shp.nc", FeatureType.POINT, true));
        assert (17280 == this.checkPointDataset(topdir + "cfPoint/station/rig_tower.2009-02-01.ncml", FeatureType.STATION, true));
        assert (78912 == this.checkPointDataset(topdir + "cfPoint/station/billNewDicast.nc", FeatureType.STATION, true));
        assert (19728 == this.checkPointDataset(topdir + "cfPoint/station/billOldDicast.nc", FeatureType.STATION, true));
        assert (1728 == this.checkPointDataset(topdir + "cfPoint/station/sampleDataset.nc", FeatureType.STATION, true));
        assert (53176 == this.checkPointDataset(topdir + "cfPoint/trajectory/rt_20090512_willy2.ncml", FeatureType.TRAJECTORY, true));
        assert (245 == this.checkPointDataset(topdir + "cfPoint/trajectory/p1140004.ncml", FeatureType.TRAJECTORY, true));
    }

    public void testPlug() throws IOException {
        assert (383 == this.checkPointDataset(topdir + "ft/trajectory/cosmic/wetPrf_C005.2007.294.16.22.G17_0001.0002_nc", FeatureType.TRAJECTORY, true));
        assert (1405 == this.checkPointDataset(topdir + "ft/station/nbdc/41001h1976.nc", FeatureType.STATION, false));
        assert (124 == this.checkPointDataset(topdir + "ft/station/suomi/suoHWV_2006.105.00.00.0060_nc", FeatureType.STATION, false));
        assert (4848 == this.checkPointDataset(topdir + "ft/station/suomi/gsuPWV_2006.105.00.00.1440_nc", FeatureType.STATION, false));
        assert (198 == this.checkPointDataset(topdir + "ft/station_profile/PROFILER_RASS_01hr_20091027_1500.nc", FeatureType.STATION_PROFILE, false));
        assert (198 == this.checkPointDataset(topdir + "ft/station_profile/PROFILER_RASS_06min_20091028_2318.nc", FeatureType.STATION_PROFILE, false));
        assert (1728 == this.checkPointDataset(topdir + "ft/station_profile/PROFILER_wind_01hr_20091024_1200.nc", FeatureType.STATION_PROFILE, false));
        assert (2088 == this.checkPointDataset(topdir + "ft/station_profile/PROFILER_wind_06min_20091030_2330.nc", FeatureType.STATION_PROFILE, false));
        assert (8769 == this.checkPointDataset(TestAll.testdataDir + "sounding/gempak/19580807_upa.ncml", FeatureType.STATION_PROFILE, false));
        assert (3337 == this.checkPointDataset(topdir + "ft/point/2009103008_sb.gem", FeatureType.POINT, false));
        assert (938 == this.checkPointDataset(topdir + "ft/point/2009110100_ship.gem", FeatureType.POINT, false));
        assert (55856 == this.checkPointDataset(topdir + "ft/point/20091030_syn.gem", FeatureType.POINT, false));
        assert (28328 == this.checkPointDataset(topdir + "ft/point/20091030_syn.gem", FeatureType.STATION, false));
        assert (7 == this.checkPointDataset(topdir + "ft/point/Surface_METAR_latest.nc", FeatureType.POINT, false));
        assert (32452 == this.checkPointDataset(topdir + "ft/point/Surface_Buoy_20090921_0000.nc", FeatureType.POINT, false));
        assert (1516 == this.checkPointDataset(topdir + "ft/point/Surface_Synoptic_20090921_0000.nc", FeatureType.POINT, false));
        assert (7741 == this.checkPointDataset(topdir + "ft/trajectory/raf/135_ordrd.nc", FeatureType.TRAJECTORY, false));
        assert (8157 == this.checkPointDataset(topdir + "ft/trajectory/raf/raftrack.nc", FeatureType.TRAJECTORY, false));
        assert (5063 == this.checkPointDataset(topdir + "ft/trajectory/acars/acars_20091109_0800.nc", FeatureType.TRAJECTORY, false));
        assert (2499 == this.checkPointDataset(TestAll.testdataDir + "point/netcdf/19981110_1200", FeatureType.POINT, false));
        assert (1374 == this.checkPointDataset(TestAll.testdataDir + "station/madis2/hydro/20050729_1200", FeatureType.STATION, false));
        assert (1788 == this.checkPointDataset(TestAll.testdataDir + "sounding/netcdf/20070612_1200", FeatureType.STATION_PROFILE, false));
        assert (5023 == this.checkPointDataset(TestAll.testdataDir + "point/netcdf/200501q3h-gr.nc", FeatureType.STATION, false));
        assert (277477 == this.checkPointDataset(TestAll.testdataDir + "point/netcdf/20080814_LMA.ncml", FeatureType.POINT, false));
        assert (1165 == this.checkPointDataset(TestAll.testdataDir + "lightning/nldn/200929100.ingest", FeatureType.POINT, false));
        assert (3483 == this.checkPointDataset(TestAll.testdataDir + "lightning/uspln/uspln_20061023.18", FeatureType.POINT, false));
    }

    public void testGempak() throws IOException {
        assert (8769 == this.checkPointDataset(TestAll.testdataDir + "sounding/gempak/19580807_upa.ncml", FeatureType.STATION_PROFILE, false));
        this.checkPointDataset(TestAll.cdmUnitTestDir + "formats/gempak/surface/19580807_sao.gem", FeatureType.STATION, true);
        this.testGempakAll(TestAll.cdmUnitTestDir + "formats/gempak/surface/20090524_sao.gem");
    }

    public void testGempakAll(String filename) throws IOException {
        this.checkPointDataset(filename, FeatureType.ANY_POINT, true);
        this.checkLocation(filename, FeatureType.ANY_POINT, true);
    }

    public void utestGempakProblem() throws Exception {
        NetcdfFile.setDebugFlags((DebugFlags)new DebugFlagsImpl("NetcdfFile/showRequest"));
        this.testDon2("Y:\\ldm\\gempak\\surface/20091023_sao.gem", true);
    }

    public void utestCollectionGempak() throws IOException {
        this.checkPointDataset("collection:D:/formats/gempak/surface/#yyyyMMdd#_sao\\.gem", FeatureType.STATION, true);
    }

    public void utestCollection() throws IOException {
        this.checkPointDataset("collection:C:/data/datasets/metars/Surface_METAR_#yyyyMMdd_HHmm#.nc", FeatureType.STATION, true);
    }

    public void utestCdmRemote() throws IOException {
        this.checkPointDataset("cdmremote:http://localhost:8080/thredds/cdmremote/idd/metar/ncdecodedLocal", FeatureType.STATION, true);
    }

    public void utestCdmRemoteCollection() throws Exception {
        while (true) {
            this.testDon2("cdmremote:http://motherlode.ucar.edu:8081/thredds/cdmremote/idd/metar/gempak", true);
            Thread.sleep(60000L);
        }
    }

    public void utestCdmRemoteCollectionSubsets() throws IOException {
        Formatter f = new Formatter();
        String location = "cdmremote:http://localhost:8080/thredds/cdmremote/idd/metar/gempakLocal";
        FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)FeatureType.STATION, (String)location, null, (Formatter)f);
        assert (fdataset instanceof FeatureDatasetPoint);
        FeatureDatasetPoint fdpoint = (FeatureDatasetPoint)fdataset;
        assert (fdpoint.getPointFeatureCollectionList().size() == 1);
        FeatureCollection fc = (FeatureCollection)fdpoint.getPointFeatureCollectionList().get(0);
        assert (fc instanceof StationTimeSeriesFeatureCollection);
        StationTimeSeriesFeatureCollection stnc = (StationTimeSeriesFeatureCollection)fc;
        Station stn = stnc.getStation("04V");
        assert (stn != null);
        StationTimeSeriesFeature stnFeature = stnc.getStationFeature(stn);
        assert (stnFeature != null);
        stnFeature.calcBounds();
        int n = stnFeature.size();
        System.out.printf(" n=%d from %s ", n, stnFeature);
        this.checkPointFeatureCollection((PointFeatureCollection)stnFeature, true);
        fdataset.close();
    }

    private int checkPointDataset(String location, FeatureType type, boolean show) throws IOException {
        System.out.printf("================ TestPointFeatureCollection read %s %n", location);
        long start = System.currentTimeMillis();
        Formatter out = new Formatter();
        FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)type, (String)location, null, (Formatter)out);
        if (fdataset == null) {
            System.out.printf("**failed on %s %n --> %s %n", location, out);
            assert (false);
        }
        if (show) {
            System.out.printf("----------- testPointDataset getDetailInfo -----------------%n", new Object[0]);
            fdataset.getDetailInfo(out);
            System.out.printf("%s %n", out);
        } else {
            System.out.printf("  Feature Type %s %n", fdataset.getFeatureType());
        }
        Date d1 = fdataset.getStartDate();
        Date d2 = fdataset.getEndDate();
        if (d1 != null && d2 != null) assert (d1.before(d2) || d1.equals(d2));
        List dataVars = fdataset.getDataVariables();
        assert (dataVars != null);
        for (int i = 0; i < dataVars.size(); ++i) {
            VariableSimpleIF v = (VariableSimpleIF)dataVars.get(i);
            assert (null != fdataset.getDataVariable(v.getShortName()));
        }
        assert (fdataset instanceof FeatureDatasetPoint);
        FeatureDatasetPoint fdpoint = (FeatureDatasetPoint)fdataset;
        int count = 0;
        for (FeatureCollection fc : fdpoint.getPointFeatureCollectionList()) {
            assert (fc instanceof PointFeatureCollection || fc instanceof NestedPointFeatureCollection) : fc.getClass().getName();
            if (fc instanceof PointFeatureCollection) {
                PointFeatureCollection pfc = (PointFeatureCollection)fc;
                count = this.checkPointFeatureCollection(pfc, show);
                System.out.println("PointFeatureCollection getData count= " + count + " size= " + pfc.size());
                assert (count == pfc.size());
                continue;
            }
            if (fc instanceof StationTimeSeriesFeatureCollection) {
                count = this.checkStationFeatureCollection((StationTimeSeriesFeatureCollection)fc);
                continue;
            }
            if (fc instanceof StationProfileFeatureCollection) {
                count = this.checkStationProfileFeatureCollection((StationProfileFeatureCollection)fc, show);
                if (!showStructureData) continue;
                this.showStructureData((StationProfileFeatureCollection)fc);
                continue;
            }
            if (fc instanceof SectionFeatureCollection) {
                count = this.checkSectionFeatureCollection((SectionFeatureCollection)fc, show);
                continue;
            }
            if (fc instanceof ProfileFeatureCollection) {
                count = this.checkProfileFeatureCollection((ProfileFeatureCollection)fc, show);
                continue;
            }
            count = this.checkNestedPointFeatureCollection((NestedPointFeatureCollection)fc, show);
        }
        fdataset.close();
        long took = System.currentTimeMillis() - start;
        System.out.printf(" nobs=%d took= %d msec%n", count, took);
        return count;
    }

    int checkNestedPointFeatureCollection(NestedPointFeatureCollection npfc, boolean show) throws IOException {
        long start = System.currentTimeMillis();
        int count = 0;
        PointFeatureCollectionIterator iter = npfc.getPointFeatureCollectionIterator(-1);
        while (iter.hasNext()) {
            PointFeatureCollection pfc = iter.next();
            if (show) {
                System.out.printf(" PointFeatureCollection=%s %n", pfc);
            }
            count += this.checkPointFeatureCollection(pfc, show);
        }
        long took = System.currentTimeMillis() - start;
        if (show) {
            System.out.println(" testNestedPointFeatureCollection complete count= " + count + " full iter took= " + took + " msec");
        }
        return count;
    }

    int checkStationProfileFeatureCollection(StationProfileFeatureCollection stationProfileFeatureCollection, boolean show) throws IOException {
        long start = System.currentTimeMillis();
        int count = 0;
        stationProfileFeatureCollection.resetIteration();
        while (stationProfileFeatureCollection.hasNext()) {
            StationProfileFeature spf = stationProfileFeatureCollection.next();
            List times = spf.getTimes();
            if (show) {
                System.out.printf("times= ", new Object[0]);
                for (Date t : times) {
                    System.out.printf("%s, ", t);
                }
                System.out.printf("%n", new Object[0]);
            }
            spf.resetIteration();
            while (spf.hasNext()) {
                ProfileFeature pf = spf.next();
                assert (pf.getName() != null);
                if (show) {
                    System.out.printf(" ProfileFeature=%s %n", pf);
                }
                count += this.checkPointFeatureCollection((PointFeatureCollection)pf, show);
            }
        }
        long took = System.currentTimeMillis() - start;
        if (show) {
            System.out.println(" testStationProfileFeatureCollection complete count= " + count + " full iter took= " + took + " msec");
        }
        return count;
    }

    int checkSectionFeatureCollection(SectionFeatureCollection sectionFeatureCollection, boolean show) throws IOException {
        long start = System.currentTimeMillis();
        int count = 0;
        sectionFeatureCollection.resetIteration();
        while (sectionFeatureCollection.hasNext()) {
            SectionFeature spf = sectionFeatureCollection.next();
            spf.resetIteration();
            while (spf.hasNext()) {
                ProfileFeature pf = spf.next();
                assert (pf.getName() != null);
                if (show) {
                    System.out.printf(" ProfileFeature=%s %n", pf);
                }
                count += this.checkPointFeatureCollection((PointFeatureCollection)pf, show);
            }
        }
        long took = System.currentTimeMillis() - start;
        if (show) {
            System.out.println(" testStationProfileFeatureCollection complete count= " + count + " full iter took= " + took + " msec");
        }
        return count;
    }

    int checkProfileFeatureCollection(ProfileFeatureCollection profileFeatureCollection, boolean show) throws IOException {
        long start = System.currentTimeMillis();
        int count = 0;
        profileFeatureCollection.resetIteration();
        while (profileFeatureCollection.hasNext()) {
            ProfileFeature pf = profileFeatureCollection.next();
            assert (pf.getName() != null);
            count += this.checkPointFeatureCollection((PointFeatureCollection)pf, show);
        }
        long took = System.currentTimeMillis() - start;
        if (show) {
            System.out.println(" testStationProfileFeatureCollection complete count= " + count + " full iter took= " + took + " msec");
        }
        return count;
    }

    void showStructureData(StationProfileFeatureCollection stationProfileFeatureCollection) throws IOException {
        PrintWriter pw = new PrintWriter(System.out);
        stationProfileFeatureCollection.resetIteration();
        while (stationProfileFeatureCollection.hasNext()) {
            StationProfileFeature stationProfile = stationProfileFeatureCollection.next();
            System.out.printf("stationProfile=%d %n", stationProfile.hashCode());
            stationProfile.resetIteration();
            while (stationProfile.hasNext()) {
                ProfileFeature profile = stationProfile.next();
                System.out.printf("-profile=%d %n", profile.hashCode());
                profile.resetIteration();
                while (profile.hasNext()) {
                    PointFeature pointFeature = profile.next();
                    System.out.printf("--pointFeature=%d %n", pointFeature.hashCode());
                    StructureData sdata = pointFeature.getData();
                    NCdumpW.printStructureData((PrintWriter)pw, (StructureData)sdata);
                }
            }
        }
    }

    int checkPointFeatureCollection(PointFeatureCollection pfc, boolean show) throws IOException {
        int n;
        if (show) {
            System.out.printf("----------- testPointFeatureCollection -----------------%n", new Object[0]);
            System.out.println(" test PointFeatureCollection " + pfc.getName());
            System.out.println(" calcBounds");
        }
        pfc.calcBounds();
        if (show) {
            System.out.println("  bb= " + pfc.getBoundingBox());
            System.out.println("  dateRange= " + pfc.getDateRange());
            System.out.println("  npts= " + pfc.size());
        }
        if ((n = pfc.size()) <= 0) {
            System.out.println("  empty " + pfc.getName());
            return 0;
        }
        LatLonRect bb = pfc.getBoundingBox();
        assert (bb != null);
        DateRange dr = pfc.getDateRange();
        assert (dr != null);
        if (show) {
            System.out.println(" complete iteration");
        }
        long start = System.currentTimeMillis();
        int count = 0;
        pfc.resetIteration();
        while (pfc.hasNext()) {
            PointFeature pf = pfc.next();
            this.checkPointFeature(pf);
            assert (bb.contains(pf.getLocation().getLatLon())) : pf.getLocation().getLatLon();
            if (!dr.contains(pf.getObservationTimeAsDate())) {
                System.out.printf("  date out of Range= %s on %s %n", pf.getObservationTimeAsDate(), pfc.getName());
            }
            ++count;
        }
        long took = System.currentTimeMillis() - start;
        if (show) {
            System.out.println(" testPointFeatureCollection complete count= " + count + " full iter took= " + took + " msec");
        }
        LatLonRect bb2 = new LatLonRect((LatLonPoint)bb.getLowerLeftPoint(), bb.getHeight() / 2.0, bb.getWidth() / 2.0);
        PointFeatureCollection subset = pfc.subset(bb2, null);
        if (show) {
            System.out.println(" subset bb= " + bb2.toString2());
        }
        start = System.currentTimeMillis();
        int counts = 0;
        PointFeatureIterator iters = subset.getPointFeatureIterator(-1);
        while (iters.hasNext()) {
            PointFeature pf = iters.next();
            assert (pf != null);
            assert (pf.getLocation() != null);
            assert (bb2.contains(pf.getLocation().getLatLon())) : bb2.toString2() + " does not contains point " + pf.getLocation().getLatLon();
            this.checkPointFeature(pf);
            ++counts;
        }
        took = System.currentTimeMillis() - start;
        if (show) {
            System.out.println(" testPointFeatureCollection subset count= " + counts + " full iter took= " + took + " msec");
        }
        return count;
    }

    private void checkPointFeature(PointFeature pobs) throws IOException {
        EarthLocation loc = pobs.getLocation();
        assert (loc != null);
        assert (null != pobs.getNominalTimeAsDate());
        assert (null != pobs.getObservationTimeAsDate());
        DateUnit timeUnit = pobs.getTimeUnit();
        assert (timeUnit.makeDate(pobs.getNominalTime()).equals(pobs.getNominalTimeAsDate()));
        assert (timeUnit.makeDate(pobs.getObservationTime()).equals(pobs.getObservationTimeAsDate()));
        StructureData sdata = pobs.getData();
        assert (null != sdata);
        this.checkData(sdata);
    }

    private void checkData(StructureData sdata) {
        for (StructureMembers.Member member : sdata.getMembers()) {
            DataType dt = member.getDataType();
            if (dt == DataType.FLOAT) {
                sdata.getScalarFloat(member);
                sdata.getJavaArrayFloat(member);
            } else if (dt == DataType.DOUBLE) {
                sdata.getScalarDouble(member);
                sdata.getJavaArrayDouble(member);
            } else if (dt == DataType.BYTE) {
                sdata.getScalarByte(member);
                sdata.getJavaArrayByte(member);
            } else if (dt == DataType.SHORT) {
                sdata.getScalarShort(member);
                sdata.getJavaArrayShort(member);
            } else if (dt == DataType.INT) {
                sdata.getScalarInt(member);
                sdata.getJavaArrayInt(member);
            } else if (dt == DataType.LONG) {
                sdata.getScalarLong(member);
                sdata.getJavaArrayLong(member);
            } else if (dt == DataType.CHAR) {
                sdata.getScalarChar(member);
                sdata.getJavaArrayChar(member);
                sdata.getScalarString(member);
            } else if (dt == DataType.STRING) {
                sdata.getScalarString(member);
            }
            if (dt == DataType.STRING || dt == DataType.CHAR || dt == DataType.STRUCTURE || dt == DataType.SEQUENCE) continue;
            sdata.convertScalarFloat(member.getName());
        }
    }

    int checkStationFeatureCollection(StationTimeSeriesFeatureCollection sfc) throws IOException {
        System.out.printf("--------------------------\nComplete Iteration for %s %n", sfc.getName());
        int countStns = this.countLocations(sfc);
        LatLonRect bb = sfc.getBoundingBox();
        assert (bb != null);
        LatLonRect bb2 = new LatLonRect((LatLonPoint)bb.getLowerLeftPoint(), bb.getHeight() / 2.0, bb.getWidth() / 2.0);
        System.out.println("Subset= " + bb2.toString2());
        StationTimeSeriesFeatureCollection sfcSub = sfc.subset(bb2);
        int countSub = this.countLocations(sfcSub);
        assert (countSub <= countStns);
        System.out.println("Flatten= " + bb2.toString2());
        PointFeatureCollection flatten = sfc.flatten(bb2, null);
        int countFlat = this.countLocations(flatten);
        assert (countFlat <= countStns);
        flatten = sfc.flatten(null, null);
        return this.countObs(flatten);
    }

    int countLocations(StationTimeSeriesFeatureCollection sfc) throws IOException {
        System.out.printf(" Station List Size = %d %n", sfc.getStations().size());
        HashMap<String, StationTimeSeriesFeature> stns = new HashMap<String, StationTimeSeriesFeature>(5000);
        HashMap<MyLocation, StationTimeSeriesFeature> locs = new HashMap<MyLocation, StationTimeSeriesFeature>(5000);
        sfc.resetIteration();
        while (sfc.hasNext()) {
            StationTimeSeriesFeature sf = sfc.next();
            StationTimeSeriesFeature other = (StationTimeSeriesFeature)stns.get(sf.getName());
            if (other != null) {
                System.out.printf("  duplicate name = %s %n", sf);
                System.out.printf("   of = %s %n", other);
            } else {
                stns.put(sf.getName(), sf);
            }
            MyLocation loc = new MyLocation((EarthLocation)sf);
            StationTimeSeriesFeature already = (StationTimeSeriesFeature)locs.get(loc);
            if (already != null) {
                System.out.printf("  duplicate location %s(%s) of %s(%s) %n", sf.getName(), sf.getDescription(), already.getName(), already.getDescription());
                continue;
            }
            locs.put(loc, sf);
        }
        System.out.printf(" unique locs = %d %n", locs.size());
        System.out.printf(" unique stns = %d %n", stns.size());
        return stns.size();
    }

    void checkLocation(String location, FeatureType type, boolean show) throws IOException {
        Formatter out = new Formatter();
        FeatureDataset fdataset = FeatureDatasetFactoryManager.open((FeatureType)type, (String)location, null, (Formatter)out);
        if (fdataset == null) {
            System.out.printf("**failed on %s %n --> %s %n", location, out);
            assert (false);
        }
        assert (fdataset instanceof FeatureDatasetPoint);
        FeatureDatasetPoint fdpoint = (FeatureDatasetPoint)fdataset;
        List collectionList = fdpoint.getPointFeatureCollectionList();
        FeatureCollection fc = (FeatureCollection)collectionList.get(0);
        if (fc instanceof PointFeatureCollection) {
            PointFeatureCollection pfc = (PointFeatureCollection)fc;
            this.countLocations(pfc);
            LatLonRect bb = pfc.getBoundingBox();
            LatLonRect bb2 = new LatLonRect((LatLonPoint)bb.getLowerLeftPoint(), bb.getHeight() / 2.0, bb.getWidth() / 2.0);
            PointFeatureCollection subset = pfc.subset(bb2, null);
            this.countLocations(subset);
        } else if (fc instanceof StationTimeSeriesFeatureCollection) {
            StationTimeSeriesFeatureCollection sfc = (StationTimeSeriesFeatureCollection)fc;
            PointFeatureCollection pfcAll = sfc.flatten(null, null);
            System.out.printf("Unique Locations all = %d %n", this.countLocations(pfcAll));
            LatLonRect bb = sfc.getBoundingBox();
            assert (bb != null);
            LatLonRect bb2 = new LatLonRect((LatLonPoint)bb.getLowerLeftPoint(), bb.getHeight() / 2.0, bb.getWidth() / 2.0);
            PointFeatureCollection pfcSub = sfc.flatten(bb2, null);
            System.out.printf("Unique Locations sub1 = %d %n", this.countLocations(pfcSub));
            StationTimeSeriesFeatureCollection sfcSub = sfc.subset(bb2);
            PointFeatureCollection pfcSub2 = sfcSub.flatten(null, null);
            System.out.printf("Unique Locations sub2 = %d %n", this.countLocations(pfcSub2));
            sfc = sfc.subset(bb2);
            PointFeatureCollection subDon = sfc.flatten(bb2, null);
            System.out.printf("Unique Locations subDon = %d %n", this.countLocations(subDon));
        }
    }

    int countLocations(PointFeatureCollection pfc) throws IOException {
        int count = 0;
        HashSet<MyLocation> locs = new HashSet<MyLocation>(80000);
        pfc.resetIteration();
        while (pfc.hasNext()) {
            PointFeature pf = pfc.next();
            MyLocation loc = new MyLocation(pf.getLocation());
            if (!locs.contains(loc)) {
                locs.add(loc);
            }
            ++count;
        }
        System.out.printf("Count Points  = %d Unique points = %d %n", count, locs.size());
        return locs.size();
    }

    int countObs(PointFeatureCollection pfc) throws IOException {
        int count = 0;
        pfc.resetIteration();
        while (pfc.hasNext()) {
            PointFeature pf = pfc.next();
            StructureData sd = pf.getData();
            ++count;
        }
        return count;
    }

    private void testPointVsAny(String file, boolean showIO) throws IOException {
        long start = System.currentTimeMillis();
        if (showIO) {
            RandomAccessFile.setDebugAccess((boolean)true);
        }
        LatLonRect llr = new LatLonRect((LatLonPoint)new LatLonPointImpl(33.4, -92.2), (LatLonPoint)new LatLonPointImpl(47.9, -75.89));
        System.out.println("subset box = " + llr);
        Formatter buf = new Formatter();
        FeatureDatasetPoint pods = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open((FeatureType)FeatureType.POINT, (String)file, null, (Formatter)buf);
        if (pods != null) {
            System.out.println("================\nOpen as POINT");
            this.readAll(pods, llr, "POINT", true);
        }
        if ((pods = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open((FeatureType)FeatureType.ANY_POINT, (String)file, null, (Formatter)buf)) != null) {
            System.out.println("======================\nOpen as ANY_POINT");
            this.readAll(pods, llr, "ANY_POINT", true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readAll(FeatureDatasetPoint pods, LatLonRect llr, String what, boolean showIO) throws IOException {
        long start = System.currentTimeMillis();
        if (showIO) {
            RandomAccessFile.setDebugAccess((boolean)true);
        }
        List collectionList = pods.getPointFeatureCollectionList();
        FeatureCollection fc = (FeatureCollection)collectionList.get(0);
        PointFeatureCollection collection = null;
        if (fc instanceof PointFeatureCollection) {
            collection = (PointFeatureCollection)fc;
            collection = collection.subset(llr, null);
            what = what + ".subset";
        } else if (fc instanceof NestedPointFeatureCollection) {
            NestedPointFeatureCollection npfc = (NestedPointFeatureCollection)fc;
            collection = npfc.flatten(llr, null);
            what = what + ".flatten";
        } else {
            throw new IllegalArgumentException("Can't handle collection of type " + fc.getClass().getName());
        }
        PointFeatureIterator dataIterator = collection.getPointFeatureIterator(-1);
        try {
            int numObs = 0;
            while (dataIterator.hasNext()) {
                PointFeature po = dataIterator.next();
                if (numObs % 1000 == 0) {
                    System.out.printf("%d el = %s %n", numObs, po.getLocation());
                }
                ++numObs;
            }
            long took = System.currentTimeMillis() - start;
            System.out.printf("%s took %d msecs nobs = %d%n  seeks= %d Mbytes read= %d%n", what, took, numObs, RandomAccessFile.getDebugNseeks(), RandomAccessFile.getDebugNbytes() / 1000000L);
        }
        finally {
            if (dataIterator != null) {
                dataIterator.finish();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testDons(String file, boolean showTime) throws IOException {
        Formatter buf;
        FeatureDatasetPoint pods;
        long start = System.currentTimeMillis();
        if (showTime) {
            RandomAccessFile.setDebugAccess((boolean)true);
        }
        if ((pods = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open((FeatureType)FeatureType.POINT, (String)file, null, (Formatter)(buf = new Formatter()))) == null) {
            System.out.println("trying as ANY_POINT");
            pods = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open((FeatureType)FeatureType.ANY_POINT, (String)file, null, (Formatter)buf);
        } else {
            System.out.println("Open as POINT");
        }
        if (pods == null) {
            throw new IOException("can't open file error=" + buf);
        }
        List collectionList = pods.getPointFeatureCollectionList();
        FeatureCollection fc = (FeatureCollection)collectionList.get(0);
        LatLonRect llr = new LatLonRect((LatLonPoint)new LatLonPointImpl(33.4, -92.2), (LatLonPoint)new LatLonPointImpl(47.9, -75.89));
        System.out.println("llr = " + llr);
        PointFeatureCollection collection = null;
        if (fc instanceof PointFeatureCollection) {
            collection = (PointFeatureCollection)fc;
            if (llr != null) {
                collection = collection.subset(llr, null);
            }
        } else if (fc instanceof NestedPointFeatureCollection) {
            NestedPointFeatureCollection npfc = (NestedPointFeatureCollection)fc;
            collection = npfc.flatten(llr, null);
        } else {
            throw new IllegalArgumentException("Can't handle collection of type " + fc.getClass().getName());
        }
        PointFeatureIterator dataIterator = collection.getPointFeatureIterator(-1);
        try {
            int numObs = 0;
            while (dataIterator.hasNext()) {
                PointFeature po = dataIterator.next();
                ++numObs;
                EarthLocation el = po.getLocation();
                assert (llr.contains(el.getLatLon())) : el.getLatLon();
                if (numObs % 1000 != 0) continue;
                System.out.printf("%d el = %s %n", numObs, el);
            }
            long took = System.currentTimeMillis() - start;
            System.out.printf("response took %d msecs nobs = %d%n  seeks= %d nbytes read= %d%n", took, numObs, RandomAccessFile.getDebugNseeks(), RandomAccessFile.getDebugNbytes());
        }
        finally {
            if (dataIterator != null) {
                dataIterator.finish();
            }
        }
        long took = System.currentTimeMillis() - start;
        System.out.printf("%ntotal response took %d msecs%n", took);
    }

    private void testDon2(String file, boolean usePresent) throws Exception {
        DateRange dr;
        Formatter buf = new Formatter();
        FeatureDatasetPoint pods = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open((FeatureType)FeatureType.ANY_POINT, (String)file, null, (Formatter)buf);
        if (pods == null) {
            throw new IOException("can't open file " + file);
        }
        System.out.printf("Opened file %s%n dateRange= %s", file, pods.getDateRange());
        List collectionList = pods.getPointFeatureCollectionList();
        FeatureCollection fc = (FeatureCollection)collectionList.get(0);
        LatLonRect llr = new LatLonRect((LatLonPoint)new LatLonPointImpl(33.4, -92.2), (LatLonPoint)new LatLonPointImpl(47.9, -75.89));
        System.out.println("llr = " + llr);
        if (usePresent) {
            dr = new DateRange(null, new DateType(true, null), new TimeDuration("2 hour"), null);
        } else {
            Date startd = pods.getDateRange().getStart().getDate();
            dr = new DateRange(startd, new TimeDuration("1 hour"));
        }
        System.out.println("date range = " + dr);
        long start = System.currentTimeMillis();
        PointFeatureCollection collection = null;
        if (fc instanceof PointFeatureCollection) {
            collection = (PointFeatureCollection)fc;
            if (llr != null) {
                collection = collection.subset(llr, dr);
            }
        } else if (fc instanceof NestedPointFeatureCollection) {
            NestedPointFeatureCollection npfc = (NestedPointFeatureCollection)fc;
            collection = npfc.flatten(llr, dr);
        } else {
            throw new IllegalArgumentException("Can't handle collection of type " + fc.getClass().getName());
        }
        DateRange track = null;
        DateFormatter df = new DateFormatter();
        PointFeatureIterator dataIterator = collection.getPointFeatureIterator(-1);
        int numObs = 0;
        while (dataIterator.hasNext()) {
            PointFeature po = dataIterator.next();
            ++numObs;
            EarthLocation el = po.getLocation();
            StructureData structure = po.getData();
            assert (llr.contains(el.getLatLon())) : el.getLatLon() + " not in " + llr;
            Date obsDate = po.getObservationTimeAsDate();
            assert (dr.included(obsDate)) : df.toDateTimeString(obsDate) + " not in " + dr;
            if (numObs % 1000 == 0) {
                System.out.printf("%d el = %s %s %n", numObs, el, df.toDateTimeString(obsDate));
            }
            if (track == null) {
                track = new DateRange(obsDate, obsDate);
                continue;
            }
            track.extend(obsDate);
        }
        dataIterator.finish();
        long took = System.currentTimeMillis() - start;
        System.out.printf("%ntotal response took %d msecs nobs = %d range=%s %n==============%n", took, numObs, track);
    }

    private void testDon3(String file, boolean usePresent) throws Exception {
        long start = System.currentTimeMillis();
        Formatter buf = new Formatter();
        for (int i = 0; i < 10; ++i) {
            FeatureDatasetPoint pods = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open((FeatureType)FeatureType.POINT, (String)file, null, (Formatter)buf);
            if (pods == null) {
                System.out.println("trying as ANY_POINT");
                pods = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open((FeatureType)FeatureType.ANY_POINT, (String)file, null, (Formatter)buf);
            }
            if (pods == null) {
                throw new Exception("can't open file");
            }
            List collectionList = pods.getPointFeatureCollectionList();
            FeatureCollection fc = (FeatureCollection)collectionList.get(0);
            LatLonRect llr = new LatLonRect((LatLonPoint)new LatLonPointImpl(33.4, -92.2), (LatLonPoint)new LatLonPointImpl(47.9, -75.89));
            System.out.println("llr = " + llr);
            Date now = new Date();
            Date ago = new Date(now.getTime() - 3600000L);
            DateRange dr = new DateRange(ago, now);
            PointFeatureCollection collection = null;
            if (fc instanceof PointFeatureCollection) {
                collection = (PointFeatureCollection)fc;
                if (llr != null) {
                    collection = collection.subset(llr, dr);
                }
            } else if (fc instanceof NestedPointFeatureCollection) {
                NestedPointFeatureCollection npfc = (NestedPointFeatureCollection)fc;
                collection = npfc.flatten(llr, dr);
            } else {
                throw new IllegalArgumentException("Can't handle collection of type " + fc.getClass().getName());
            }
            PointFeatureIterator dataIterator = collection.getPointFeatureIterator(-1);
            int numObs = 0;
            while (dataIterator.hasNext()) {
                PointFeature po = dataIterator.next();
                ++numObs;
                EarthLocation el = po.getLocation();
                StructureData structure = po.getData();
                assert (llr.contains(el.getLatLon())) : el.getLatLon();
                assert (dr.included(po.getNominalTimeAsDate()));
                if (numObs % 1000 != 0) continue;
                System.out.printf("%d el = %s %n", numObs, el);
            }
            dataIterator.finish();
            long took = System.currentTimeMillis() - start;
            System.out.printf("%ntotal response took %d msecs nobs = %d%n  seeks= %d nbytes read= %d%n", took, numObs, RandomAccessFile.getDebugNseeks(), RandomAccessFile.getDebugNbytes());
            Thread.sleep(6000L);
        }
    }

    private void testGempakMissing(String file) throws Exception {
        Formatter buf = new Formatter();
        FeatureDatasetPoint pods = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open((FeatureType)FeatureType.STATION, (String)file, null, (Formatter)buf);
        if (pods == null) {
            throw new Exception("can't open file");
        }
        List collectionList = pods.getPointFeatureCollectionList();
        StationTimeSeriesFeatureCollection sfc = (StationTimeSeriesFeatureCollection)collectionList.get(0);
        int count = 0;
        int countMissing = 0;
        sfc.resetIteration();
        while (sfc.hasNext()) {
            StationTimeSeriesFeature sf = sfc.next();
            sf.resetIteration();
            while (sf.hasNext()) {
                PointFeature pf = sf.next();
                StructureData sdata = pf.getData();
                byte bval = sdata.getScalarByte("_isMissing");
                if (bval == 1) {
                    ++countMissing;
                }
                ++count;
            }
        }
        double ratio = (double)countMissing / (double)count;
        System.out.printf("countMissing=%d total=%d ratio=%f %n", countMissing, count, ratio);
    }

    public void utestYuan() throws IOException {
        Formatter buf = new Formatter();
        FeatureDatasetPoint pods = (FeatureDatasetPoint)FeatureDatasetFactoryManager.open((FeatureType)FeatureType.TRAJECTORY, (String)"Q:/profile/cosmic/atmPhs_C001.2009.321.23.20.G16_0001.0001_nc", null, (Formatter)buf);
        TrajectoryFeatureCollection tc = (TrajectoryFeatureCollection)pods.getPointFeatureCollectionList().get(0);
        while (tc.hasNext()) {
            int count = 0;
            TrajectoryFeature tf = tc.next();
            PointFeatureIterator pfi = tf.getPointFeatureIterator(5000);
            while (pfi.hasNext()) {
                PointFeature pf = pfi.next();
                System.out.printf("%d ", count);
                ++count;
            }
        }
        pods.close();
    }

    public static void main(String[] arg) throws Exception {
        TestPointFeatureTypes test = new TestPointFeatureTypes("");
        test.testGempakMissing("C:\\data\\ft\\station\\20090524_sao.gem");
    }

    private class MyLocation {
        double lat;
        double lon;
        double alt;
        private int hashCode = 0;

        public MyLocation(EarthLocation from) {
            this.lat = from.getLatitude();
            this.lon = from.getLongitude();
            this.alt = Double.isNaN(from.getAltitude()) ? 0.0 : from.getAltitude();
        }

        public boolean equals(Object oo) {
            if (this == oo) {
                return true;
            }
            if (!(oo instanceof MyLocation)) {
                return false;
            }
            MyLocation other = (MyLocation)oo;
            return this.lat == other.lat && this.lon == other.lon && this.alt == other.alt;
        }

        public int hashCode() {
            if (this.hashCode == 0) {
                int result = 17;
                result = (int)((double)result + ((double)(37 * result) + this.lat * 10000.0));
                result = (int)((double)result + ((double)(37 * result) + this.lon * 10000.0));
                this.hashCode = result = (int)((double)result + ((double)(37 * result) + this.alt * 10000.0));
            }
            return this.hashCode;
        }
    }

    class MyFileFilter
    implements FileFilter {
        MyFileFilter() {
        }

        @Override
        public boolean accept(File pathname) {
            String path = pathname.getPath();
            if (new File(path + ".ncml").exists()) {
                return false;
            }
            if (path.endsWith(".ncml")) {
                return true;
            }
            int pos = path.lastIndexOf(".");
            return !new File(path.substring(0, pos) + ".ncml").exists();
        }
    }
}

