/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import junit.framework.TestCase;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Section;
import ucar.nc2.iosp.IndexChunker;
import ucar.nc2.iosp.IndexChunkerTiled;

public class TestIndexChunker
extends TestCase {
    public TestIndexChunker(String name) {
        super(name);
    }

    public void testFull() throws InvalidRangeException {
        int[] shape = new int[]{123, 22, 92, 12};
        Section section = new Section(shape);
        IndexChunker index = new IndexChunker(shape, section);
        assert (index.getTotalNelems() == section.computeSize());
        IndexChunker.Chunk chunk = index.next();
        assert ((long)chunk.getNelems() == section.computeSize());
        assert (!index.hasNext());
    }

    public void testPart() throws InvalidRangeException {
        int[] full = new int[]{2, 10, 20};
        int[] part = new int[]{2, 5, 20};
        Section section = new Section(part);
        IndexChunker index = new IndexChunker(full, section);
        assert (index.getTotalNelems() == section.computeSize());
        IndexChunker.Chunk chunk = index.next();
        assert ((long)chunk.getNelems() == section.computeSize() / 2L);
    }

    public void testChunkerTiled() throws InvalidRangeException {
        Section dataSection = new Section("0:0, 20:39,  0:1353 ");
        Section wantSection = new Section("0:2, 22:3152,0:1350");
        IndexChunkerTiled index = new IndexChunkerTiled(dataSection, wantSection);
        while (index.hasNext()) {
            IndexChunker.Chunk chunk = index.next();
            System.out.println(" " + chunk);
        }
    }

    public void testChunkerTiled2() throws InvalidRangeException {
        Section dataSection = new Section("0:0, 40:59,  0:1353  ");
        Section wantSection = new Section("0:2, 22:3152,0:1350");
        IndexChunkerTiled index = new IndexChunkerTiled(dataSection, wantSection);
        while (index.hasNext()) {
            IndexChunker.Chunk chunk = index.next();
            System.out.println(" " + chunk);
        }
    }
}

