/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp;

import java.util.ArrayList;
import junit.framework.TestCase;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.iosp.Indexer;
import ucar.nc2.iosp.RegularLayout;

public class TestIndexer
extends TestCase {
    public TestIndexer(String name) {
        super(name);
    }

    public void testFull() throws InvalidRangeException {
        int[] shape = new int[]{123, 22, 92, 12};
        Section section = new Section(shape);
        RegularLayout index = new RegularLayout(0L, 1, -1, shape, section);
        assert (index.getTotalNelems() == section.computeSize());
        Indexer.Chunk chunk = index.next();
        assert ((long)chunk.getNelems() == section.computeSize());
        assert (!index.hasNext());
    }

    public void testRegularIndexerNonRecord() throws InvalidRangeException {
        RegularLayout index = TestIndexer.makeIndexer(new int[]{29}, 1, new int[]{2}, new int[]{7}, -1);
        assert (index.getTotalNelems() == 7L);
        assert (index.getChunkSize() == 7);
        assert (index.next().getFilePos() == 2L);
        assert (!index.hasNext());
        index = TestIndexer.makeIndexer(new int[]{29, 40}, 1, new int[]{0, 0}, new int[]{7, 9}, -1);
        assert (index.getTotalNelems() == 63L);
        assert (index.getChunkSize() == 9);
        assert (index.next().getFilePos() == 0L);
        assert (index.next().getFilePos() == 40L);
        assert (index.next().getFilePos() == 80L);
        assert (index.next().getFilePos() == 120L);
        assert (index.next().getFilePos() == 160L);
        assert (index.next().getFilePos() == 200L);
        assert (index.next().getFilePos() == 240L);
        assert (!index.hasNext());
        index = TestIndexer.makeIndexer(new int[]{29, 40}, 1, new int[]{2, 3}, new int[]{7, 33}, -1);
        assert (index.getTotalNelems() == 231L);
        assert (index.getChunkSize() == 33);
        assert (index.next().getFilePos() == 83L);
        assert (index.next().getFilePos() == 123L);
        assert (index.next().getFilePos() == 163L);
        assert (index.next().getFilePos() == 203L);
        assert (index.next().getFilePos() == 243L);
        assert (index.next().getFilePos() == 283L);
        assert (index.next().getFilePos() == 323L);
        assert (!index.hasNext());
        index = TestIndexer.makeIndexer(new int[]{4, 3, 3}, 1, new int[]{2, 1, 0}, new int[]{2, 2, 3}, -1);
        assert (index.getTotalNelems() == 12L);
        assert (index.getChunkSize() == 6);
        assert (index.next().getFilePos() == 21L);
        assert (index.next().getFilePos() == 30L);
        assert (!index.hasNext());
        index = TestIndexer.makeIndexer(new int[]{4, 3, 3}, 1, new int[]{2, 0, 0}, new int[]{2, 3, 3}, -1);
        assert (index.getTotalNelems() == 18L);
        assert (index.getChunkSize() == 18);
        assert (index.next().getFilePos() == 18L);
        assert (!index.hasNext());
        index = TestIndexer.makeIndexer(new int[]{4, 3, 3, 1}, 1, new int[]{2, 0, 0, 0}, new int[]{2, 3, 3, 1}, -1);
        assert (index.getTotalNelems() == 18L);
        assert (index.getChunkSize() == 18);
        assert (index.next().getFilePos() == 18L);
        assert (!index.hasNext());
        index = TestIndexer.makeIndexer(new int[]{2, 4, 3, 3}, 1, new int[]{1, 2, 0, 0}, new int[]{1, 2, 3, 3}, -1);
        assert (index.getTotalNelems() == 18L);
        assert (index.getChunkSize() == 18);
        assert (index.next().getFilePos() == 54L);
        assert (!index.hasNext());
        index = TestIndexer.makeIndexer(new int[]{2, 4, 3, 3}, 1, new int[]{1, 2, 0, 0}, new int[]{1, 2, 3, 2}, -1);
        assert (index.getTotalNelems() == 12L);
        assert (index.getChunkSize() == 2);
        assert (index.next().getFilePos() == 54L);
    }

    public void testRegularIndexerNonRecordElemSize() {
        try {
            RegularLayout index = TestIndexer.makeIndexer(new int[]{29}, 2, new int[]{2}, new int[]{7}, -1);
            assert (index.getTotalNelems() == 7L);
            assert (index.getChunkSize() == 7);
            assert (index.next().getFilePos() == 4L);
            assert (!index.hasNext());
            index = TestIndexer.makeIndexer(new int[]{29, 40}, 2, new int[]{0, 0}, new int[]{7, 9}, -1);
            assert (index.getTotalNelems() == 63L);
            assert (index.getChunkSize() == 9);
            assert (index.next().getFilePos() == 0L);
            assert (index.next().getFilePos() == 80L);
            assert (index.next().getFilePos() == 160L);
            assert (index.next().getFilePos() == 240L);
            index = TestIndexer.makeIndexer(new int[]{29, 40}, 4, new int[]{2, 3}, new int[]{7, 33}, -1);
            assert (index.getTotalNelems() == 231L);
            assert (index.getChunkSize() == 33);
            assert (index.next().getFilePos() == 332L);
            assert (index.next().getFilePos() == 492L);
            assert (index.next().getFilePos() == 652L);
            assert (index.next().getFilePos() == 812L);
            assert (index.next().getFilePos() == 972L);
            assert (index.next().getFilePos() == 1132L);
            assert (index.next().getFilePos() == 1292L);
            assert (!index.hasNext());
            index = TestIndexer.makeIndexer(new int[]{4, 3, 3}, 8, new int[]{2, 1, 0}, new int[]{2, 2, 3}, -1);
            assert (index.getTotalNelems() == 12L);
            assert (index.getChunkSize() == 6);
            assert (index.next().getFilePos() == 168L);
            assert (index.next().getFilePos() == 240L);
            assert (!index.hasNext());
            index = TestIndexer.makeIndexer(new int[]{4, 3, 3}, 8, new int[]{2, 0, 0}, new int[]{2, 3, 3}, -1);
            assert (index.getTotalNelems() == 18L);
            assert (index.getChunkSize() == 18);
            assert (index.next().getFilePos() == 144L);
            assert (!index.hasNext());
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
        }
    }

    public void testRegularIndexerWithRecord() throws InvalidRangeException {
        RegularLayout index = TestIndexer.makeIndexer(new int[]{29}, 1, new int[]{2}, new int[]{7}, 1000);
        assert (index.getTotalNelems() == 7L);
        assert (index.getChunkSize() == 1);
        assert (index.next().getFilePos() == 2000L);
        assert (index.next().getFilePos() == 3000L);
        index = TestIndexer.makeIndexer(new int[]{29, 40}, 1, new int[]{0, 0}, new int[]{7, 9}, 100);
        assert (index.getTotalNelems() == 63L);
        assert (index.getChunkSize() == 9);
        assert (index.next().getFilePos() == 0L);
        assert (index.next().getFilePos() == 100L);
        assert (index.next().getFilePos() == 200L);
        assert (index.next().getFilePos() == 300L);
        assert (index.next().getFilePos() == 400L);
        assert (index.next().getFilePos() == 500L);
        assert (index.next().getFilePos() == 600L);
        assert (!index.hasNext());
        index = TestIndexer.makeIndexer(new int[]{29, 40}, 4, new int[]{2, 3}, new int[]{3, 33}, 1000);
        assert (index.getTotalNelems() == 99L);
        assert (index.getChunkSize() == 33);
        assert (index.next().getFilePos() == 2012L);
        assert (index.next().getFilePos() == 3012L);
        assert (index.next().getFilePos() == 4012L);
        assert (!index.hasNext());
        index = TestIndexer.makeIndexer(new int[]{4, 3, 3}, 1, new int[]{0, 0, 0}, new int[]{2, 2, 3}, 1000);
        assert (index.getTotalNelems() == 12L);
        assert (index.getChunkSize() == 6);
        assert (index.next().getFilePos() == 0L);
        assert (index.next().getFilePos() == 1000L);
        assert (!index.hasNext());
        index = TestIndexer.makeIndexer(new int[]{4, 3, 3}, 1, new int[]{0, 1, 0}, new int[]{2, 2, 3}, 1000);
        assert (index.getTotalNelems() == 12L);
        assert (index.getChunkSize() == 6);
        assert (index.next().getFilePos() == 3L);
        assert (index.next().getFilePos() == 1003L);
        assert (!index.hasNext());
        index = TestIndexer.makeIndexer(new int[]{4, 3, 3}, 1, new int[]{2, 1, 0}, new int[]{2, 2, 3}, 1000);
        assert (index.getTotalNelems() == 12L);
        assert (index.getChunkSize() == 6);
        assert (index.next().getFilePos() == 2003L);
        assert (index.next().getFilePos() == 3003L);
        assert (!index.hasNext());
        index = TestIndexer.makeIndexer(new int[]{4, 3, 3}, 1, new int[]{0, 0, 0}, new int[]{2, 3, 3}, 1000);
        assert (index.getTotalNelems() == 18L);
        assert (index.getChunkSize() == 9);
        assert (index.next().getFilePos() == 0L);
        assert (index.next().getFilePos() == 1000L);
        assert (!index.hasNext());
        index = TestIndexer.makeIndexer(new int[]{4, 3, 3}, 1, new int[]{2, 0, 0}, new int[]{2, 3, 3}, 1000);
        assert (index.getTotalNelems() == 18L);
        assert (index.getChunkSize() == 9);
        assert (index.next().getFilePos() == 2000L);
        assert (index.next().getFilePos() == 3000L);
        assert (!index.hasNext());
        index = TestIndexer.makeIndexer(new int[]{4, 3, 3, 1}, 1, new int[]{2, 0, 0, 0}, new int[]{2, 3, 3, 1}, 100);
        assert (index.getTotalNelems() == 18L);
        assert (index.getChunkSize() == 9);
        assert (index.next().getFilePos() == 200L);
        assert (index.next().getFilePos() == 300L);
        assert (!index.hasNext());
        index = TestIndexer.makeIndexer(new int[]{2, 4, 3, 3}, 1, new int[]{1, 2, 0, 0}, new int[]{1, 2, 3, 3}, 1000);
        assert (index.getTotalNelems() == 18L);
        assert (index.getChunkSize() == 18);
        assert (index.next().getFilePos() == 1018L);
        assert (!index.hasNext());
        index = TestIndexer.makeIndexer(new int[]{2, 4, 3, 3}, 1, new int[]{1, 2, 0, 0}, new int[]{1, 2, 3, 2}, 1000);
        assert (index.getTotalNelems() == 12L);
        assert (index.getChunkSize() == 2);
        assert (index.next().getFilePos() == 1018L);
    }

    public void testRegularIndexerWhole() {
        try {
            RegularLayout index = TestIndexer.makeIndexer(new int[]{29}, 1, new int[1], new int[]{29}, -1);
            assert (index.getTotalNelems() == 29L);
            assert (index.getChunkSize() == 29);
            assert (index.next().getFilePos() == 0L);
            assert (!index.hasNext());
            index = TestIndexer.makeIndexer(new int[]{3}, 4, new int[1], new int[]{3}, 10);
            assert (index.getTotalNelems() == 3L);
            assert (index.getChunkSize() == 1);
            assert (index.next().getFilePos() == 0L);
            assert (index.next().getFilePos() == 10L);
            assert (index.next().getFilePos() == 20L);
            assert (!index.hasNext());
            index = TestIndexer.makeIndexer(new int[]{7, 40}, 1, new int[2], new int[]{7, 40}, -1);
            assert (index.getTotalNelems() == 280L);
            assert (index.getChunkSize() == 280);
            assert (index.next().getFilePos() == 0L);
            assert (!index.hasNext());
            index = TestIndexer.makeIndexer(new int[]{7, 40}, 1, new int[2], new int[]{7, 40}, 100);
            assert (index.getTotalNelems() == 280L);
            assert (index.getChunkSize() == 40);
            assert (index.next().getFilePos() == 0L);
            assert (index.next().getFilePos() == 100L);
            assert (index.next().getFilePos() == 200L);
            assert (index.next().getFilePos() == 300L);
            assert (index.next().getFilePos() == 400L);
            assert (index.next().getFilePos() == 500L);
            assert (index.next().getFilePos() == 600L);
            assert (!index.hasNext());
            index = TestIndexer.makeIndexer(new int[]{4, 3, 3}, 1, new int[3], new int[]{4, 3, 3}, -1);
            assert (index.getTotalNelems() == 36L);
            assert (index.getChunkSize() == 36);
            assert (index.next().getFilePos() == 0L);
            assert (!index.hasNext());
            index = TestIndexer.makeIndexer(new int[]{4, 3, 3}, 1, new int[3], new int[]{4, 3, 3}, 1000);
            assert (index.getTotalNelems() == 36L);
            assert (index.getChunkSize() == 9);
            assert (index.next().getFilePos() == 0L);
            assert (index.next().getFilePos() == 1000L);
            assert (index.next().getFilePos() == 2000L);
            assert (index.next().getFilePos() == 3000L);
            assert (!index.hasNext());
            index = TestIndexer.makeIndexer(new int[]{4, 3, 3, 1}, 1, new int[4], new int[]{4, 3, 3, 1}, -1);
            assert (index.getTotalNelems() == 36L);
            assert (index.getChunkSize() == 36);
            assert (index.next().getFilePos() == 0L);
            assert (!index.hasNext());
            index = TestIndexer.makeIndexer(new int[]{4, 3, 3, 1}, 1, new int[4], new int[]{4, 3, 3, 1}, 1000);
            assert (index.getTotalNelems() == 36L);
            assert (index.getChunkSize() == 9);
            assert (index.next().getFilePos() == 0L);
            assert (index.next().getFilePos() == 1000L);
            assert (index.next().getFilePos() == 2000L);
            assert (index.next().getFilePos() == 3000L);
            assert (!index.hasNext());
            index = TestIndexer.makeIndexer(new int[]{1, 4, 3, 3}, 1, new int[4], new int[]{1, 4, 3, 3}, 100);
            assert (index.getTotalNelems() == 36L);
            assert (index.getChunkSize() == 36);
            assert (index.next().getFilePos() == 0L);
            assert (!index.hasNext());
            index = TestIndexer.makeIndexer(new int[]{1, 4, 3, 3}, 1, new int[4], new int[]{1, 4, 3, 3}, -1);
            assert (index.getTotalNelems() == 36L);
            assert (index.getChunkSize() == 36);
            assert (index.next().getFilePos() == 0L);
            assert (!index.hasNext());
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
        }
    }

    public void testRegularIndexerRangeErrors() {
        RegularLayout index;
        try {
            index = TestIndexer.makeIndexer(new int[]{29}, 1, new int[1], new int[]{30}, -1);
            assert (false);
        }
        catch (InvalidRangeException e) {
            // empty catch block
        }
        try {
            index = TestIndexer.makeIndexer(new int[]{29}, 1, new Section(new int[1], new int[]{30, 30}), -1);
            assert (false);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            index = TestIndexer.makeIndexer(new int[]{2, 3}, 1, new int[2], new int[]{30, 30}, -1);
            assert (false);
        }
        catch (InvalidRangeException e) {
            // empty catch block
        }
        try {
            index = TestIndexer.makeIndexer(new int[]{2, 2}, 1, new int[2], new int[]{1}, -1);
            assert (false);
        }
        catch (InvalidRangeException e) {
            // empty catch block
        }
        try {
            index = TestIndexer.makeIndexer(new int[]{20}, 1, new int[]{10}, new int[]{15}, -1);
            assert (false);
        }
        catch (InvalidRangeException invalidRangeException) {
            // empty catch block
        }
    }

    public void testSection() throws InvalidRangeException {
        Indexer.Chunk chunk;
        ArrayList<Range> section = new ArrayList<Range>();
        section.add(new Range(0, 9));
        section.add(new Range(0, 9));
        RegularLayout index = new RegularLayout(new int[]{10, 10}, 1, 0L, section, -1);
        assert (index.getTotalNelems() == 100L);
        assert (index.getChunkSize() == 100);
        assert (index.next().getFilePos() == 0L);
        assert (!index.hasNext());
        section = new ArrayList();
        section.add(new Range(0, 9));
        section.add(new Range(0, 4));
        index = new RegularLayout(new int[]{10, 10}, 1, 0L, section, -1);
        assert (index.getTotalNelems() == 50L);
        assert (index.getChunkSize() == 5);
        int count = 0;
        while (index.hasNext()) {
            chunk = index.next();
            assert (chunk.getFilePos() == (long)(count * 10)) : chunk.getFilePos();
            assert (chunk.getNelems() == 5);
            assert (chunk.getStartElem() == (long)(count * 5));
            ++count;
        }
        section = new ArrayList();
        section.add(new Range(1, 5));
        section.add(new Range(0, 9));
        index = new RegularLayout(new int[]{10, 10}, 1, 0L, section, -1);
        assert (index.getTotalNelems() == 50L);
        assert (index.getChunkSize() == 50);
        count = 0;
        while (index.hasNext()) {
            chunk = index.next();
            System.out.println(" chunk= " + chunk);
            assert (chunk.getFilePos() == 10L);
            assert (chunk.getNelems() == index.getChunkSize());
            assert (chunk.getStartElem() == (long)(count * index.getChunkSize()));
            ++count;
        }
    }

    public void testSectionStride() throws InvalidRangeException {
        Indexer.Chunk chunk;
        ArrayList<Range> section = new ArrayList<Range>();
        section.add(new Range(0, 9));
        section.add(new Range(0, 9, 2));
        RegularLayout index = new RegularLayout(new int[]{10, 10}, 1, 0L, section, -1);
        assert (index.getTotalNelems() == 50L);
        assert (index.getChunkSize() == 1) : index.getChunkSize();
        int count = 0;
        while (index.hasNext()) {
            chunk = index.next();
            assert (chunk.getFilePos() == (long)(count * 2)) : chunk.getFilePos();
            assert (chunk.getNelems() == index.getChunkSize());
            assert (chunk.getStartElem() == (long)(count * index.getChunkSize()));
            ++count;
        }
        section = new ArrayList();
        section.add(new Range(0, 9, 2));
        section.add(new Range(0, 9));
        index = new RegularLayout(new int[]{10, 10}, 1, 0L, section, -1);
        assert (index.getTotalNelems() == 50L);
        assert (index.getChunkSize() == 10) : index.getChunkSize();
        count = 0;
        while (index.hasNext()) {
            chunk = index.next();
            assert (chunk.getFilePos() == (long)(count * 20)) : chunk.getFilePos();
            assert (chunk.getNelems() == index.getChunkSize());
            assert (chunk.getStartElem() == (long)(count * index.getChunkSize()));
            ++count;
        }
        section = new ArrayList();
        section.add(new Range(0, 9, 2));
        section.add(new Range(0, 9, 2));
        index = new RegularLayout(new int[]{10, 10}, 1, 0L, section, -1);
        assert (index.getTotalNelems() == 25L);
        assert (index.getChunkSize() == 1) : index.getChunkSize();
        assert (index.next().getFilePos() == 0L);
        assert (index.next().getFilePos() == 2L);
        assert (index.next().getFilePos() == 4L);
        assert (index.next().getFilePos() == 6L);
        assert (index.next().getFilePos() == 8L);
        assert (index.next().getFilePos() == 20L);
        assert (index.next().getFilePos() == 22L);
        assert (index.next().getFilePos() == 24L);
        assert (index.next().getFilePos() == 26L);
        assert (index.next().getFilePos() == 28L);
        assert (index.next().getFilePos() == 40L);
        assert (index.next().getFilePos() == 42L);
        section = new ArrayList();
        section.add(new Range(0, 9, 2));
        section.add(new Range(0, 9, 2));
        index = new RegularLayout(new int[]{10, 10}, 1, 0L, section, -1);
        count = 0;
        while (index.hasNext()) {
            chunk = index.next();
            int y = count / 5;
            int x = count % 5;
            assert (chunk.getFilePos() == (long)(20 * y + 2 * x)) : chunk.getFilePos() + " " + count;
            ++count;
        }
    }

    public void testSectionStrideOrigin() throws InvalidRangeException {
        int x;
        int y;
        Indexer.Chunk chunk;
        ArrayList<Range> section = new ArrayList<Range>();
        section.add(new Range(1, 8, 2));
        section.add(new Range(1, 8, 2));
        RegularLayout index = new RegularLayout(new int[]{10, 10}, 1, 0L, section, -1);
        assert (index.getTotalNelems() == 16L);
        assert (index.getChunkSize() == 1) : index.getChunkSize();
        int count = 0;
        while (index.hasNext()) {
            chunk = index.next();
            y = count / 4;
            x = count % 4;
            assert (chunk.getFilePos() == (long)(10 + 20 * y + 1 + 2 * x)) : chunk.getFilePos() + " " + count;
            ++count;
        }
        section = new ArrayList();
        section.add(new Range(1, 8));
        section.add(new Range(1, 8, 2));
        index = new RegularLayout(new int[]{10, 10}, 1, 0L, section, -1);
        assert (index.getTotalNelems() == 32L);
        assert (index.getChunkSize() == 1) : index.getChunkSize();
        count = 0;
        while (index.hasNext()) {
            chunk = index.next();
            y = count / 4;
            x = count % 4;
            assert (chunk.getFilePos() == (long)(10 * (y + 1) + 1 + 2 * x)) : chunk.getFilePos() + " " + count;
            ++count;
        }
        section = new ArrayList();
        section.add(new Range(1, 8, 2));
        section.add(new Range(1, 8));
        index = new RegularLayout(new int[]{10, 10}, 1, 0L, section, -1);
        assert (index.getTotalNelems() == 32L);
        assert (index.getChunkSize() == 8) : index.getChunkSize();
        count = 0;
        while (index.hasNext()) {
            chunk = index.next();
            assert (chunk.getFilePos() == (long)(10 + 20 * count + 1)) : chunk.getFilePos() + " " + count;
            ++count;
        }
    }

    public void testSectionStrideOriginElemsize() throws InvalidRangeException {
        int x;
        int y;
        Indexer.Chunk chunk;
        int elemSize = 7;
        ArrayList<Range> section = new ArrayList<Range>();
        section.add(new Range(1, 8, 2));
        section.add(new Range(1, 8, 2));
        RegularLayout index = new RegularLayout(new int[]{10, 10}, elemSize, 0L, section, -1);
        assert (index.getTotalNelems() == 16L);
        assert (index.getChunkSize() == 1) : index.getChunkSize();
        int count = 0;
        while (index.hasNext()) {
            chunk = index.next();
            y = count / 4;
            x = count % 4;
            assert (chunk.getFilePos() == (long)((10 + 20 * y + 1 + 2 * x) * elemSize)) : chunk.getFilePos() + " " + count;
            ++count;
        }
        section = new ArrayList();
        section.add(new Range(1, 8));
        section.add(new Range(1, 8, 2));
        index = new RegularLayout(new int[]{10, 10}, elemSize, 0L, section, -1);
        assert (index.getTotalNelems() == 32L);
        assert (index.getChunkSize() == 1) : index.getChunkSize();
        count = 0;
        while (index.hasNext()) {
            chunk = index.next();
            y = count / 4;
            x = count % 4;
            assert (chunk.getFilePos() == (long)((10 * (y + 1) + 1 + 2 * x) * elemSize)) : chunk.getFilePos() + " " + count;
            ++count;
        }
        section = new ArrayList();
        section.add(new Range(1, 8, 2));
        section.add(new Range(1, 8));
        index = new RegularLayout(new int[]{10, 10}, elemSize, 0L, section, -1);
        assert (index.getTotalNelems() == 32L);
        assert (index.getChunkSize() == 8) : index.getChunkSize();
        count = 0;
        while (index.hasNext()) {
            chunk = index.next();
            assert (chunk.getFilePos() == (long)((10 + 20 * count + 1) * elemSize)) : chunk.getFilePos() + " " + count;
            ++count;
        }
    }

    public void testSectionStrideOriginElemsizeRecord() throws InvalidRangeException {
        int x;
        int y;
        Indexer.Chunk chunk;
        int elemSize = 7;
        int recSize = 1000;
        ArrayList<Range> section = new ArrayList<Range>();
        section.add(new Range(1, 8, 2));
        section.add(new Range(1, 8, 2));
        RegularLayout index = new RegularLayout(new int[]{10, 10}, elemSize, 0L, section, recSize);
        assert (index.getTotalNelems() == 16L);
        assert (index.getChunkSize() == 1) : index.getChunkSize();
        int count = 0;
        while (index.hasNext()) {
            chunk = index.next();
            y = count / 4;
            x = count % 4;
            assert (chunk.getFilePos() == (long)(recSize * (1 + 2 * y) + elemSize * (1 + 2 * x))) : chunk.getFilePos() + " " + count + " " + x + " " + y;
            ++count;
        }
        section = new ArrayList();
        section.add(new Range(1, 8));
        section.add(new Range(1, 8, 2));
        index = new RegularLayout(new int[]{10, 10}, elemSize, 0L, section, recSize);
        assert (index.getTotalNelems() == 32L);
        assert (index.getChunkSize() == 1) : index.getChunkSize();
        count = 0;
        while (index.hasNext()) {
            chunk = index.next();
            y = count / 4;
            x = count % 4;
            assert (chunk.getFilePos() == (long)(recSize * (1 + y) + elemSize * (1 + 2 * x))) : chunk.getFilePos() + " " + count + " " + x + " " + y;
            ++count;
        }
        section = new ArrayList();
        section.add(new Range(1, 8, 2));
        section.add(new Range(1, 8));
        index = new RegularLayout(new int[]{10, 10}, elemSize, 0L, section, recSize);
        assert (index.getTotalNelems() == 32L);
        assert (index.getChunkSize() == 8) : index.getChunkSize();
        count = 0;
        while (index.hasNext()) {
            chunk = index.next();
            assert (chunk.getFilePos() == (long)(recSize * (1 + 2 * count) + elemSize)) : chunk.getFilePos() + " " + count;
            ++count;
        }
    }

    private static RegularLayout makeIndexer(int[] varShape, int elemSize, int[] origin, int[] shape, int recSize) throws InvalidRangeException {
        return new RegularLayout(0L, elemSize, recSize, varShape, new Section(origin, shape));
    }

    private static RegularLayout makeIndexer(int[] varShape, int elemSize, Section section, int recSize) throws InvalidRangeException {
        return new RegularLayout(0L, elemSize, recSize, varShape, section);
    }
}

