/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.iosp.bufr.BufrIosp;
import ucar.nc2.iosp.bufr.DataDescriptor;
import ucar.nc2.iosp.bufr.Descriptor;
import ucar.nc2.iosp.bufr.Message;
import ucar.nc2.iosp.bufr.MessageCompressedDataReader;
import ucar.nc2.iosp.bufr.MessageScanner;
import ucar.nc2.iosp.bufr.MessageUncompressedDataReader;
import ucar.nc2.iosp.bufr.TableLookup;
import ucar.unidata.io.RandomAccessFile;

public class Scanner {
    static Map<List<String>, String> mixedSet = new HashMap<List<String>, String>();
    static Map<Message, int[]> badMap = new HashMap<Message, int[]>();
    static Map<Message, Map<String, Counter>> typeMap = new HashMap<Message, Map<String, Counter>>();
    static Map<String, List<Message>> headerMap = new HashMap<String, List<Message>>();
    static Map<String, Counter> headerCount = new HashMap<String, Counter>();
    static int total_msgs;
    static int bad_msgs;
    static int bad_wmo;
    static int bad_tables;
    static int bad_operation;
    static int total_different;
    static int good_msgs;
    static int total_obs;
    static long file_size;
    private static final Pattern wmoPattern;
    static Set<Message> messSet;
    static Map<Message, Counter> messMap;
    static Map<Short, Counter> ddsMap;
    static Map<Short, Counter> descMap;
    static Formatter out;

    static void test(String filename, boolean subdirs, MClosure closure) throws IOException {
        File f = new File(filename);
        if (!f.exists()) {
            System.out.println(filename + " does not exist");
            return;
        }
        if (f.isDirectory()) {
            Scanner.testAllInDir(f, subdirs, closure);
        } else {
            try {
                closure.run(f.getPath());
            }
            catch (Exception ioe) {
                System.out.println("Failed on " + f.getPath() + ": " + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
    }

    static void testAllInDir(File dir, boolean subdirs, MClosure closure) {
        List<File> list = Arrays.asList(dir.listFiles());
        Collections.sort(list);
        for (File f : list) {
            if (f.getName().endsWith("bfx") || f.getName().endsWith("txt") || f.getName().endsWith("zip") || f.getName().endsWith("csh") || f.getName().endsWith("rtf")) continue;
            if (f.isDirectory()) {
                if (!subdirs) continue;
                Scanner.testAllInDir(f, subdirs, closure);
                continue;
            }
            try {
                closure.run(f.getPath());
            }
            catch (Exception ioe) {
                System.out.println("Failed on " + f.getPath() + ": " + ioe.getMessage());
                ioe.printStackTrace();
            }
        }
    }

    static void scanDDS(String filename) throws IOException {
        long start = System.nanoTime();
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        out.format("\nOpen %s size = %d Kb \n", raf.getLocation(), raf.length() / 1000L);
        MessageScanner scan = new MessageScanner(raf);
        int count = 0;
        while (scan.hasNext()) {
            Message m = scan.next();
            if (m == null) continue;
            m.dump(out);
            if (!m.isTablesComplete()) {
                out.format("**INCOMPLETE ", new Object[0]);
            }
            long startPos = m.is.getStartPos();
            out.format(" msg= %d time=%s starts=%d len=%d end=%d dataEnd=%d\n", count, m.getReferenceTime(), startPos, m.is.getBufrLength(), startPos + (long)m.is.getBufrLength(), m.dataSection.getDataPos() + (long)m.dataSection.getDataLength());
            out.format("  ndatasets=%d isCompressed=%s datatype=0x%x header=%s\n", m.getNumberDatasets(), m.dds.isCompressed(), m.dds.getDataType(), m.getHeader());
            ++count;
            break;
        }
        raf.close();
    }

    static int dumpMessages(String filename, int mode) throws IOException {
        long start = System.nanoTime();
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        out.format("\nOpen %s size = %d Kb \n", raf.getLocation(), raf.length() / 1000L);
        MessageScanner scan = new MessageScanner(raf);
        int count = 0;
        while (scan.hasNext()) {
            Message m = scan.next();
            if (m == null) continue;
            if (!m.isTablesComplete()) {
                out.format("**INCOMPLETE ", new Object[0]);
            }
            if (mode >= 0) {
                long startPos = m.is.getStartPos();
                out.format(" msg= %d time=%s starts=%d len=%d end=%d dataEnd=%d hash=[0x%x]\n", count, m.getReferenceTime(), startPos, m.is.getBufrLength(), startPos + (long)m.is.getBufrLength(), m.dataSection.getDataPos() + (long)m.dataSection.getDataLength(), m.hashCode());
                out.format("  ndatasets=%d isCompressed=%s datatype=0x%x header=%s\n", m.getNumberDatasets(), m.dds.isCompressed(), m.dds.getDataType(), m.getHeader());
            }
            if (mode == 2) {
                m.dump(out);
            } else if (mode == 1) {
                m.dumpHeader(out);
            }
            if (mode >= 0) {
                out.format("%n", new Object[0]);
            }
            ++count;
        }
        raf.close();
        long took = System.nanoTime() - start;
        double rate = took > 0L ? 1000000.0 * (double)count / (double)took : 0.0;
        out.format(" nmsgs= %d nobs = %d took %d msecs rate = %f msgs/msec\n", count, scan.getTotalObs(), took / 1000000L, rate);
        return scan.getTotalObs();
    }

    static void scanTimes(String filename) throws IOException {
        long start = System.nanoTime();
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        out.format("\nOpen %s size = %d Kb \n", raf.getLocation(), raf.length() / 1000L);
        MessageScanner scan = new MessageScanner(raf);
        int count = 0;
        while (scan.hasNext()) {
            Message m = scan.next();
            if (m == null) continue;
            out.format(" %s time=%s\n", m.getHeader(), m.getReferenceTime());
            ++count;
        }
        raf.close();
    }

    static void scanMixedMessageTypes(String filename) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        out.format("\n-----\nOpen %s size = %d Kb \n", raf.getLocation(), raf.length() / 1000L);
        MessageScanner scan = new MessageScanner(raf);
        int count = 0;
        while (scan.hasNext()) {
            Message m = scan.next();
            if (m == null) continue;
            List desc = m.dds.getDescriptors();
            String key = mixedSet.get(desc);
            if (null == key) {
                out.format(" new Message Type msg=%d <%s> ndesc=%d hashCode=%d\n", count, m.getHeader(), desc.size(), ((Object)desc).hashCode());
                m.getRootDataDescriptor();
                m.dump(out);
                mixedSet.put(desc, filename);
            } else if (!key.equals(filename)) {
                out.format(" msg type from file= %s, hashcode=%d\n", key, ((Object)desc).hashCode());
            }
            ++count;
        }
        raf.close();
        out.format("nmsgs= %d nobs = %d\n", count, scan.getTotalObs());
    }

    static void scanMessageSizes(String filename, Formatter formatter) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        out.format("\n-----\nOpen %s size = %d Kb \n", raf.getLocation(), raf.length() / 1000L);
        MessageScanner scan = new MessageScanner(raf);
        int count = 0;
        while (scan.hasNext()) {
            boolean ok;
            Message m = scan.next();
            if (m == null) continue;
            if (!m.isTablesComplete()) {
                out.format("Message " + count + " INCOMPLETE TABLES%n", new Object[0]);
                ++count;
                break;
            }
            DataDescriptor root = m.getRootDataDescriptor();
            m.dumpHeader(out);
            m.calcTotalBits(formatter);
            int nbitsCounted = m.getTotalBits();
            int nbitsGiven = 8 * (m.dataSection.getDataLength() - 4);
            boolean bl = ok = Math.abs(m.getCountedDataBytes() - m.dataSection.getDataLength()) <= 1;
            if (!ok) {
                out.format("*** BAD ", new Object[0]);
            }
            long last = m.dataSection.getDataPos() + (long)m.dataSection.getDataLength();
            out.format("Message %d nds=%d compressed=%s vlen=%s countBits= %d givenBits=%d data start=0x%x end=0x%x", count, m.getNumberDatasets(), m.dds.isCompressed(), root.isVarLength(), nbitsCounted, nbitsGiven, m.dataSection.getDataPos(), last);
            out.format(" countBytes= %d dataSize=%d", m.getCountedDataBytes(), m.dataSection.getDataLength());
            out.format("%n", new Object[0]);
            ++count;
        }
        raf.close();
        out.format("nmsgs= %d nobs = %d\n", count, scan.getTotalObs());
    }

    private static void showBytes(Formatter out, RandomAccessFile raf, long start, int count) throws IOException {
        raf.seek(start);
        for (int i = 0; i < count; ++i) {
            out.format("%d=<%d>", i, raf.read());
        }
    }

    static void scanMessageTypes(String filename) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        file_size += raf.length();
        MessageScanner scan = new MessageScanner(raf);
        int count = 0;
        while (scan.hasNext()) {
            Counter c;
            Message m;
            block12: {
                m = scan.next();
                if (m == null) {
                    ++bad_msgs;
                    continue;
                }
                try {
                    if (m.isTablesComplete()) break block12;
                    int[] nbad = badMap.get(m);
                    if (nbad == null) {
                        nbad = new int[1];
                        badMap.put(m, nbad);
                    }
                    nbad[0] = nbad[0] + 1;
                    ++bad_tables;
                }
                catch (UnsupportedOperationException e) {
                    m.dumpHeader(out);
                    ++bad_operation;
                    continue;
                }
            }
            String ttaaii = Scanner.extractWMO(m.getHeader());
            if (ttaaii == null) {
                ++bad_wmo;
                continue;
            }
            Map<String, Counter> keys = typeMap.get(m);
            if (null == keys) {
                keys = new HashMap<String, Counter>();
                keys.put(ttaaii, new Counter(ttaaii));
                typeMap.put(m, keys);
            }
            if ((c = keys.get(ttaaii)) == null) {
                c = new Counter(ttaaii);
                keys.put(ttaaii, c);
            }
            ++c.count;
            c.countObs += m.getNumberDatasets();
            List<Message> mtypes = headerMap.get(ttaaii);
            if (mtypes == null) {
                mtypes = new ArrayList<Message>();
                headerMap.put(ttaaii, mtypes);
                mtypes.add(m);
            } else if (!mtypes.contains(m)) {
                mtypes.add(m);
                ++total_different;
            }
            Counter hc = headerCount.get(ttaaii);
            if (hc == null) {
                hc = new Counter(ttaaii);
                headerCount.put(ttaaii, hc);
            }
            ++hc.count;
            ++count;
        }
        raf.close();
        out.format(filename + " total_msgs= %d good=%d total_obs = %d\n", scan.getTotalMessages(), count, scan.getTotalObs());
        total_msgs += scan.getTotalMessages();
        good_msgs += count;
        total_obs += scan.getTotalObs();
    }

    static void showTypes(Formatter csv) throws IOException {
        List<Message> msgs;
        out.format("\n===============================================\n", new Object[0]);
        out.format("total_msgs=%d good_msgs=%d bad_msgs=%d incomplete_tables=%d bad_operation=%d total_obs=%d\n", total_msgs, good_msgs, bad_msgs, bad_tables, bad_operation, total_obs);
        int avg_msg = (int)(file_size / (long)total_msgs);
        int avg_obs = total_obs / total_msgs;
        out.format("total_bytes=%d avg_msg_size=%d avg_obs/msg=%d \n", file_size, avg_msg, avg_obs);
        int good_dds = typeMap.keySet().size();
        int bad_dds = badMap.keySet().size();
        int total_wmo = headerMap.keySet().size();
        out.format(" good_dds=%d good_msgs=%d\n", good_dds, good_msgs);
        out.format(" incomplete_dds=%d incomplete_msgs=%d\n", bad_dds, bad_tables);
        out.format(" wmoHeaders=%d bad_wmo=%d wmo_multipleDDS=%d\n", total_wmo, bad_wmo, total_different);
        out.format("\nIncomplete Tables\n", new Object[0]);
        for (Message m : badMap.keySet()) {
            int[] nbad = badMap.get(m);
            out.format(" nbad messages = %d\n", nbad[0]);
            m.dumpHeader(out);
            out.format(" missing keys= ", new Object[0]);
            m.showMissingFields(out);
            out.format("\n\n", new Object[0]);
        }
        out.format("\n", new Object[0]);
        if (csv != null) {
            csv.format("hash, header, nMess, nObs, complete, center, table, edition, category %n", new Object[0]);
        }
        out.format("Map dds -> wmoHeaders\n", new Object[0]);
        for (Message m : typeMap.keySet()) {
            out.format(" [0x%x] ", m.hashCode());
            m.dumpHeaderShort(out);
            int totalm = 0;
            int totalo = 0;
            Map<String, Counter> keys = typeMap.get(m);
            for (String key : keys.keySet()) {
                Counter cc = keys.get(key);
                out.format("  %s count=%d\n", key, cc.count);
                totalm += cc.count;
                totalo += cc.countObs;
            }
            if (csv == null) continue;
            csv.format("Ox%x, %s, %d, %d, %s, %s, %s, %s, %s %n", m.hashCode(), Scanner.extractWMO(m.getHeader()), totalm, totalo, m.isTablesComplete(), m.getCenterNo(), m.getTableName(), m.is.getBufrEdition(), m.getCategoryNo());
        }
        int nwmo = 0;
        int total_wmo_count = 0;
        out.format("\nMap wmoHeaders -> dds (unique)\n", new Object[0]);
        Set<String> headerSet = headerMap.keySet();
        ArrayList<String> headers = new ArrayList<String>();
        headers.addAll(headerSet);
        Collections.sort(headers);
        for (String wmo : headers) {
            msgs = headerMap.get(wmo);
            if (msgs.size() > 1) continue;
            Message m = msgs.get(0);
            Counter hc = headerCount.get(Scanner.extractWMO(m.getHeader()));
            int count = hc == null ? 0 : hc.count;
            out.format(" WMO %s (%d) cat= %s (%s), center = %s (%s) [0x%x]\n", wmo, count, m.getCategoryName(), m.getCategoryNo(), m.getCenterName(), m.getCenterNo(), m.hashCode());
            total_wmo_count += count;
            ++nwmo;
        }
        out.format("  nwmo=%d total_wmo_count=%d %n", nwmo, total_wmo_count);
        out.format("\nMap wmoHeaders -> dds (multiple)\n", new Object[0]);
        for (String wmo : headers) {
            msgs = headerMap.get(wmo);
            if (msgs.size() <= 1) continue;
            out.format("--WMO %s has %d types %n", wmo, msgs.size());
        }
        for (String wmo : headers) {
            msgs = headerMap.get(wmo);
            if (msgs.size() <= 1) continue;
            out.format("--WMO %s has %d types %n", wmo, msgs.size());
            for (Message m : msgs) {
                Counter hc = headerCount.get(Scanner.extractWMO(m.getHeader()));
                int count = hc == null ? 0 : hc.count;
                m.dumpHeader(out);
                out.format(" hash=%d\n\n", m.hashCode());
            }
        }
    }

    static String extractWMO2(String header) {
        int pos3;
        int pos2;
        String result;
        char first;
        StringTokenizer stoker = new StringTokenizer(header);
        if (stoker.hasMoreTokens()) {
            stoker.nextToken();
        }
        if (stoker.hasMoreTokens() && ((first = (result = stoker.nextToken()).charAt(0)) == 'I' || first == 'J')) {
            return result;
        }
        int pos = header.lastIndexOf(32);
        if (pos > 0 && (pos2 = header.lastIndexOf(32, pos - 1)) > 0 && (pos3 = header.lastIndexOf(32, pos2 - 1)) > 0) {
            return header.substring(pos3 + 1, pos2);
        }
        out.format("***header= %s\n", header);
        return null;
    }

    static String extractWMO(String header) {
        Matcher matcher = wmoPattern.matcher(header);
        if (!matcher.matches()) {
            return null;
        }
        return matcher.group(1);
    }

    static String extractWMO3(String header) {
        int pos2;
        int pos1 = header.indexOf(73);
        int pos = Math.min(pos1, pos2 = header.indexOf(74));
        if (pos < 0) {
            pos = Math.max(pos1, pos2);
        }
        if (pos < 0) {
            out.format("***header= %s\n", header);
            return null;
        }
        header = header.substring(pos);
        return header;
    }

    static void writeUniqueDDS(String filename, WritableByteChannel wbc) throws IOException {
        System.out.printf("open %s ", filename);
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        MessageScanner scan = new MessageScanner(raf);
        int count = 0;
        while (scan.hasNext()) {
            Message m = scan.next();
            if (m == null) {
                ++bad_msgs;
                System.out.printf("Bad Message%n", new Object[0]);
                continue;
            }
            if (!messSet.contains(m)) {
                scan.writeCurrentMessage(wbc);
                messSet.add(m);
            }
            ++count;
        }
        raf.close();
        System.out.printf(" read  = %d%n ", count);
    }

    static void scanMessageDDS(String filename) throws IOException {
        RandomAccessFile raf = new RandomAccessFile(filename, "r");
        file_size += raf.length();
        MessageScanner scan = new MessageScanner(raf);
        int count = 0;
        while (scan.hasNext()) {
            Message m;
            block6: {
                m = scan.next();
                if (m == null) {
                    ++bad_msgs;
                    continue;
                }
                try {
                    if (m.isTablesComplete()) break block6;
                    int[] nbad = badMap.get(m);
                    if (nbad == null) {
                        nbad = new int[1];
                        badMap.put(m, nbad);
                    }
                    nbad[0] = nbad[0] + 1;
                    ++bad_tables;
                }
                catch (UnsupportedOperationException e) {
                    m.dumpHeader(out);
                    ++bad_operation;
                    continue;
                }
            }
            String ttaaii = Scanner.extractWMO(m.getHeader());
            Counter c = messMap.get(m);
            if (null == c) {
                c = new Counter(ttaaii);
                c.m = m;
                messMap.put(m, c);
                Scanner.addDDS(ttaaii, m, m.getRootDataDescriptor());
                Scanner.addDesc(m, m.dds.getDescriptors());
            }
            ++c.count;
            c.countObs += m.getNumberDatasets();
            c.countBytes = (int)((long)c.countBytes + m.getMessageSize());
            ++count;
        }
        raf.close();
        out.format("total_msgs= %d good=%d total_obs = %d\n", scan.getTotalMessages(), count, scan.getTotalObs());
        total_msgs += scan.getTotalMessages();
        good_msgs += count;
        total_obs += scan.getTotalObs();
    }

    static void addDDS(String ttaaii, Message m, DataDescriptor parent) {
        for (DataDescriptor dkey : parent.getSubKeys()) {
            Counter c = ddsMap.get(dkey.fxy);
            if (null == c) {
                c = new Counter(ttaaii);
                c.dkey = dkey;
                c.m = m;
                ddsMap.put(dkey.fxy, c);
            }
            ++c.count;
            if (dkey.getSubKeys() == null) continue;
            Scanner.addDDS(ttaaii, m, dkey);
        }
    }

    private static List<DataDescriptor> addDesc(Message m, List<String> keyDesc) {
        if (keyDesc == null) {
            return null;
        }
        TableLookup lookup = m.getTableLookup();
        ArrayList<DataDescriptor> keys = new ArrayList<DataDescriptor>();
        for (String desc : keyDesc) {
            short key = Descriptor.getFxy((String)desc);
            DataDescriptor dd = new DataDescriptor(key, lookup);
            Counter c = descMap.get(dd.fxy);
            if (null == c) {
                c = new Counter(desc);
                c.m = m;
                descMap.put(dd.fxy, c);
            }
            ++c.count;
            if (dd.f != 3) continue;
            List subDesc = lookup.getDescriptorsTableD(dd.getFxyName());
            Scanner.addDesc(m, subDesc);
        }
        return keys;
    }

    static void showDDS(Formatter messCsv, Formatter ddsCsv) throws IOException {
        out.format("\n===============================================\n", new Object[0]);
        out.format("total_msgs=%d good_msgs=%d bad_msgs=%d incomplete_tables=%d bad_operation=%d total_obs=%d\n", total_msgs, good_msgs, bad_msgs, bad_tables, bad_operation, total_obs);
        int avg_msg = (int)(file_size / (long)total_msgs);
        int avg_obs = total_obs / total_msgs;
        out.format("total_bytes=%d avg_msg_size=%d avg_obs/msg=%d \n", file_size, avg_msg, avg_obs);
        int good_dds = messMap.keySet().size();
        int bad_dds = badMap.keySet().size();
        out.format(" good_dds=%d good_msgs=%d\n", good_dds, good_msgs);
        out.format(" incomplete_dds=%d incomplete_msgs=%d\n", bad_dds, bad_tables);
        ArrayList<Counter> cc = new ArrayList<Counter>(messMap.values());
        Collections.sort(cc);
        out.format("Unique message DDS\n", new Object[0]);
        if (messCsv != null) {
            messCsv.format("header, nMess, nObs, Kbytes, hash, center, table, edition, category %n", new Object[0]);
        }
        for (Counter c : cc) {
            c.m.dumpHeader(out);
            out.format(" %s [0x%x] ", c.s, c.m.hashCode());
            out.format(" Count msg=%d obs=%d bytes=%d %n%n", c.count, c.countObs, c.countBytes);
            if (messCsv == null) continue;
            messCsv.format("%s, %d, %d, %d, 0x%x, %s, %s, %s, %s %n", c.s, c.count, c.countObs, c.countBytes / 1000, c.m.hashCode(), Scanner.scrub(c.m.getCenterName()), c.m.getTableName(), c.m.is.getBufrEdition(), Scanner.scrub(c.m.getCategoryFullName()));
        }
        ArrayList<Counter> ddsCollection = new ArrayList<Counter>(ddsMap.values());
        Collections.sort(ddsCollection, new CompareDDS());
        out.format("DataDescriptors\n", new Object[0]);
        for (Counter c : ddsCollection) {
            out.format(" %d %10s %s [0x%x] %n", c.count, c.dkey.getFxyName(), c.s, c.m.hashCode());
        }
        ArrayList<Short> descCollection = new ArrayList<Short>(descMap.keySet());
        Collections.sort(descCollection);
        out.format("%n%nRaw Descriptors%n", new Object[0]);
        if (ddsCsv != null) {
            ddsCsv.format("fxy, name, count, header, table, center %n", new Object[0]);
        }
        for (Short fxy : descCollection) {
            Counter c = descMap.get(fxy);
            out.format(" %5d %-10s %n", c.count, Descriptor.makeString((short)fxy));
            if (ddsCsv == null) continue;
            ddsCsv.format("'%s', %s, %d, %s, %s, %s%n", Descriptor.makeString((short)fxy), Scanner.scrub(Descriptor.getName((short)fxy, (TableLookup)c.m.getTableLookup())), c.count, Scanner.extractWMO(c.m.getHeader()), c.m.getTableName(), Scanner.scrub(c.m.getCenterName()));
        }
    }

    private static String scrub(String s) {
        return s.replace(',', ' ');
    }

    private static String makeName(String name) {
        return name == null ? "" : Scanner.scrub(name);
    }

    static void scanReader(String filein) throws IOException {
        Formatter f = new Formatter(System.out);
        RandomAccessFile raf = new RandomAccessFile(filein, "r");
        MessageScanner scan = new MessageScanner(raf);
        while (scan.hasNext()) {
            MessageUncompressedDataReader reader;
            Message m = scan.next();
            m.dumpHeader(out);
            if (!m.dds.isCompressed()) {
                reader = new MessageUncompressedDataReader();
                reader.readData(null, m, raf, null, false, null);
            } else {
                reader = new MessageCompressedDataReader();
                reader.readData(null, m, raf, null, f);
            }
            int nbitsGiven = 8 * (m.dataSection.getDataLength() - 4);
            System.out.printf("nbits counted = %d expected=%d %n", m.msg_nbits, nbitsGiven);
            System.out.printf("nbytes counted = %d expected=%d %n", m.getCountedDataBytes(), m.dataSection.getDataLength());
            if (!m.isTablesComplete() || m.isBitCountOk()) continue;
            System.out.printf("BAD BIT COUNT %n%n", new Object[0]);
        }
    }

    static void scanReader2(String filein) throws IOException, InvalidRangeException {
        System.out.printf("scanReader2 %s%n", filein);
        BufrIosp.doon((String)filein);
    }

    static void extractNthMessage(String filein, int msgno, String fileout) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileout);
        FileChannel wbc = fos.getChannel();
        RandomAccessFile raf = new RandomAccessFile(filein, "r");
        MessageScanner scan = new MessageScanner(raf);
        int count = 0;
        while (scan.hasNext()) {
            Message m = scan.next();
            if (msgno == count) {
                scan.writeCurrentMessage((WritableByteChannel)wbc);
                wbc.close();
                raf.close();
                return;
            }
            ++count;
        }
    }

    static void extractMessageByListhash(String filein, int want, String fileout) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileout);
        FileChannel wbc = fos.getChannel();
        int count = 0;
        RandomAccessFile raf = new RandomAccessFile(filein, "r");
        MessageScanner scan = new MessageScanner(raf);
        while (scan.hasNext()) {
            Message m = scan.next();
            int listHash = ((Object)m.dds.getDataDescriptors()).hashCode();
            if (listHash == want) {
                scan.writeCurrentMessage((WritableByteChannel)wbc);
                wbc.close();
                raf.close();
                System.out.printf("output %d from %s %n", count, filein);
                return;
            }
            ++count;
        }
    }

    static void extractNMessages(String filein, int n, String fileout) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileout);
        FileChannel wbc = fos.getChannel();
        RandomAccessFile raf = new RandomAccessFile(filein, "r");
        MessageScanner scan = new MessageScanner(raf);
        for (int count = 0; scan.hasNext() && count < n; ++count) {
            Message m = scan.next();
            scan.writeCurrentMessage((WritableByteChannel)wbc);
        }
        wbc.close();
        raf.close();
    }

    static void extractFirstMessageWithHeader(String filein, String header, String fileout) throws IOException {
        FileOutputStream fos = new FileOutputStream(fileout);
        FileChannel wbc = fos.getChannel();
        RandomAccessFile raf = new RandomAccessFile(filein, "r");
        MessageScanner scan = new MessageScanner(raf);
        int count = 0;
        while (scan.hasNext()) {
            Message m = scan.next();
            if (m.getHeader().contains(header)) {
                scan.writeCurrentMessage((WritableByteChannel)wbc);
                wbc.close();
                raf.close();
                return;
            }
            ++count;
        }
    }

    static void extractAllWithHeader(String filein, Pattern p, WritableByteChannel wbc) throws IOException {
        System.out.println("extract " + filein);
        RandomAccessFile raf = new RandomAccessFile(filein, "r");
        MessageScanner scan = new MessageScanner(raf);
        while (scan.hasNext()) {
            Message m = scan.next();
            Matcher matcher = p.matcher(m.getHeader());
            if (!matcher.matches()) continue;
            scan.writeCurrentMessage(wbc);
            System.out.println(" found match " + m.getHeader());
        }
        raf.close();
    }

    public static void main(String[] args) throws IOException {
        Scanner.extractMessageByListhash("C:\\data\\formats\\bufrRoy/US058MCUS-BUFtdp.SPOUT_00011_sfc_ship_20091101042700.bufr", 1118454047, "C:\\data\\formats\\bufrRoy/out.bufr");
    }

    static {
        file_size = 0L;
        wmoPattern = Pattern.compile(".*([IJ]..... ....) .*");
        messSet = new HashSet<Message>();
        messMap = new HashMap<Message, Counter>();
        ddsMap = new HashMap<Short, Counter>();
        descMap = new HashMap<Short, Counter>();
        out = new Formatter(System.out);
    }

    private static class CompareDDS
    implements Comparator<Counter> {
        private CompareDDS() {
        }

        @Override
        public int compare(Counter o1, Counter o2) {
            if (o1.dkey == null || o2.dkey == null) {
                System.out.println("HEY");
            }
            return o1.dkey.fxy - o2.dkey.fxy;
        }
    }

    static class Counter
    implements Comparable<Counter> {
        int count;
        int countObs;
        int countBytes;
        String s;
        Message m;
        DataDescriptor dkey;

        Counter(String s) {
            this.s = s;
        }

        public int hashCode() {
            return this.s.hashCode();
        }

        public boolean equals(Object o) {
            if (!(o instanceof Counter)) {
                return false;
            }
            Counter oo = (Counter)o;
            return this.s.equals(oo.s);
        }

        @Override
        public int compareTo(Counter o) {
            return o.countObs - this.countObs;
        }
    }

    static interface MClosure {
        public void run(String var1) throws IOException;
    }
}

