/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.bufr.tables;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.SAXBuilder;
import ucar.unidata.util.StringUtil;

public class CompareTableD {
    final int default_size = 1200;
    String robbt = "C:\\dev\\tds\\bufr\\resources\\resources\\source\\wmo\\verified\\B4M-000-013-D";
    String robbxml = "file:C:/dev/tds/bufr/resources/source/wmo/xml/B4M-000-013-D.xml";
    String bmt = "file:C:/dev/tds/bufr/resources/source/ukmet/original/BUFR_D_080731.xml";
    static Map<Integer, Sequence> bmTable = new TreeMap<Integer, Sequence>();
    static Map<Integer, Sequence> wmoMap = new TreeMap<Integer, Sequence>();
    static Map<Integer, Sequence> map = new TreeMap<Integer, Sequence>();

    public void readBmt() throws IOException {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(this.bmt);
            Element root = doc.getRootElement();
            int count = this.makeBmtTable(root.getChildren("featureCatalogue"));
            System.out.println(" bmt count= " + count);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
    }

    public int makeBmtTable(List<Element> featureCatList) {
        int count = 0;
        for (Element featureCat : featureCatList) {
            List featureCollectList = featureCat.getChildren("featureCollection");
            count += featureCollectList.size();
            for (Element featureCollect : featureCollectList) {
                int f = Integer.parseInt(featureCollect.getChildText("F"));
                int x = Integer.parseInt(featureCollect.getChildText("X"));
                int y = Integer.parseInt(featureCollect.getChildText("Y"));
                String name = featureCollect.getChild("annotation").getChildTextNormalize("documentation");
                int fxy = (f << 16) + (x << 8) + y;
                Sequence seq = new Sequence(x, y, name);
                bmTable.put(fxy, seq);
                List features = featureCollect.getChildren("feature");
                for (Element feature : features) {
                    f = Integer.parseInt(feature.getChildText("F"));
                    x = Integer.parseInt(feature.getChildText("X"));
                    y = Integer.parseInt(feature.getChildText("Y"));
                    name = feature.getChild("annotation").getChildTextNormalize("documentation");
                    fxy = (f << 16) + (x << 8) + y;
                    Feature feat = new Feature(fxy, name);
                    seq.features.add(feat);
                }
            }
        }
        return count;
    }

    String clean(String s) {
        return StringUtil.remove((String)s, (int)32);
    }

    void readWmoCsv(String filename, Map<Integer, Sequence> map) throws IOException {
        BufferedReader dataIS = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(filename), Charset.forName("UTF8")));
        int count = 0;
        int currSeqno = -1;
        Sequence currSeq = null;
        while (true) {
            String[] flds;
            String line = dataIS.readLine();
            ++count;
            if (line == null) break;
            if (line.startsWith("#")) continue;
            if (count == 1) {
                System.out.println("header line == " + line);
                continue;
            }
            int pos1 = line.indexOf(34);
            if (pos1 >= 0) {
                int pos2 = line.indexOf(34, pos1 + 1);
                StringBuffer sb = new StringBuffer(line);
                for (int i = pos1; i < pos2; ++i) {
                    if (sb.charAt(i) != ',') continue;
                    sb.setCharAt(i, ' ');
                }
                line = sb.toString();
            }
            if ((flds = line.split(",")).length < 5) {
                System.out.printf("%d INCOMPLETE line == %s%n", count, line);
                continue;
            }
            int fldidx = 0;
            try {
                String featName;
                int sno = Integer.parseInt(flds[fldidx++]);
                int cat = Integer.parseInt(flds[fldidx++]);
                int seq = Integer.parseInt(flds[fldidx++]);
                String seqName = flds[fldidx++];
                String featno = flds[fldidx++];
                if (featno.trim().length() == 0) {
                    System.out.printf("%d skip line == %s%n", count, line);
                    continue;
                }
                String string = featName = flds.length > 5 ? flds[fldidx++] : "n/a";
                if (currSeqno != seq) {
                    int y = seq % 1000;
                    int w = seq / 1000;
                    int x = w % 100;
                    currSeq = new Sequence(x, y, seqName);
                    wmoMap.put(currSeq.fxy, currSeq);
                    currSeqno = seq;
                }
                int fno = Integer.parseInt(featno);
                int y = fno % 1000;
                int w = fno / 1000;
                int x = w % 100;
                int f = w / 100;
                int fxy = (f << 16) + (x << 8) + y;
                Feature feat = new Feature(fxy, featName);
                currSeq.features.add(feat);
            }
            catch (Exception e) {
                System.out.printf("%d %d BAD line == %s%n", count, fldidx, line);
            }
        }
        int n = map.values().size();
        System.out.printf("%s lines=%d elems=%d%n", filename, count, n);
    }

    public void readTable() throws IOException {
        try {
            SAXBuilder builder = new SAXBuilder();
            Document doc = builder.build(this.robbxml);
            Element root = doc.getRootElement();
            int count = this.makeTable(root.getChildren("sequence"));
            System.out.println(" robb count= " + count);
        }
        catch (JDOMException e) {
            throw new IOException(e.getMessage());
        }
    }

    public int makeTable(List<Element> seqList) {
        int count = 0;
        for (Element seqElem : seqList) {
            int f = Integer.parseInt(seqElem.getAttributeValue("F"));
            int x = Integer.parseInt(seqElem.getAttributeValue("X"));
            int y = Integer.parseInt(seqElem.getAttributeValue("Y"));
            String name = "";
            int fxy = (f << 16) + (x << 8) + y;
            Sequence seq = new Sequence(x, y, name);
            map.put(fxy, seq);
            List elemList = seqElem.getChildren("element");
            for (Element elem : elemList) {
                f = Integer.parseInt(elem.getAttributeValue("F"));
                x = Integer.parseInt(elem.getAttributeValue("X"));
                y = Integer.parseInt(elem.getAttributeValue("Y"));
                name = elem.getChildTextNormalize("name");
                fxy = (f << 16) + (x << 8) + y;
                Feature feat = new Feature(fxy, name);
                seq.features.add(feat);
            }
            ++count;
        }
        return count;
    }

    public void compare(Map<Integer, Sequence> thisMap, Map<Integer, Sequence> thatMap) {
        for (Integer key : thisMap.keySet()) {
            Sequence seq1 = thisMap.get(key);
            Sequence seq2 = thatMap.get(key);
            if (seq2 == null) {
                System.out.printf(" No key %s in second table %n", this.fxy(key));
                continue;
            }
            if (seq1.features.size() != seq2.features.size()) {
                System.out.printf(" key %s size %d != %d %n  ", this.fxy(key), seq1.features.size(), seq2.features.size());
                for (Feature f1 : seq1.features) {
                    System.out.printf(" %s,", f1);
                }
                System.out.printf("%n  ", new Object[0]);
                for (Feature f2 : seq2.features) {
                    System.out.printf(" %s,", f2);
                }
                System.out.printf("%n", new Object[0]);
                continue;
            }
            for (int i = 0; i < seq1.features.size(); ++i) {
                Feature f1;
                f1 = seq1.features.get(i);
                Feature f2 = seq2.features.get(i);
                if (f1.fxy == f2.fxy) continue;
                System.out.printf("  key %s feature %s != %s %n", this.fxy(key), this.fxy(f1.fxy), this.fxy(f2.fxy));
            }
        }
    }

    String fxy(int fxy) {
        int f = fxy >> 16;
        int x = (fxy & 0xFF00) >> 8;
        int y = fxy & 0xFF;
        return f + "-" + x + "-" + y;
    }

    public static void main(String[] args) throws IOException {
        CompareTableD ct = new CompareTableD();
        ct.readWmoCsv("C:/docs/B_TableD.csv", wmoMap);
        ct.readTable();
        System.out.printf("Compare wmoMap to ours %n", new Object[0]);
        ct.compare(wmoMap, map);
        System.out.printf("%nCompare ours to wmoMap %n", new Object[0]);
        ct.compare(map, wmoMap);
    }

    class Feature {
        int fxy;
        String name;

        Feature(int fxy, String name) {
            this.fxy = fxy;
            this.name = name.trim();
        }

        public String toString() {
            return CompareTableD.this.fxy(this.fxy);
        }
    }

    class Sequence {
        int fxy;
        String name;
        List<Feature> features;

        Sequence(int x, int y, String name) {
            this.fxy = 196608 + (x << 8) + y;
            this.name = name.trim();
            this.features = new ArrayList<Feature>(10);
        }
    }
}

