/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.gini;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;

public class TestGini
extends TestCase {
    public static String compressGini = TestAll.cdmLocalTestDataDir + "gini/n0r_20041013_1852-compress";
    public static String uncompressGini = TestAll.cdmLocalTestDataDir + "gini/n0r_20041013_1852-uncompress";
    public static String compress_n1p = TestAll.cdmLocalTestDataDir + "gini/n1p_20041206_2140";
    public static String compress_ntp = TestAll.cdmLocalTestDataDir + "gini/ntp_20041206_2154";
    public static String satelliteAK_IR = TestAll.cdmLocalTestDataDir + "gini/AK-NATIONAL_8km_IR_20050912_2345.gini";
    public static String satellitePR_IR = TestAll.cdmLocalTestDataDir + "gini/PR-REGIONAL_4km_12.0_20050922_0600.gini";
    public static String satelliteHI10km_Sound = TestAll.cdmLocalTestDataDir + "gini/HI-NATIONAL_10km_SOUND-6.51_20050918_1824.gini";
    public static String satelliteHI14km_IR = TestAll.cdmLocalTestDataDir + "gini/HI-NATIONAL_14km_IR_20050918_2000.gini";
    public static String satelliteHI4km_IR = TestAll.cdmLocalTestDataDir + "gini/HI-REGIONAL_4km_IR_20050919_1315.gini";
    public static String satelliteSuper1km_PW = TestAll.cdmLocalTestDataDir + "gini/SUPER-NATIONAL_1km_PW_20050923_1400.gini";
    public static String satelliteSuper1km_SFT = TestAll.cdmLocalTestDataDir + "gini/SUPER-NATIONAL_1km_SFC-T_20050912_1900.gini";
    public static String satelliteSuper8km_IR = TestAll.cdmLocalTestDataDir + "gini/SUPER-NATIONAL_8km_IR_20050911_2345.gini";
    public static String satelliteEast_4km_12 = TestAll.cdmLocalTestDataDir + "gini/EAST-CONUS_4km_12.0_20050912_0600.gini";
    public static String satelliteEast_8km_13 = TestAll.cdmLocalTestDataDir + "gini/EAST-CONUS_8km_13.3_20050912_2240.gini";
    public static String satelliteWest_4km_39 = TestAll.cdmLocalTestDataDir + "gini/WEST-CONUS_4km_3.9_20050912_2130.gini";
    public static boolean dumpFile = false;

    public void testGiniReadCompressed() throws IOException {
        Variable v = null;
        System.out.println("**** Open " + compressGini);
        NetcdfFile ncfile = NetcdfFile.open((String)compressGini);
        v = ncfile.findVariable("Reflectivity");
        assert (null != v.getDimension(0));
        assert (null != v.getDimension(1));
        this.testReadData(v);
        ncfile.close();
    }

    public void testGiniReadUnCompressed() throws IOException {
        Variable v = null;
        System.out.println("**** Open " + uncompressGini);
        NetcdfFile ncfile = NetcdfFile.open((String)uncompressGini);
        v = ncfile.findVariable("Reflectivity");
        assert (null != v.getDimension(0));
        assert (null != v.getDimension(1));
        this.testReadData(v);
        ncfile.close();
    }

    public void testGiniReadCompress_n1p() throws IOException {
        Variable v = null;
        System.out.println("**** Open " + compress_n1p);
        NetcdfFile ncfile = NetcdfFile.open((String)compress_n1p);
        v = ncfile.findVariable("Precipitation");
        assert (null != v.getDimension(0));
        assert (null != v.getDimension(1));
        this.testReadData(v);
        ncfile.close();
    }

    public void testGiniReadCompress_ntp() throws IOException {
        Variable v = null;
        System.out.println("**** Open " + compress_ntp);
        NetcdfFile ncfile = NetcdfFile.open((String)compress_ntp);
        v = ncfile.findVariable("Precipitation");
        assert (null != v.getDimension(0));
        assert (null != v.getDimension(1));
        this.testReadData(v);
        ncfile.close();
    }

    public void testGiniReadSatelliteAK_IR() throws IOException {
        Variable v = null;
        System.out.println("**** Open " + satelliteAK_IR);
        NetcdfFile ncfile = NetcdfFile.open((String)satelliteAK_IR);
        v = ncfile.findVariable("IR");
        assert (null != v.getDimension(0));
        assert (null != v.getDimension(1));
        this.testReadData(v);
        ncfile.close();
    }

    public void testGiniReadSatellitePR_IR() throws IOException {
        Variable v = null;
        System.out.println("**** Open " + satellitePR_IR);
        NetcdfFile ncfile = NetcdfFile.open((String)satellitePR_IR);
        v = ncfile.findVariable("IR");
        assert (null != v.getDimension(0));
        assert (null != v.getDimension(1));
        this.testReadData(v);
        ncfile.close();
    }

    public void testGiniReadSatelliteHI10km_Sound() throws IOException {
        Variable v = null;
        System.out.println("**** Open " + satelliteHI10km_Sound);
        NetcdfFile ncfile = NetcdfFile.open((String)satelliteHI10km_Sound);
        v = ncfile.findVariable("sounder_imagery");
        assert (null != v.getDimension(0));
        assert (null != v.getDimension(1));
        this.testReadData(v);
        ncfile.close();
    }

    public void testGiniReadSatelliteHI14km_IR() throws IOException {
        Variable v = null;
        System.out.println("**** Open " + satelliteHI14km_IR);
        NetcdfFile ncfile = NetcdfFile.open((String)satelliteHI14km_IR);
        v = ncfile.findVariable("IR");
        assert (null != v.getDimension(0));
        assert (null != v.getDimension(1));
        this.testReadData(v);
        ncfile.close();
    }

    public void testGiniReadSatelliteHI4km_IR() throws IOException {
        Variable v = null;
        System.out.println("**** Open " + satelliteHI4km_IR);
        NetcdfFile ncfile = NetcdfFile.open((String)satelliteHI4km_IR);
        v = ncfile.findVariable("IR");
        assert (null != v.getDimension(0));
        assert (null != v.getDimension(1));
        this.testReadData(v);
        ncfile.close();
    }

    public void testGiniReadSatelliteSuper1km_PW() throws IOException {
        Variable v = null;
        System.out.println("**** Open " + satelliteSuper1km_PW);
        NetcdfFile ncfile = NetcdfFile.open((String)satelliteSuper1km_PW);
        v = ncfile.findVariable("PW");
        assert (null != v.getDimension(0));
        assert (null != v.getDimension(1));
        this.testReadData(v);
        ncfile.close();
    }

    public void testGiniReadSatelliteSuper1km_SFT() throws IOException {
        Variable v = null;
        System.out.println("**** Open " + satelliteSuper1km_SFT);
        NetcdfFile ncfile = NetcdfFile.open((String)satelliteSuper1km_SFT);
        v = ncfile.findVariable("SFC_T");
        assert (null != v.getDimension(0));
        assert (null != v.getDimension(1));
        this.testReadData(v);
        ncfile.close();
    }

    public void testGiniReadSatelliteSuper8km_IR() throws IOException {
        Variable v = null;
        System.out.println("**** Open " + satelliteSuper8km_IR);
        NetcdfFile ncfile = NetcdfFile.open((String)satelliteSuper8km_IR);
        v = ncfile.findVariable("IR");
        assert (null != v.getDimension(0));
        assert (null != v.getDimension(1));
        this.testReadData(v);
        ncfile.close();
    }

    public void testGiniReadSatelliteEast_4km_12() throws IOException {
        Variable v = null;
        System.out.println("**** Open " + satelliteEast_4km_12);
        NetcdfFile ncfile = NetcdfFile.open((String)satelliteEast_4km_12);
        v = ncfile.findVariable("IR");
        assert (null != v.getDimension(0));
        assert (null != v.getDimension(1));
        this.testReadData(v);
        ncfile.close();
    }

    public void testGiniReadSatelliteEast_8km_13() throws IOException {
        Variable v = null;
        System.out.println("**** Open " + satelliteEast_8km_13);
        NetcdfFile ncfile = NetcdfFile.open((String)satelliteEast_8km_13);
        v = ncfile.findVariable("IR");
        assert (null != v.getDimension(0));
        assert (null != v.getDimension(1));
        this.testReadData(v);
        ncfile.close();
    }

    public void testGiniReadSatelliteWest_4km_39() throws IOException {
        Variable v = null;
        System.out.println("**** Open " + satelliteWest_4km_39);
        NetcdfFile ncfile = NetcdfFile.open((String)satelliteWest_4km_39);
        v = ncfile.findVariable("IR");
        assert (null != v.getDimension(0));
        assert (null != v.getDimension(1));
        this.testReadData(v);
        ncfile.close();
    }

    private void testReadData(Variable v) throws IOException {
        Array a = null;
        assert (null != v);
        assert (null != v.getDimension(0));
        a = v.read();
        assert (null != a);
        assert (v.getSize() == a.getSize());
    }
}

