/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.iosp.IOServiceProvider;
import ucar.nc2.iosp.grib.GribGridServiceProvider;
import ucar.nc2.util.CancelTask;
import ucar.nc2.util.CompareNetcdf;
import ucar.unidata.io.RandomAccessFile;

public class TestGridGribIosp
extends TestCase {
    public TestGridGribIosp(String name) {
        super(name);
    }

    public void testCompare() throws IOException {
        File where = new File("C:/data/grib/idd");
        if (where.exists()) {
            String[] args = new String[]{"C:/data/grib/idd"};
            this.doAll(args);
        } else {
            this.doAll(null);
        }
    }

    void compareNC(String fileBinary, String fileText) throws IOException {
        long start = System.currentTimeMillis();
        Class<GribGridServiceProvider> c = GribGridServiceProvider.class;
        IOServiceProvider spiB = null;
        try {
            spiB = (IOServiceProvider)c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IOException("IOServiceProvider " + c.getName() + "must have no-arg constructor.");
        }
        catch (IllegalAccessException e) {
            throw new IOException("IOServiceProvider " + c.getName() + " IllegalAccessException: " + e.getMessage());
        }
        RandomAccessFile rafB = new RandomAccessFile(fileBinary, "r");
        rafB.order(0);
        NetcdfFileSPI ncfileBinary = new NetcdfFileSPI(spiB, rafB, fileBinary, null);
        System.out.println("Binary Netcdf created");
        start = System.currentTimeMillis();
        IOServiceProvider spiT = null;
        try {
            spiT = (IOServiceProvider)c.newInstance();
        }
        catch (InstantiationException e) {
            throw new IOException("IOServiceProvider " + c.getName() + "must have no-arg constructor.");
        }
        catch (IllegalAccessException e) {
            throw new IOException("IOServiceProvider " + c.getName() + " IllegalAccessException: " + e.getMessage());
        }
        RandomAccessFile rafT = new RandomAccessFile(fileText, "r");
        rafT.order(0);
        NetcdfFileSPI ncfileText = new NetcdfFileSPI(spiT, rafT, fileText, null);
        System.out.println("Text Netcdf created");
        CompareNetcdf.compareFiles((NetcdfFile)ncfileBinary, (NetcdfFile)ncfileText, (boolean)false, (boolean)true, (boolean)false);
        ncfileBinary.close();
        ncfileText.close();
    }

    void doAll(String[] args) throws IOException {
        String dirB2;
        String dirB1;
        if (args == null || args.length < 1) {
            dirB1 = TestAll.testdataDir + "test/motherlode/grid/grib/binary";
            dirB2 = TestAll.testdataDir + "test/motherlode/grid/grib/text";
        } else {
            dirB1 = args[0] + "/binary";
            dirB2 = args[0] + "/text";
        }
        File dir = new File(dirB1);
        if (dir.isDirectory()) {
            String[] children;
            System.out.println("In directory " + dir.getParent() + "/" + dir.getName());
            for (String child : children = dir.list()) {
                File aChild = new File(dir, child);
                if (aChild.isDirectory() || child.contains("ECMWF") || child.contains("1p25") || child.contains("OCEAN") || child.contains("SPECTRAL") || child.contains("SST") || child.contains("ukm") || child.contains("UKM") || child.contains("Ensemble") || child.endsWith("gbx") || child.endsWith("gbx8") || child.endsWith("xml") || child.endsWith("tmp") || child.length() == 0) continue;
                System.out.println("\n\nComparing File " + child);
                this.compareNC(dirB1 + "/" + child, dirB2 + "/" + child);
            }
        }
    }

    public static void main(String[] args) throws IOException {
        TestGridGribIosp ggi = new TestGridGribIosp("");
        ggi.testCompare();
    }

    private static class NetcdfFileSPI
    extends NetcdfFile {
        NetcdfFileSPI(IOServiceProvider spi, RandomAccessFile raf, String location, CancelTask cancelTask) throws IOException {
            super(spi, raf, location, cancelTask);
        }
    }
}

