/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.grib;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Formatter;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import junit.framework.TestCase;
import ucar.grib.GribGridRecord;
import ucar.grib.grib2.Grib2Tables;
import ucar.grib.grib2.ParameterTable;
import ucar.grid.GridIndex;
import ucar.grid.GridRecord;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.dataset.CoordinateAxis;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.GridCoordSystem;
import ucar.nc2.dt.GridDatatype;
import ucar.nc2.dt.grid.GridDataset;
import ucar.nc2.iosp.grib.GribGridServiceProvider;

public class TestIntervalVars
extends TestCase {
    private boolean show = false;
    public int nfiles = 0;
    public int nvars = 0;
    public int nintVars = 0;

    public TestIntervalVars(String name) {
        super(name);
    }

    public void testCountIntervalVars() throws Exception {
        String dir = TestAll.testdataDir + "cdmUnitTest/tds/new";
        TestAll.actOnAll(dir, new TestAll.FileFilterImpl("grib2"), new TestAll.Act(){

            public int doAct(String filename) throws IOException {
                return TestIntervalVars.this.doTwo(filename);
            }
        });
        System.out.printf("%nnfiles = %d %n", this.nfiles);
        System.out.printf("totvars = %d %n", this.nvars);
        System.out.printf("intVars = %d %n", this.nintVars);
    }

    private int doOne(String filename) throws IOException {
        GridDataset ncd = GridDataset.open((String)filename);
        System.out.printf("Open %s%n", filename);
        ++this.nfiles;
        for (GridDatatype g : ncd.getGrids()) {
            GridCoordSystem gsys = g.getCoordinateSystem();
            CoordinateAxis t = gsys.getTimeAxis();
            VariableDS v = g.getVariable();
            ++this.nvars;
            if (null == v.findAttribute("cell_methods")) continue;
            Attribute param = v.findAttribute("GRIB_product_definition_template");
            System.out.printf(" %s (ntimes=%d) template=%s %n", v.getName(), t.getSize(), param.getNumericValue());
            ++this.nintVars;
        }
        ncd.close();
        return 1;
    }

    private int doTwo(String filename) throws IOException {
        NetcdfFile ncd = NetcdfFile.open((String)filename);
        System.out.printf("%n%s%n", filename);
        GribGridServiceProvider iosp = (GribGridServiceProvider)ncd.getIosp();
        GridIndex index = (GridIndex)iosp.sendIospMessage((Object)"GridIndex");
        HashMap<Integer, Product> pdsSet = new HashMap<Integer, Product>();
        List grList = index.getGridRecords();
        for (GridRecord gr : grList) {
            GribGridRecord ggr = (GribGridRecord)gr;
            int startInterval = ggr.startOfInterval;
            if (startInterval == -9999 || startInterval == 255) continue;
            Product bean = (Product)pdsSet.get(this.makeUniqueId(ggr));
            if (bean == null) {
                bean = new Product(ggr);
                pdsSet.put(this.makeUniqueId(ggr), bean);
            }
            bean.list.add(ggr);
        }
        ArrayList sortList = new ArrayList();
        sortList.addAll(pdsSet.values());
        Collections.sort(sortList);
        for (Product p : sortList) {
            p.sort();
            System.out.printf("  %s (%d)%n", p.name, p.ggr.productTemplate);
            System.out.printf("%s%n", p.doAccumAlgo(false));
        }
        ncd.close();
        return 1;
    }

    private int makeUniqueId(GribGridRecord ggr) {
        int result = 17;
        result += result * 37 + ggr.productTemplate;
        result += result * 37 + ggr.discipline;
        result += result * 37 + ggr.category;
        result += result * 37 + ggr.paramNumber;
        result *= result * 37 + ggr.levelType1;
        return result;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class Product
    implements Comparable<Product> {
        GribGridRecord ggr;
        List<GribGridRecord> list = new ArrayList<GribGridRecord>();
        String name;

        Product(GribGridRecord ggr) {
            this.ggr = ggr;
            this.name = ParameterTable.getParameterName((int)ggr.discipline, (int)ggr.category, (int)ggr.paramNumber) + "/" + Grib2Tables.codeTable4_5((int)ggr.levelType1);
        }

        void sort() {
            Collections.sort(this.list, new Comparator<GribGridRecord>(){

                @Override
                public int compare(GribGridRecord o1, GribGridRecord o2) {
                    return o1.forecastTime - o2.forecastTime;
                }
            });
        }

        private String doAccumAlgo(boolean detail) {
            ArrayList<GribGridRecord> all = new ArrayList<GribGridRecord>(this.list);
            ArrayList<GribGridRecord> hourAccum = new ArrayList<GribGridRecord>(all.size());
            ArrayList<GribGridRecord> runAccum = new ArrayList<GribGridRecord>(all.size());
            HashSet<Integer> ftimes = new HashSet<Integer>();
            for (GribGridRecord rb : all) {
                int ftime = rb.forecastTime;
                ftimes.add(ftime);
                int start = rb.startOfInterval;
                int end = rb.forecastTime;
                if (end - start == 1) {
                    hourAccum.add(rb);
                }
                if (start != 0) continue;
                runAccum.add(rb);
            }
            int n = ftimes.size();
            Formatter f = new Formatter();
            f.format("      all: ", new Object[0]);
            if (detail) {
                this.showList(all, f);
            } else {
                this.testConstantInterval(all, f);
            }
            if (hourAccum.size() > n - 2) {
                for (GribGridRecord rb : hourAccum) {
                    all.remove(rb);
                }
                f.format("hourAccum: ", new Object[0]);
                if (detail) {
                    this.showList(hourAccum, f);
                } else {
                    this.testConstantInterval(hourAccum, f);
                }
            }
            if (runAccum.size() > n - 2) {
                for (GribGridRecord rb : runAccum) {
                    all.remove(rb);
                }
                f.format(" runAccum: ", new Object[0]);
                if (detail) {
                    this.showList(runAccum, f);
                } else {
                    this.testConstantInterval(runAccum, f);
                }
            }
            if (all.size() > 0 && all.size() != this.list.size()) {
                f.format("remaining: ", new Object[0]);
                if (detail) {
                    this.showList(all, f);
                } else {
                    this.testConstantInterval(all, f);
                }
            }
            return f.toString();
        }

        private void showList(List<GribGridRecord> list, Formatter f) {
            f.format("(%d) ", list.size());
            for (GribGridRecord rb : list) {
                f.format(" %d-%d", rb.startOfInterval, rb.forecastTime);
            }
            this.testConstantInterval(list, f);
        }

        private void testConstantInterval(List<GribGridRecord> list, Formatter f) {
            boolean same = true;
            int intv = -1;
            for (GribGridRecord rb : list) {
                int end = rb.forecastTime;
                int start = rb.startOfInterval;
                int intv2 = end - start;
                if (intv2 == 0) continue;
                if (intv < 0) {
                    intv = intv2;
                } else {
                    boolean bl = same = intv == intv2;
                }
                if (same) continue;
                break;
            }
            if (same) {
                f.format(" Interval=%d%n", intv);
            } else {
                f.format(" Mixed%n", new Object[0]);
            }
        }

        @Override
        public int compareTo(Product o) {
            return this.name.compareTo(o.name);
        }
    }
}

