/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.Group;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.Indexer;
import ucar.nc2.iosp.hdf5.H5chunkLayout;
import ucar.nc2.iosp.hdf5.TestH5;
import ucar.nc2.util.CompareNetcdf;

public class TestChunkIndexer
extends TestCase {
    public TestChunkIndexer(String name) {
        super(name);
    }

    public void test() throws InvalidRangeException, IOException {
        NetcdfFile ncfile = TestH5.openH5("IASI/IASI.h5");
        Group root = ncfile.getRootGroup();
        Group g1 = root.findGroup("U-MARF");
        Group g2 = g1.findGroup("EPS");
        Group g3 = g2.findGroup("IASI_xxx_1C");
        Group g4 = g3.findGroup("DATA");
        Variable v2 = g4.findVariable("IMAGE_DATA");
        Array alData = v2.read();
        int[] origin = new int[]{46000, 122};
        int[] shape = new int[]{80, 12};
        Section section = new Section(origin, shape);
        Array data = v2.read(section);
        assert (data.getSize() == section.computeSize());
        H5chunkLayout index = new H5chunkLayout(v2, v2.getDataType(), section);
        assert (index.getTotalNelems() == section.computeSize());
        int count = 0;
        while (index.hasNext()) {
            Indexer.Chunk chunk = index.next();
            ++count;
        }
    }

    public void testSection() throws InvalidRangeException, IOException {
        NetcdfFile ncfile = TestH5.openH5("IASI/IASI_xxx_1C_M02_20070704193256Z_20070704211159Z_N_O_20070704211805Z.h5");
        Variable v2 = ncfile.findVariable("U-MARF/EPS/IASI_xxx_1C/DATA/IMAGE_DATA");
        assert (v2 != null);
        Array allData = v2.read();
        System.out.println("allData.section =" + allData.shapeToString());
        int[] origin = new int[]{100, 100};
        int[] shape = new int[]{10, 300};
        Section section = new Section(origin, shape);
        Array dataSection = v2.read(section);
        System.out.println("dataSection.section =" + dataSection.shapeToString());
        CompareNetcdf.compareData((Array)dataSection, (Array)allData.section(section.getRanges()));
        int[] origin2 = new int[]{100, 100};
        int[] shape2 = new int[]{130, 97};
        int[] stride2 = new int[]{3, 7};
        Section sectionStrided = new Section(origin2, shape2, stride2);
        Array dataSection2 = v2.read(sectionStrided);
        System.out.println("dataSection.sectionStrided =" + dataSection2.shapeToString());
        CompareNetcdf.compareData((Array)dataSection2, (Array)allData.section(sectionStrided.getRanges()));
    }

    public void readSectionStrided() throws InvalidRangeException, IOException {
        NetcdfFile ncfile = TestH5.openH5("IASI/IASI_xxx_1C_M02_20070704193256Z_20070704211159Z_N_O_20070704211805Z.h5");
        Variable v2 = ncfile.findVariable("/U-MARF/EPS/IASI_xxx_1C/DATA/IMAGE_DATA");
        assert (v2 != null);
        int[] origin2 = new int[]{100, 100};
        int[] shape2 = new int[]{130, 97};
        int[] stride2 = new int[]{3, 7};
        Section sectionStrided = new Section(origin2, shape2, stride2);
        Array dataSection2 = v2.read(sectionStrided);
        System.out.println("dataSection.sectionStrided =" + dataSection2.shapeToString());
    }

    public void testa() throws InvalidRangeException, IOException {
        NetcdfFile ncfile = TestH5.openH5("IASI/IASI.h5");
        Variable v2 = ncfile.findVariable("U-MARF/EPS/IASI_xxx_1C/DATA/IMAGE_DATA");
        assert (v2 != null);
        long start = System.currentTimeMillis();
        Array data = v2.read();
        assert (data.getElementType() == Short.TYPE);
        long took = System.currentTimeMillis() - start;
        double rate = 0.001 * (double)data.getSize() / (double)took;
        System.out.println(" that took = " + took + " msec = " + rate + " Mb/sec ");
    }

    public void test2() throws InvalidRangeException, IOException {
        NetcdfFile ncfile = TestH5.openH5("support/uvlstr.h5");
        Group root = ncfile.getRootGroup();
        Variable v2 = root.findVariable("Space1");
        assert (v2 != null);
        Array data = v2.read();
        IndexIterator ii = data.getIndexIterator();
        while (ii.hasNext()) {
            String s = (String)ii.getObjectNext();
            System.out.println(s);
        }
        Section section = new Section().appendRange(new Range(1, 9, 3));
        Array dataSection = data.section(section.getRanges());
        ii = dataSection.getIndexIterator();
        Array data2 = v2.read(section);
        IndexIterator ii2 = data2.getIndexIterator();
        while (ii2.hasNext()) {
            String s = (String)ii2.getObjectNext();
            System.out.println(s);
            String ss = (String)ii.getObjectNext();
            assert (s.equals(ss));
        }
    }

    public void ntest3() throws InvalidRangeException, IOException {
        NetcdfFile ncfile = TestH5.openH5("support/MSG1_8bit_HRV.H5");
        Group root = ncfile.getRootGroup();
        Group g = root.findGroup("image1");
        Variable v2 = g.findVariable("image_data");
        assert (v2 != null);
        Array data = v2.read();
        assert (data.getElementType() == Byte.TYPE);
    }
}

