/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayChar;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.nc2.NCdump;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.Variable;
import ucar.nc2.iosp.hdf5.TestH5;

public class TestH5ReadStructure
extends TestCase {
    File tempFile;
    PrintStream out;

    public TestH5ReadStructure(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.tempFile = File.createTempFile("TestLongOffset", "out");
        this.out = new PrintStream(new FileOutputStream(this.tempFile));
    }

    protected void tearDown() throws Exception {
        this.out.close();
        this.tempFile.delete();
    }

    public void testStructureArray() throws IOException {
        NetcdfFile ncfile = TestH5.openH5("support/cstr.h5");
        Variable v = ncfile.findVariable("Compound String");
        assert (null != v);
        assert (v.getDataType() == DataType.STRUCTURE);
        assert (v instanceof Structure);
        assert (v.getRank() == 1);
        assert (v.getShape()[0] == 10);
        Array data = v.read();
        assert (data.getElementType() == StructureData.class);
        assert (data instanceof ArrayStructure);
        assert (data.getSize() == 10L);
        assert (data.getRank() == 1);
        IndexIterator iter = data.getIndexIterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            assert (o instanceof StructureData);
            StructureData d = (StructureData)o;
            Array arr = d.getArray("a_string");
            assert (arr != null);
            assert (arr.getElementType() == Character.TYPE);
            assert (arr instanceof ArrayChar);
            ArrayChar arrc = (ArrayChar)arr;
            this.out.println(arrc.getString());
            assert (arrc.getString().equals("Astronomy")) : arrc.getString();
            arr = d.getArray("b_string");
            assert (arr != null);
            assert (arr.getElementType() == Character.TYPE);
            assert (arr instanceof ArrayChar);
            arrc = (ArrayChar)arr;
            this.out.println(arrc.getString());
            assert (arrc.getString().equals("Biochemistry")) : arrc.getString();
        }
        ncfile.close();
    }

    public void testStructureArrayChunked() throws IOException {
        Array data;
        NetcdfFile ncfile;
        block23: {
            ncfile = TestH5.openH5("support/cuslab.h5");
            Variable v = ncfile.findVariable("ArrayOfStructures");
            assert (null != v);
            assert (v.getDataType() == DataType.STRUCTURE);
            assert (v instanceof Structure);
            assert (v.getRank() == 1);
            assert (v.getShape()[0] == 30);
            data = null;
            try {
                data = v.read();
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block23;
                throw new AssertionError();
            }
        }
        assert (data.getElementType() == StructureData.class);
        assert (data instanceof ArrayStructure);
        assert (data.getSize() == 30L);
        assert (data.getRank() == 1);
        IndexIterator iter = data.getIndexIterator();
        while (iter.hasNext()) {
            Object o = iter.next();
            assert (o instanceof StructureData) : o;
            StructureData d = (StructureData)o;
            Array arr = d.getArray("a_name");
            assert (arr != null);
            assert (arr.getElementType() == Integer.TYPE);
            assert (arr instanceof ArrayInt);
            NCdump.printArray((Array)arr, (String)"a_name", (PrintStream)this.out, null);
            arr = d.getArray("b_name");
            assert (arr != null);
            assert (arr.getElementType() == Float.TYPE);
            assert (arr instanceof ArrayFloat);
            NCdump.printArray((Array)arr, (String)"b_name", (PrintStream)this.out, null);
            arr = d.getArray("c_name");
            assert (arr != null);
            assert (arr.getElementType() == Double.TYPE);
            assert (arr instanceof ArrayDouble);
            NCdump.printArray((Array)arr, (String)"c_name", (PrintStream)this.out, null);
        }
        Index ima = data.getIndex();
        StructureData sd = (StructureData)data.getObject(ima.set0(29));
        assert (sd.getScalarDouble("c_name") == 9.0) : sd.getScalarDouble("c_name");
        ncfile.close();
    }

    public void testStructureWithArrayMember() throws IOException {
        NetcdfFile ncfile;
        block42: {
            Array arr;
            StructureData d;
            Object o;
            IndexIterator iter;
            int count;
            Array data;
            Variable v;
            block41: {
                ncfile = TestH5.openH5("support/DSwith_array_member.h5");
                v = ncfile.findVariable("ArrayOfStructures");
                v.setCaching(false);
                assert (null != v);
                assert (v.getDataType() == DataType.STRUCTURE);
                assert (v instanceof Structure);
                assert (v.getRank() == 1);
                assert (v.getShape()[0] == 10);
                try {
                    data = v.read(new int[]{4}, new int[]{3});
                    assert (data.getElementType() == StructureData.class);
                    assert (data instanceof ArrayStructure);
                    assert (data.getSize() == 3L) : data.getSize();
                    assert (data.getRank() == 1);
                    count = 0;
                    iter = data.getIndexIterator();
                    while (iter.hasNext()) {
                        o = iter.next();
                        assert (o instanceof StructureData);
                        d = (StructureData)o;
                        arr = d.getArray("a_name");
                        assert (arr != null);
                        assert (arr.getElementType() == Integer.TYPE);
                        assert (arr instanceof ArrayInt);
                        assert (arr.getInt(arr.getIndex()) == 4 + count);
                        NCdump.printArray((Array)arr, (String)"a_name", (PrintStream)this.out, null);
                        arr = d.getArray("b_name");
                        assert (arr != null);
                        assert (arr.getElementType() == Float.TYPE);
                        assert (arr instanceof ArrayFloat);
                        assert (arr.getSize() == 3L);
                        assert (arr.getFloat(arr.getIndex()) == 4.0f + (float)count);
                        NCdump.printArray((Array)arr, (String)"b_name", (PrintStream)this.out, null);
                        ++count;
                    }
                }
                catch (InvalidRangeException e) {
                    assert (false);
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block41;
                    throw new AssertionError();
                }
            }
            try {
                data = v.read();
                assert (data.getElementType() == StructureData.class);
                assert (data instanceof ArrayStructure);
                assert (data.getSize() == 10L);
                assert (data.getRank() == 1);
                count = 0;
                iter = data.getIndexIterator();
                while (iter.hasNext()) {
                    o = iter.next();
                    assert (o instanceof StructureData);
                    d = (StructureData)o;
                    arr = d.getArray("a_name");
                    assert (arr != null);
                    assert (arr.getElementType() == Integer.TYPE);
                    assert (arr instanceof ArrayInt);
                    assert (arr.getInt(arr.getIndex()) == count);
                    NCdump.printArray((Array)arr, (String)"a_name", (PrintStream)this.out, null);
                    arr = d.getArray("b_name");
                    assert (arr != null);
                    assert (arr.getElementType() == Float.TYPE);
                    assert (arr instanceof ArrayFloat);
                    assert (arr.getSize() == 3L);
                    assert (arr.getFloat(arr.getIndex()) == (float)count);
                    NCdump.printArray((Array)arr, (String)"b_name", (PrintStream)this.out, null);
                    ++count;
                }
            }
            catch (IOException e) {
                if ($assertionsDisabled) break block42;
                throw new AssertionError();
            }
        }
        ncfile.close();
    }
}

