/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataIterator;
import ucar.ma2.StructureMembers;
import ucar.nc2.Dimension;
import ucar.nc2.NCdump;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.TestAll;
import ucar.nc2.Variable;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.iosp.hdf5.TestH5;

public class TestH5ReadStructure2
extends TestCase {
    File tempFile;
    PrintStream out;

    public TestH5ReadStructure2(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.tempFile = File.createTempFile("TestLongOffset", "out");
        this.out = new PrintStream(new FileOutputStream(this.tempFile));
    }

    protected void tearDown() throws Exception {
        this.out.close();
        this.tempFile.delete();
    }

    public void testReadH5Structure() throws IOException {
        int a_name = 0;
        String[] b_name = new String[]{"A fight is a contract that takes two people to honor.", "A combative stance means that you've accepted the contract.", "In which case, you deserve what you get.", "  --  Professor Cheng Man-ch'ing"};
        String c_name = "Hello!";
        NetcdfFile ncfile = TestH5.openH5("complex/compound_complex.h5");
        Variable dset = null;
        assert (null != (dset = ncfile.findVariable("CompoundComplex")));
        assert (dset.getDataType() == DataType.STRUCTURE);
        assert (dset.getRank() == 1);
        assert (dset.getSize() == 6L);
        Dimension d = dset.getDimension(0);
        assert (d.getLength() == 6);
        Structure s = (Structure)dset;
        StructureDataIterator iter = s.getStructureIterator();
        while (iter.hasNext()) {
            StructureData sd = iter.next();
            assert (sd.getScalarInt("a_name") == a_name);
            ++a_name;
            assert (sd.getScalarString("c_name").equals(c_name));
            String[] results = sd.getJavaArrayString(sd.findMember("b_name"));
            assert (results.length == b_name.length);
            int count = 0;
            for (String r : results) {
                assert (r.equals(b_name[count++]));
            }
            for (StructureMembers.Member m : sd.getMembers()) {
                Array data = sd.getArray(m);
                NCdump.printArray((Array)data, (String)m.getName(), (PrintStream)this.out, null);
            }
        }
        ncfile.close();
        System.out.println("*** testReadH5Structure ok");
    }

    public void testH5StructureDS() throws IOException {
        int a_name = 0;
        String[] b_name = new String[]{"A fight is a contract that takes two people to honor.", "A combative stance means that you've accepted the contract.", "In which case, you deserve what you get.", "  --  Professor Cheng Man-ch'ing"};
        String c_name = "Hello!";
        NetcdfDataset ncfile = NetcdfDataset.openDataset((String)(TestAll.testdataDir + "hdf5/complex/compound_complex.h5"));
        Variable dset = null;
        assert (null != (dset = ncfile.findVariable("CompoundComplex")));
        assert (dset.getDataType() == DataType.STRUCTURE);
        assert (dset.getRank() == 1);
        assert (dset.getSize() == 6L);
        Dimension d = dset.getDimension(0);
        assert (d.getLength() == 6);
        Structure s = (Structure)dset;
        StructureDataIterator iter = s.getStructureIterator();
        while (iter.hasNext()) {
            StructureData sd = iter.next();
            assert (sd.getScalarInt("a_name") == a_name);
            ++a_name;
            assert (sd.getScalarString("c_name").equals(c_name));
            String[] results = sd.getJavaArrayString(sd.findMember("b_name"));
            assert (results.length == b_name.length);
            int count = 0;
            for (String r : results) {
                assert (r.equals(b_name[count++]));
            }
            for (StructureMembers.Member m : sd.getMembers()) {
                Array data = sd.getArray(m);
                NCdump.printArray((Array)data, (String)m.getName(), (PrintStream)this.out, null);
            }
        }
        ncfile.close();
        System.out.println("*** testH5StructureDS ok");
    }

    public void testReadH5StructureArrayMembers() throws IOException {
        NetcdfFile ncfile = TestH5.openH5("complex/compound_native.h5");
        Variable dset = null;
        assert (null != (dset = ncfile.findVariable("CompoundNative")));
        assert (dset.getDataType() == DataType.STRUCTURE);
        assert (dset.getRank() == 1);
        assert (dset.getSize() == 15L);
        Dimension d = dset.getDimension(0);
        assert (d.getLength() == 15);
        Structure s = (Structure)dset;
        StructureDataIterator iter = s.getStructureIterator();
        while (iter.hasNext()) {
            StructureData sd = iter.next();
            for (StructureMembers.Member m : sd.getMembers()) {
                Array data = sd.getArray(m);
                NCdump.printArray((Array)data, (String)m.getName(), (PrintStream)this.out, null);
            }
        }
        ncfile.close();
        System.out.println("*** testReadH5StructureArrayMembers ok");
    }

    public void testReadOneAtATime() throws IOException, InvalidRangeException {
        NetcdfFile ncfile = TestH5.openH5("IASI/IASI.h5");
        Variable dset = null;
        assert (null != (dset = ncfile.findVariable("U-MARF/EPS/IASI_xxx_1C/DATA/IMAGE_LAT_ARRAY")));
        assert (dset.getDataType() == DataType.STRUCTURE);
        assert (dset.getRank() == 1);
        assert (dset.getSize() == 3600L);
        Dimension d = dset.getDimension(0);
        assert (d.getLength() == 3600);
        Structure s = (Structure)dset;
        StructureData sd = s.readStructure(3599);
        assert (sd.getScalarInt("LAT[0]") == 70862722);
        assert (sd.getScalarInt("LAT[149]") == 85302263);
        for (int i = 3590; i < d.getLength(); ++i) {
            s.readStructure(i);
            System.out.println(" read structure " + i);
        }
        ncfile.close();
        System.out.println("*** testReadIASI ok");
    }

    public void testReadManyAtATime() throws IOException, InvalidRangeException {
        NetcdfFile ncfile = TestH5.openH5("IASI/IASI.h5");
        Variable dset = null;
        assert (null != (dset = ncfile.findVariable("U-MARF/EPS/IASI_xxx_1C/DATA/TIME_DESCR")));
        assert (dset.getDataType() == DataType.STRUCTURE);
        assert (dset.getRank() == 1);
        assert (dset.getSize() == 60L);
        Dimension d = dset.getDimension(0);
        assert (d.getLength() == 60);
        ArrayStructure data = (ArrayStructure)dset.read();
        StructureMembers.Member m = data.getStructureMembers().findMember("EntryName");
        assert (m != null);
        int i = 0;
        while ((long)i < dset.getSize()) {
            String r = data.getScalarString(i, m);
            if (i % 2 == 0 ? !$assertionsDisabled && !r.equals("TIME[" + i / 2 + "]-days") : !$assertionsDisabled && !r.equals("TIME[" + i / 2 + "]-milliseconds")) {
                throw new AssertionError((Object)(r + " at " + i));
            }
            ++i;
        }
        ncfile.close();
        System.out.println("*** testReadManyAtATime ok");
    }
}

