/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.hdf5;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayObject;
import ucar.ma2.DataType;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.iosp.hdf5.TestH5;

public class TestH5Vlength
extends TestCase {
    File tempFile;
    PrintStream out;

    public TestH5Vlength(String name) {
        super(name);
    }

    protected void setUp() throws Exception {
        this.tempFile = File.createTempFile("TestLongOffset", "out");
        this.out = new PrintStream(new FileOutputStream(this.tempFile));
    }

    protected void tearDown() throws Exception {
        this.out.close();
        this.tempFile.delete();
    }

    public void testVlengthAttribute() throws IOException {
        NetcdfFile ncfile = TestH5.openH5("support/vlstra.h5");
        Attribute att = ncfile.findGlobalAttribute("test_scalar");
        assert (null != att);
        assert (!att.isArray());
        assert (att.isString());
        assert (att.getStringValue().equals("This is the string for the attribute"));
        ncfile.close();
    }

    public void testVlengthVariableChunked() throws IOException {
        NetcdfFile ncfile;
        block19: {
            Variable v;
            block18: {
                ncfile = TestH5.openH5("support/uvlstr.h5");
                v = ncfile.findVariable("Space1");
                assert (null != v);
                assert (v.getDataType() == DataType.STRING);
                assert (v.getRank() == 1);
                assert (v.getShape()[0] == 9);
                try {
                    Array data = v.read();
                    assert (data.getElementType() == String.class);
                    assert (data instanceof ArrayObject);
                    IndexIterator iter = data.getIndexIterator();
                    while (iter.hasNext()) {
                        this.out.println(iter.next());
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if ($assertionsDisabled) break block18;
                    throw new AssertionError();
                }
            }
            int[] origin = new int[]{3};
            int[] shape = new int[]{3};
            try {
                Array data2 = v.read(origin, shape);
                Index ima = data2.getIndex();
                assert (data2.getElementType() == String.class);
                assert (data2 instanceof ArrayObject);
                assert (((String)data2.getObject(ima.set(0))).startsWith("testing whether that nation"));
                assert (((String)data2.getObject(ima.set(1))).startsWith("O Gloria inmarcesible!"));
                assert (((String)data2.getObject(ima.set(2))).startsWith("bien germina ya!"));
            }
            catch (IOException e) {
                assert (false);
            }
            catch (InvalidRangeException e) {
                if ($assertionsDisabled) break block19;
                throw new AssertionError();
            }
        }
        ncfile.close();
    }

    public void testVlengthVariable() throws IOException {
        NetcdfFile ncfile;
        block17: {
            Variable v;
            block16: {
                ncfile = TestH5.openH5("support/vlslab.h5");
                v = ncfile.findVariable("Space1");
                assert (null != v);
                assert (v.getDataType() == DataType.STRING);
                assert (v.getRank() == 1);
                assert (v.getShape()[0] == 12);
                try {
                    Array data = v.read();
                    assert (data.getElementType() == String.class);
                    assert (data instanceof ArrayObject);
                    IndexIterator iter = data.getIndexIterator();
                    while (iter.hasNext()) {
                        this.out.println(iter.next());
                    }
                }
                catch (IOException e) {
                    if ($assertionsDisabled) break block16;
                    throw new AssertionError();
                }
            }
            int[] origin = new int[]{4};
            int[] shape = new int[]{1};
            try {
                Array data2 = v.read(origin, shape);
                Index ima = data2.getIndex();
                assert (data2.getElementType() == String.class);
                assert (data2 instanceof ArrayObject);
                assert (((String)data2.getObject(ima.set(0))).equals("Five score and seven years ago our forefathers brought forth on this continent a new nation,"));
            }
            catch (IOException e) {
                assert (false);
            }
            catch (InvalidRangeException e) {
                if ($assertionsDisabled) break block17;
                throw new AssertionError();
            }
        }
        ncfile.close();
    }
}

